/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import org.joml.Vector2i;

public class RenderTarget {
    private final InternalTextureFormat internalFormat;
    private final PixelFormat format;
    private final PixelType type;
    private int width;
    private int height;
    private boolean isValid = true;
    private final int mainTexture;
    private final int altTexture;
    private static final ByteBuffer NULL_BUFFER = null;

    public RenderTarget(Builder builder) {
        this.internalFormat = builder.internalFormat;
        this.format = builder.format;
        this.type = builder.type;
        this.width = builder.width;
        this.height = builder.height;
        int[] nArray = new int[2];
        GlStateManager._genTextures((int[])nArray);
        this.mainTexture = nArray[0];
        this.altTexture = nArray[1];
        boolean bl = builder.internalFormat.getPixelFormat().isInteger();
        this.setupTexture(this.mainTexture, builder.width, builder.height, !bl);
        this.setupTexture(this.altTexture, builder.width, builder.height, !bl);
        GlStateManager._bindTexture((int)0);
    }

    private void setupTexture(int n, int n2, int n3, boolean bl) {
        this.resizeTexture(n, n2, n3);
        IrisRenderSystem.texParameteri(n, 3553, 10241, bl ? 9729 : 9728);
        IrisRenderSystem.texParameteri(n, 3553, 10240, bl ? 9729 : 9728);
        IrisRenderSystem.texParameteri(n, 3553, 10242, 33071);
        IrisRenderSystem.texParameteri(n, 3553, 10243, 33071);
    }

    private void resizeTexture(int n, int n2, int n3) {
        IrisRenderSystem.texImage2D(n, 3553, 0, this.internalFormat.getGlFormat(), n2, n3, 0, this.format.getGlFormat(), this.type.getGlFormat(), NULL_BUFFER);
    }

    void resize(Vector2i vector2i) {
        this.resize(vector2i.x, vector2i.y);
    }

    void resize(int n, int n2) {
        this.requireValid();
        this.width = n;
        this.height = n2;
        this.resizeTexture(this.mainTexture, n, n2);
        this.resizeTexture(this.altTexture, n, n2);
    }

    public InternalTextureFormat getInternalFormat() {
        return this.internalFormat;
    }

    public int getMainTexture() {
        this.requireValid();
        return this.mainTexture;
    }

    public int getAltTexture() {
        this.requireValid();
        return this.altTexture;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void destroy() {
        this.requireValid();
        this.isValid = false;
        GlStateManager._deleteTextures((int[])new int[]{this.mainTexture, this.altTexture});
    }

    private void requireValid() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempted to use a deleted composite render target");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InternalTextureFormat internalFormat = InternalTextureFormat.RGBA8;
        private int width = 0;
        private int height = 0;
        private PixelFormat format = PixelFormat.RGBA;
        private PixelType type = PixelType.UNSIGNED_BYTE;

        private Builder() {
        }

        public Builder setInternalFormat(InternalTextureFormat internalTextureFormat) {
            this.internalFormat = internalTextureFormat;
            return this;
        }

        public Builder setDimensions(int n, int n2) {
            if (n <= 0) {
                throw new IllegalArgumentException("Width must be greater than zero");
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException("Height must be greater than zero");
            }
            this.width = n;
            this.height = n2;
            return this;
        }

        public Builder setPixelFormat(PixelFormat pixelFormat) {
            this.format = pixelFormat;
            return this;
        }

        public Builder setPixelType(PixelType pixelType) {
            this.type = pixelType;
            return this;
        }

        public RenderTarget build() {
            return new RenderTarget(this);
        }
    }
}

