/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.inventory_tabs;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueMap;
import folk.sisby.kaleido.lib.quiltconfig.impl.Comments;
import java.util.Map;

public class InventoryTabsConfig
extends WrappedConfig {
    @Comments(value={@Comment(value={"How many ticks to wait before moving to the next tab when the keybind is held"}), @Comment(value={"Used to smooth out the visual difference between instant screens (like the player inventory) and ping-dependent screens"}), @Comment(value={"Can be lowered for shenanigans"})})
    public int holdTabCooldown = 3;
    @Comments(value={@Comment(value={"Whether to allow interacting with entities through blocks"}), @Comment(value={"More seamless, but may be considered cheating by the server"})})
    public boolean ignoreWalls = true;
    @Comments(value={@Comment(value={"Whether to rotate the player towards the clicked tab"}), @Comment(value={"Less seamless, but trips anti-cheat less often"})})
    public boolean rotatePlayer = false;
    @Comments(value={@Comment(value={"Remove the 1 unit padding in container screens them slightly taller and offset from other screens"}), @Comment(value={"If you're seeing stacks in the wrong places (offset up by 1 unit) on modded containers, turn this off"})})
    public boolean consistentContainers = true;
    @Comment(value={"Strip titles from 6-row container screens to fit them onto minimum-ratio viewports"})
    public boolean compactLargeContainers = false;
    @Comments(value={@Comment(value={"Emits helpful information for setting up this config when joining a world"}), @Comment(value={"Logs all registered screen handler IDs for use in screen overrides"}), @Comment(value={"Logs all registry tab provider contents (blocks etc) to help find bad tabs"})})
    public boolean configLogging = true;
    @Comments(value={@Comment(value={"Whether to log vanilla tab provider contents"}), @Comment(value={"For development purposes, not modpack configuration"})})
    public boolean configLoggingVanilla = false;
    @Comment(value={"Whether to show tabs on screens that aren't specified below"})
    public boolean allowScreensByDefault = true;
    @Comment(value={"Whether to show tabs on the bottom of screens that aren't specified below"})
    public boolean invertTabsByDefault = false;
    @Comments(value={@Comment(value={"How many ticks to keep a tab on-screen for when its block is obstructed."}), @Comment(value={"Prevents tab 'flickering' with specific setups - raising to 4 should be plenty."})})
    @IntegerRange(min=0L, max=5L)
    public int blockRaycastTimeout = 0;
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set whether tabs should be shown on a given screen"}), @Comment(value={""})})
    public Map<String, Boolean> screenOverrides = ValueMap.builder((Object)true).put("minecraft:smoker", (Object)true).build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set the left bound offset for a given screen"}), @Comment(value={"Positive values expand the left boundary, allowing more tabs to be drawn"}), @Comment(value={"null means the player inventory"}), @Comment(value={""})})
    public Map<String, Integer> leftBoundOffsetOverride = ValueMap.builder((Object)0).put("minecraft:loom", (Object)0).build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set the right bound offset for a given screen"}), @Comment(value={"Positive values expand the right boundary, allowing more tabs to be drawn"}), @Comment(value={"null means the player inventory"}), @Comment(value={""})})
    public Map<String, Integer> rightBoundOffsetOverride = ValueMap.builder((Object)0).put("minecraft:loom", (Object)0).build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually choose where to place tabs on a given screen"}), @Comment(value={"false means above, true means below"}), @Comment(value={"null key means the player inventory"}), @Comment(value={""})})
    public Map<String, Boolean> invertedTabsOverride = ValueMap.builder((Object)false).put("minecraft:beacon", (Object)false).build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set the Tab Provider for a given block or tag"}), @Comment(value={"| -Provider ID-        | -Tab Behaviour-                            | -Default Blocks Added-"}), @Comment(value={"| block_shulker_box    | Checks shulker blocked state               | Adds all ShulkerBoxBlocks"}), @Comment(value={"| block_ender_chest    | Unique, checks chest blocked state         | Adds all EnderChestBlocks"}), @Comment(value={"| block_chest          | L/R Multiblock, checks chest blocked state | Adds all AbstractChestBlocks"}), @Comment(value={"| block_unique         | Only one tab can exist per block type      | Adds all CraftingTableBlocks, AnvilBlocks, CartographyTableBlocks, GrindstoneBlocks, LoomBlocks, and StonecutterBlocks"}), @Comment(value={"| block_simple_storage | Sorted alongside other chest-like tabs     | Adds all BarrelBlocks"}), @Comment(value={"| block_simple         | No special logic                           | Adds all BlockWithEntities, except 25 known-bad vanilla block classes - this adds lots of invalid modded blocks!"}), @Comment(value={"| \"\"                   | No tab at all!                             | Use this to disable bad block tabs in your pack"}), @Comment(value={""})})
    public Map<String, String> blockProviderOverrides = ValueMap.builder((Object)"").put("minecraft:crafting_table", (Object)"inventory_tabs:block_unique").put("#minecraft:doors", (Object)"").put("minecraft:fletching_table", (Object)"").build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set the Tab Provider for a given entity or tag"}), @Comment(value={"| -Provider ID- | -Tab Behaviour-                          | -Default Entities Added-"}), @Comment(value={"| entity_sneak  | Uses sneak-interact, checks tamed/riding | Adds all RideableOpenableInventories"}), @Comment(value={"| entity_simple | Checks player isn't riding the entity    | Adds all StorageMinecartEntities"}), @Comment(value={"| \"\"            | No tab at all!                           | Use this to disable bad entity tabs in your pack"}), @Comment(value={""})})
    public Map<String, String> entityProviderOverrides = ValueMap.builder((Object)"").put("minecraft:chest_minecart", (Object)"inventory_tabs:entity_simple").build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Manually set the Tab Provider for a given item or tag"}), @Comment(value={"| -Provider ID- | -Tab Behaviour-                      | -Default Items Added-"}), @Comment(value={"| item_unique   | Only one tab can exist per item type | Adds nothing"}), @Comment(value={"| item_simple   | No special logic                     | Adds nothing"}), @Comment(value={"| \"\"            | No tab at all!                       | Use this to disable bad item tabs in your pack"}), @Comment(value={""})})
    public Map<String, String> itemProviderOverrides = ValueMap.builder((Object)"").put("minecraft:dirt", (Object)"").build();
    @Comments(value={@Comment(value={""}), @Comment(value={"-------------------------------"}), @Comment(value={""}), @Comment(value={"Enable or disable the default added logic for each tab provider (see above)"}), @Comment(value={"Non-registry Tab Providers like player_inventory and vehicle_inventory can't be disabled here"}), @Comment(value={""})})
    public Map<String, Boolean> registryProviderDefaults = ValueMap.builder((Object)true).put("inventory_tabs:block_simple", (Object)true).build();
}

