/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ArchaeologyLootRecipe
implements EmiRecipe {
    private final ClientArchaeologyLootTable loot;
    private final ArrayListMultimap<Float, EmiStack> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final TrimmedTitle title;
    private final float columns = 8.0f;

    public ArchaeologyLootRecipe(ArchaeologyLootRecipeData data) {
        this.loot = data.loot;
        ArrayListMultimap map2 = ArrayListMultimap.create();
        ArrayList<EmiStack> outputsList = new ArrayList<EmiStack>();
        data.map.forEach((weight, item) -> {
            EmiStack stack = EmiStack.of((class_1799)item);
            map2.put(weight, (Object)stack);
            outputsList.add(stack);
        });
        this.lootStacksSorted = map2;
        this.lootStacksSortedSize = this.loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? this.lootStacksSorted.keySet().size() : this.loot.items.size();
        this.outputs = outputsList;
        this.title = data.name;
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.ARCHAEOLOGY_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960("emi_loot", "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        EmiIngredient sand = EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_42689, class_1802.field_43191}));
        EmiIngredient brush = EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_42716}));
        return Arrays.asList(sand, brush);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.isCompact(EMILoot.Type.ARCHAEOLOGY) ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.addText(this.title.title(), 1, 0, 0x404040, false);
        if (EMILootAgnos.isModLoaded(this.loot.id.method_12836())) {
            widgets.addTooltip(LText.components(this.title.rawTitle(), this.loot.id.method_12836()), 0, 0, 144, 10);
        } else {
            widgets.addTooltipText(List.of(this.title.rawTitle()), 0, 0, 144, 10);
        }
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : this.lootStacksSorted.asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight, (Integer)EMILoot.config.chanceDecimalPlaces.get());
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.percentage", fTrim).method_27692(class_124.field_1080)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), Math.max((Integer)EMILoot.config.chanceDecimalPlaces.get() + 1, 2));
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.rolls", fTrim).method_27692(class_124.field_1080)));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public record ArchaeologyLootRecipeData(ClientArchaeologyLootTable loot, ArrayListMultimap<Float, class_1799> map, boolean guaranteed, TrimmedTitle name) {
        public static ArchaeologyLootRecipeData of(ClientArchaeologyLootTable loot) {
            class_5250 rawTitle;
            boolean isGuaranteedNonChance = false;
            if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
                isGuaranteedNonChance = true;
            }
            ArrayListMultimap map2 = ArrayListMultimap.create();
            loot.items.forEach((item, weight) -> map2.put(weight, item));
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                float key = ((Float)iterator.next()).floatValue();
                map2.get((Object)Float.valueOf(key)).sort(Comparator.comparingInt(s -> class_7923.field_41178.method_10206((Object)s.method_7909())));
            }
            String key = "emi_loot.archaeology." + loot.id.toString();
            if (!class_1074.method_4663((String)key)) {
                String[] chestPathTokens;
                StringBuilder archName = new StringBuilder();
                for (String str : chestPathTokens = loot.id.method_12832().split("[/_]")) {
                    if (!archName.isEmpty()) {
                        archName.append(" ");
                    }
                    if (str.length() <= 1) {
                        archName.append(str);
                        continue;
                    }
                    archName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
                }
                if (EMILootAgnos.isModLoaded(loot.id.method_12836())) {
                    rawTitle = LText.translatable("emi_loot.archaeology.unknown_archaeology", archName.toString());
                } else {
                    class_5250 unknown = LText.translatable("emi_loot.archaeology.unknown");
                    rawTitle = LText.translatable("emi_loot.archaeology.unknown_archaeology", LText.literal(archName.toString()).method_27693(" ").method_10852((class_2561)unknown));
                }
                if (EMILoot.config.isLogI18n(EMILoot.Type.ARCHAEOLOGY)) {
                    EMILoot.LOGGER.warn("Untranslated archaeology loot table \"{}\" (key: \"{}\")", (Object)loot.id, (Object)key);
                }
            } else {
                rawTitle = LText.translatable(key);
            }
            TrimmedTitle name = TrimmedTitle.of((class_2561)rawTitle, 138);
            return new ArchaeologyLootRecipeData(loot, (ArrayListMultimap<Float, class_1799>)map2, isGuaranteedNonChance, name);
        }
    }
}

