/*
 * Decompiled with CFR 0.152.
 */
package jewtvet.boathud_extended;

import com.mojang.blaze3d.systems.RenderSystem;
import jewtvet.boathud_extended.Common;
import jewtvet.boathud_extended.Config;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class HudRenderer {
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("boathud_extended", "textures/widgets.png");
    private static final double[] MIN_V = new double[]{0.0, 0.0, 40.0};
    private static final double[] MAX_V = new double[]{40.0, 72.0, 72.7};
    private static final double[] SCALE_V = new double[]{5.4, 3.0, 6.6};
    private static final double[] SCALE_V_COMPACT = new double[]{3.6, 2.0, 4.4};
    private static final int[] BAR_OFF = new int[]{0, 10, 20};
    private static final int[] BAR_ON = new int[]{5, 15, 25};

    public void render(class_332 context) {
        int horizontalCentre = Common.client.method_22683().method_4486() / 2;
        int heightWithOffset = Common.client.method_22683().method_4502() - Config.yOffset + 6;
        int[] horizontal = new int[]{horizontalCentre - 104, horizontalCentre - 14, horizontalCentre + 14, horizontalCentre + 104};
        int[] horizontal_compact = new int[]{horizontalCentre - 68, horizontalCentre, horizontalCentre + 68};
        int[] vertical = new int[]{heightWithOffset - 14, heightWithOffset - 4};
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        HudRenderer.drawBackground(context, horizontalCentre, heightWithOffset);
        HudRenderer.drawSpeedBar(context, horizontalCentre, heightWithOffset);
        if (Config.extended) {
            HudRenderer.drawGMeter(context, horizontalCentre, heightWithOffset);
            HudRenderer.drawThrottleTrace(context, horizontal[1], vertical[0]);
            HudRenderer.drawSteeringTrace(context, horizontal[2], vertical[0]);
        } else {
            HudRenderer.drawKeyInputs(context, horizontal_compact[1] - 6, vertical[1]);
        }
        if (Config.extended) {
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.SPEED), horizontal[0], vertical[0], 0);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.SLIPANGLE), horizontal[3], vertical[0], 2);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.PING), horizontal[2], vertical[1], 0);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.FPS), horizontal[3], vertical[1], 2);
            if (Config.checkpointEnabled) {
                HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.DELTA), horizontal[0], vertical[1], 0);
                HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.SPEED_DIFF), horizontal[1], vertical[1], 2);
            } else {
                HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.ACCELERATION), horizontal[1] - 1, vertical[1], 2);
            }
        } else {
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.SPEED), horizontal_compact[0], vertical[0], 0);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.SLIPANGLE), horizontal_compact[2], vertical[0], 2);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.PING), horizontal_compact[0], vertical[1], 0);
            HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.FPS), horizontal_compact[2], vertical[1], 2);
            if (Config.checkpointEnabled) {
                HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.DELTA), horizontal_compact[1] + 6, vertical[0], 1);
            } else {
                HudRenderer.drawTextAlign(context, HudRenderer.getString(DisplayType.ACCELERATION), horizontal_compact[1] + 6, vertical[0], 1);
            }
        }
        RenderSystem.disableBlend();
    }

    private static void drawBackground(class_332 context, int x, int y) {
        context.method_25302(WIDGETS_TEXTURE, x - HudRenderer.getTextureWidth() / 2, y - 20, 0, HudRenderer.getTextureOffset(), HudRenderer.getTextureWidth(), 26);
    }

    private static void drawSpeedBar(class_332 context, int x, int y) {
        context.method_25302(WIDGETS_TEXTURE, x - HudRenderer.getTextureWidth() / 2, y - 20, 0, 26 + HudRenderer.getTextureOffset() + BAR_OFF[Config.barType], HudRenderer.getTextureWidth(), 5);
        if (!(Common.hudData.speed < MIN_V[Config.barType])) {
            if (Common.hudData.speed > MAX_V[Config.barType]) {
                assert (Common.client.field_1687 != null);
                if (Common.client.field_1687.method_8510() % 2L == 0L) {
                    context.method_25302(WIDGETS_TEXTURE, x - HudRenderer.getTextureWidth() / 2, y - 20, 0, 26 + HudRenderer.getTextureOffset() + BAR_ON[Config.barType], HudRenderer.getTextureWidth(), 5);
                }
            } else {
                context.method_25302(WIDGETS_TEXTURE, x - HudRenderer.getTextureWidth() / 2, y - 20, 0, 26 + HudRenderer.getTextureOffset() + BAR_ON[Config.barType], HudRenderer.getBarLength(), 5);
            }
        }
    }

    private static int getTextureOffset() {
        return Config.extended ? 0 : 56;
    }

    private static int getTextureWidth() {
        return Config.extended ? 218 : 146;
    }

    private static int getBarLength() {
        return (int)((Common.hudData.speed - MIN_V[Config.barType]) * (Config.extended ? SCALE_V[Config.barType] : SCALE_V_COMPACT[Config.barType])) + 1;
    }

    private static void drawGMeter(class_332 context, int x, int y) {
        context.method_25302(WIDGETS_TEXTURE, x - 9, y - 14, 218, 0, 18, 18);
        context.method_25302(WIDGETS_TEXTURE, x - 1 + HudRenderer.getGPosition(Common.hudData.gLat), y - 6 - HudRenderer.getGPosition(Common.hudData.gLon), HudRenderer.getGColour(), 0, 2, 2);
    }

    private static int getGPosition(double g) {
        return Math.min(Math.max((int)(g / 2.5), -8), 8);
    }

    private static int getGColour() {
        return !(Math.abs(Common.hudData.gLon) > 22.5) && !(Math.abs(Common.hudData.gLat) > 22.5) ? 236 : 238;
    }

    public static void drawTextAlign(class_332 context, String text, int x, int y, int align) {
        context.method_25303(Common.client.field_1772, text, x - Common.client.field_1772.method_1727(text) * align / 2, y, 0xFFFFFF);
    }

    private static String getString(DisplayType type) {
        return switch (type.ordinal()) {
            case 0 -> String.format("%" + HudRenderer.threeSigFig(Common.hudData.speed * Config.speedRate) + Config.speedUnit, Common.hudData.speed * Config.speedRate);
            case 1 -> String.format("%" + HudRenderer.threeSigFig(Common.hudData.slipAngle) + Config.angleUnit, Math.abs(Common.hudData.slipAngle));
            case 2 -> {
                String var10000 = HudRenderer.getStringColour(type);
                yield var10000 + String.format("%03d \u00a7fms", Common.hudData.ping);
            }
            case 3 -> {
                String var10000 = HudRenderer.getStringColour(type);
                yield var10000 + String.format("%03d \u00a7ffps", Common.hudData.fps);
            }
            case 4 -> {
                if (!Config.extended) {
                    yield String.format(HudRenderer.getAccelerationFormat(), Common.hudData.gLon * Config.accelerationRate);
                }
                yield String.format(HudRenderer.getAccelerationFormat(), Common.hudData.gLon * Config.accelerationRate, Math.abs(Common.hudData.gLat * Config.accelerationRate));
            }
            case 5 -> {
                String var10000 = HudRenderer.getStringColour(type);
                yield var10000 + String.format("%+" + HudRenderer.threeSigFig(Common.hudData.delta) + Config.timeUnit, Common.hudData.delta);
            }
            case 6 -> {
                String var10000 = HudRenderer.getStringColour(type);
                yield var10000 + String.format("%+" + HudRenderer.threeSigFig(Common.hudData.speedDiff * Config.speedRate) + Config.speedUnit, Common.hudData.speedDiff * Config.speedRate);
            }
            default -> "";
        };
    }

    private static String threeSigFig(double value) {
        return Math.abs(value) >= 99.95 ? ".0f" : (Math.abs(value) >= 9.95 ? ".1f" : ".2f");
    }

    private static String getAccelerationFormat() {
        String s = "%+" + HudRenderer.threeSigFig(Common.hudData.gLon * Config.accelerationRate);
        if (Config.extended) {
            s = s + " / %" + HudRenderer.threeSigFig(Common.hudData.gLat * Config.accelerationRate);
        }
        return s + Config.accelerationUnit;
    }

    private static String getStringColour(DisplayType type) {
        return switch (type.ordinal()) {
            case 2 -> {
                if (Common.hudData.ping > 500) {
                    yield "\u00a7c";
                }
                if (Common.hudData.ping < 50) {
                    yield "\u00a7a";
                }
                yield "\u00a7f";
            }
            case 3 -> {
                if (Common.hudData.fps < 120) {
                    yield "\u00a7c";
                }
                if (Common.hudData.fps > 240) {
                    yield "\u00a7a";
                }
                yield "\u00a7f";
            }
            case 5 -> {
                if (Common.hudData.delta > 0.025) {
                    yield "\u00a7c";
                }
                if (Common.hudData.delta < -0.025) {
                    yield "\u00a7a";
                }
                yield "\u00a7f";
            }
            case 6 -> {
                if (Common.hudData.speedDiff < -0.4) {
                    yield "\u00a7c";
                }
                if (Common.hudData.speedDiff > 0.4) {
                    yield "\u00a7a";
                }
                yield "\u00a7f";
            }
            default -> "";
        };
    }

    private static void drawThrottleTrace(class_332 context, int x, int y) {
        int i = 0;
        for (double throttle : Common.hudData.throttleTrace) {
            context.method_25302(WIDGETS_TEXTURE, x - 40 + i, y + 4 + HudRenderer.getTracePosition(throttle), HudRenderer.getThrottleColour(throttle), 0, 1, 1);
            ++i;
        }
    }

    private static void drawSteeringTrace(class_332 context, int x, int y) {
        int i = 0;
        for (double steering : Common.hudData.steeringTrace) {
            context.method_25302(WIDGETS_TEXTURE, x + i, y + 4 + HudRenderer.getTracePosition(steering), 242, 0, 1, 1);
            ++i;
        }
    }

    private static int getThrottleColour(double throttle) {
        return throttle > 0.0 ? 240 : (throttle < 0.0 ? 241 : 242);
    }

    private static int getTracePosition(double value) {
        return (int)Math.signum(value) * -4;
    }

    private static void drawKeyInputs(class_332 context, int x, int y) {
        context.method_25302(WIDGETS_TEXTURE, x - 21, y, 146, 56, 42, 9);
        Boolean[] inputs = new Boolean[]{Common.client.field_1690.field_1913.method_1434(), Common.client.field_1690.field_1881.method_1434(), Common.client.field_1690.field_1894.method_1434(), Common.client.field_1690.field_1849.method_1434()};
        for (int i = 0; i < 4; ++i) {
            if (!inputs[i].booleanValue()) continue;
            context.method_25302(WIDGETS_TEXTURE, x - 21 + 11 * i, y, 146 + 11 * i, 65, 9, 9);
        }
    }

    public static enum DisplayType {
        SPEED,
        SLIPANGLE,
        PING,
        FPS,
        ACCELERATION,
        DELTA,
        SPEED_DIFF;

    }
}

