/*
 * Decompiled with CFR 0.152.
 */
package jewtvet.boathud_extended;

import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Objects;
import jewtvet.boathud_extended.Common;
import jewtvet.boathud_extended.Config;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_640;

public class HudData {
    public int ping;
    public int fps;
    public final String name;
    private final class_640 listEntry;
    public double xPos;
    public double zPos;
    public double yPos;
    private double xPosLast;
    private double zPosLast;
    public double speed;
    private double speedLast;
    public double gLon;
    public double gLat;
    public double slipAngle;
    public double angularVelocity;
    private double angleFacing;
    private double angleTravelling;
    public double steering;
    public double throttle;
    public Deque<Double> steeringTrace = new ArrayDeque<Double>(Collections.nCopies(40, 0.0));
    public Deque<Double> throttleTrace = new ArrayDeque<Double>(Collections.nCopies(40, 0.0));
    public double time = 0.0;
    private String fileName;
    private Boolean telemetryStart = false;
    public int cp = 0;
    public double delta = 0.0;
    public double speedDiff = 0.0;
    private double startTime = 0.0;

    public HudData() {
        assert (Common.client.field_1724 != null);
        this.name = Common.client.field_1724.method_5820();
        this.listEntry = Objects.requireNonNull(Common.client.method_1562()).method_2871(Common.client.field_1724.method_5667());
        if (Config.telemetryEnabled) {
            this.telemetryFileInit();
        }
        if (Config.checkpointEnabled) {
            this.checkpointInit();
        }
    }

    public void update() {
        assert (Common.client.field_1724 != null);
        class_1690 boat = (class_1690)Common.client.field_1724.method_5854();
        assert (boat != null);
        class_243 velocity = boat.method_18798().method_18805(1.0, 0.0, 1.0);
        this.xPosLast = this.xPos;
        this.zPosLast = this.zPos;
        this.xPos = boat.method_23317();
        this.zPos = boat.method_23321();
        this.yPos = boat.method_23318();
        this.speedLast = this.speed;
        this.speed = velocity.method_1033() * 20.0;
        this.gLon = (this.speed - this.speedLast) * 20.0;
        double angleFacingLast = this.angleFacing;
        this.angleFacing = boat.method_36454();
        this.angularVelocity = (this.angleFacing - angleFacingLast) * 20.0;
        double angleTravellingLast = this.angleTravelling;
        this.angleTravelling = Math.toDegrees(Math.atan2(-velocity.method_10216(), velocity.method_10215()));
        this.gLat = Math.sin(Math.toRadians(this.angleTravelling - angleTravellingLast) / 2.0) * this.speedLast * 2.0 * 20.0;
        this.slipAngle = this.speed == 0.0 ? 0.0 : HudData.normaliseAngle(this.angleFacing - this.angleTravelling);
        this.steering = (Common.client.field_1690.field_1849.method_1434() ? -1.0 : 0.0) + (Common.client.field_1690.field_1913.method_1434() ? 1.0 : 0.0);
        this.throttle = (Common.client.field_1690.field_1894.method_1434() ? 1.0 : 0.0) + (Common.client.field_1690.field_1881.method_1434() ? -0.125 : 0.0);
        this.updateTrace();
        this.ping = this.listEntry.method_2959();
        if (Config.telemetryEnabled && this.throttle > 0.01) {
            this.telemetryStart = true;
        }
        if (this.telemetryStart.booleanValue()) {
            this.telemetryWrite();
        }
        if (Config.checkpointEnabled) {
            this.checkpoint();
        }
        this.time += 0.05;
    }

    private static double normaliseAngle(double angle) {
        return (angle = (angle % 360.0 + 360.0) % 360.0) > 180.0 ? angle - 360.0 : angle;
    }

    private void telemetryFileInit() {
        String var10001 = Config.telemetryDirectory;
        this.fileName = var10001 + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss").format(LocalDateTime.now()) + ".csv";
        try {
            FileWriter fw = new FileWriter(this.fileName);
            fw.write("time,speed,gLon,gLat,slipAngle,angularVelocity,steering,throttle,xPos,zPos,yPos\n");
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void telemetryWrite() {
        try {
            FileWriter fw = new FileWriter(this.fileName, true);
            fw.write(String.format("%.2f" + ",%.4f".repeat(10) + "\n", this.time, this.speed, this.gLon, this.gLat, this.slipAngle, this.angularVelocity, this.steering, this.throttle, this.xPos, this.zPos, this.yPos));
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateTrace() {
        this.steeringTrace.removeFirst();
        this.steeringTrace.addLast(this.steering);
        this.throttleTrace.removeFirst();
        this.throttleTrace.addLast(this.throttle);
    }

    private void checkpointInit() {
        if (!Objects.equals(Config.checkpointFileLoaded, Config.checkpointFile)) {
            Config.loadCheckpoints();
        }
    }

    private void checkpoint() {
        if (this.cp < Config.checkpoints) {
            double dot = this.dotProduct(this.xPos, this.zPos);
            while (dot > Config.checkpointdata.get(this.cp)[4]) {
                double dotLast = this.dotProduct(this.xPosLast, this.zPosLast);
                double subtick = Math.min(Math.max((Config.checkpointdata.get(this.cp)[4] - dotLast) / (dot - dotLast), 0.0), 1.0);
                double subtickTime = this.time - 0.05 + subtick * 0.05;
                if (this.cp == 0) {
                    this.startTime = subtickTime;
                }
                this.delta = subtickTime - this.startTime - Config.checkpointdata.get(this.cp)[0];
                this.speedDiff = this.speedLast * subtick + this.speed * (1.0 - subtick) - Config.checkpointdata.get(this.cp)[1];
                ++this.cp;
                if (this.cp >= Config.checkpoints) {
                    if (!Config.circularTrack) break;
                    this.cp -= Config.checkpoints;
                }
                dot = this.dotProduct(this.xPos, this.zPos);
            }
        }
    }

    private double dotProduct(double x, double z) {
        return x * Config.checkpointdata.get(this.cp)[2] + z * Config.checkpointdata.get(this.cp)[3];
    }
}

