/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lordrius.essentialgui.Config;
import lordrius.essentialgui.gui.hud.PlayerEquipment;
import lordrius.essentialgui.gui.hud.PointedBlock;
import lordrius.essentialgui.gui.hud.PointedEntity;
import lordrius.essentialgui.mixin.MixinBossBarHudAccessor;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1831;
import net.minecraft.class_1835;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

public class Utils {
    private static class_310 client = class_310.method_1551();

    public static long getTimeOfDay() {
        return Utils.client.field_1687.method_8532() % 24000L;
    }

    public static String getTimeString(String style) {
        String prefix;
        boolean twelveHour = style.contains("12_hour");
        int hourValue = (int)(Utils.getTimeOfDay() / 1000L + 6L) % 24;
        int hour = (int)(Utils.getTimeOfDay() / 1000L + 6L) % (twelveHour ? 12 : 24);
        if (twelveHour && hour == 0) {
            hour = 12;
        }
        int minutes = (int)((float)Utils.getTimeOfDay() / 16.666666f % 60.0f);
        String string = Config.clientPlayerWorldColoredText.booleanValue() ? (Utils.isSunrise() ? "\u00a77" : (Utils.isMorning() ? "\u00a73" : (Utils.isDay() ? "\u00a7b" : (Utils.isNoon() ? "\u00a7e" : (Utils.isSunset() ? "\u00a76" : "\u00a78"))))) : (prefix = "\u00a77");
        String suffix = twelveHour ? (hourValue >= 12 && hourValue < 24 ? " PM" : " AM") : "";
        String format = twelveHour ? "%s%01d:%02d%s" : "%s%02d:%02d%s";
        return style.contains("hour") ? String.format(Locale.GERMAN, format, prefix, hour, minutes, suffix) : prefix + Utils.getTimeOfDay();
    }

    public static boolean isSunrise() {
        return Utils.getTimeOfDay() >= 23000L && Utils.getTimeOfDay() < 24000L;
    }

    public static boolean isMorning() {
        return Utils.getTimeOfDay() >= 0L && Utils.getTimeOfDay() < 2000L;
    }

    public static boolean isDay() {
        return Utils.getTimeOfDay() >= 2000L && Utils.getTimeOfDay() < 6000L;
    }

    public static boolean isNoon() {
        return Utils.getTimeOfDay() >= 6000L && Utils.getTimeOfDay() < 12000L;
    }

    public static boolean isSunset() {
        return Utils.getTimeOfDay() >= 12000L && Utils.getTimeOfDay() < 13000L;
    }

    public static boolean isNight() {
        return Utils.getTimeOfDay() >= 13000L && Utils.getTimeOfDay() < 23000L;
    }

    public static boolean isTimeToSleep() {
        return Utils.getTimeOfDay() >= 12544L && Utils.getTimeOfDay() <= 23461L;
    }

    public static boolean isBossBarRendered() {
        return !((MixinBossBarHudAccessor)Utils.client.field_1705.method_1740()).getBossBars().isEmpty();
    }

    public static int getBossBarsRendered() {
        return ((MixinBossBarHudAccessor)Utils.client.field_1705.method_1740()).getBossBars().size();
    }

    public static String ticksToHours(long fuelTime) {
        int seconds = (int)fuelTime / 20;
        long sec = seconds % 60;
        long minutes = seconds % 3600 / 60;
        long hours = seconds % 86400 / 3600;
        return String.format("%01d:%02d:%02d", Math.round(hours), Math.round(minutes), Math.round(sec));
    }

    public static String ticksToMinutes(long l) {
        int seconds = (int)l / 20;
        long sec = seconds % 60;
        long minutes = seconds % 3600 / 60;
        return String.format("%01d:%02d", Math.round(minutes), Math.round(sec));
    }

    public static String capitalizeTitleString(String text) {
        String regex = "\\b(.)(.*?)\\b";
        String result = Pattern.compile(regex).matcher(text).replaceAll(matche -> matche.group(1).toUpperCase() + matche.group(2));
        return result;
    }

    public static int getTooltipWidth(List<class_2561> tooltip) {
        if (!tooltip.isEmpty()) {
            ArrayList integerList = Lists.newArrayList();
            for (int i = 0; i < tooltip.size(); ++i) {
                integerList.add(Utils.client.field_1772.method_27525((class_5348)tooltip.get(i)));
            }
            return (Integer)Collections.max(integerList);
        }
        return 0;
    }

    public static boolean isEntityPropertiesOpen() {
        return PointedEntity.isEntityPropertiesOpen;
    }

    public static boolean isBlockPropertiesOpen() {
        return PointedBlock.isBlockPropertiesOpen;
    }

    public static boolean isCenterHudOpen() {
        return PlayerEquipment.isPlayerStatsOpen || PointedEntity.isMultiplayerEquipmentOpen;
    }

    public static boolean isVanillaItem(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).method_12836() == "minecraft";
    }

    public static class_2561 getItemDurability(class_1799 stack) {
        int currentUses = stack.method_7936() - stack.method_7919();
        int percentage = currentUses * 100 / stack.method_7936();
        boolean isPercentage = Config.advancedDamageablesDurabilityPercentage;
        boolean isPenalty = Config.advancedDamageablesPenaltyLevel != false && stack.method_7928() > 0;
        String percent = isPercentage ? String.format(" (%d%%)", percentage) : "";
        String penalty = isPenalty ? " \u00a78[" + Utils.getPenaltyLevelTooltip(stack).getString() + "\u00a78]" : "";
        class_5250 durability = class_2561.method_43470((String)(currentUses + "/" + stack.method_7936() + percent + penalty));
        if (Config.advancedDamageablesDurabilityColored.booleanValue()) {
            durability.method_10862(durability.method_10866().method_36139(stack.method_31580()));
        }
        return durability;
    }

    public static class_2561 getPenaltyLevelTooltip(class_1799 stack) {
        if (stack.method_7928() > 0) {
            int timesRepaired = 0;
            int cost = stack.method_7928();
            String prefix = "";
            if (cost == 1) {
                timesRepaired = 1;
                prefix = "\u00a7a";
            } else if (cost == 3) {
                timesRepaired = 2;
                prefix = "\u00a72";
            } else if (cost == 7) {
                timesRepaired = 3;
                prefix = "\u00a7e";
            } else if (cost == 15) {
                timesRepaired = 4;
                prefix = "\u00a76";
            } else if (cost == 31) {
                timesRepaired = 5;
                prefix = "\u00a7c";
            } else {
                timesRepaired = 6;
                prefix = "\u00a74";
            }
            return class_2561.method_43470((String)String.format(prefix + "%d/6", timesRepaired));
        }
        return class_2561.method_43473();
    }

    public static class_1799 getPlayerEquippedStackForComparison(class_1799 hoverStack, class_1657 player) {
        class_1304 slot = null;
        if (player != null) {
            slot = class_1657.method_32326((class_1799)hoverStack);
            return player.method_6118(slot);
        }
        return class_1799.field_8037;
    }

    public static boolean isPlayerItemComparable(class_1799 hoverStack, class_1657 player) {
        boolean isEquippedStackComparable;
        class_1792 hoverItem = hoverStack.method_7909();
        class_1792 equippedItem = Utils.getPlayerEquippedStackForComparison(hoverStack, player).method_7909();
        boolean isHoverItemComparable = hoverItem instanceof class_1738 || hoverItem instanceof class_1753 || hoverItem instanceof class_1764 || hoverItem instanceof class_1819 || hoverItem instanceof class_1831 || hoverItem instanceof class_1835;
        boolean bl = isEquippedStackComparable = equippedItem instanceof class_1738 || equippedItem instanceof class_1753 || equippedItem instanceof class_1764 || equippedItem instanceof class_1819 || equippedItem instanceof class_1831 || equippedItem instanceof class_1835;
        return isHoverItemComparable && isEquippedStackComparable && hoverStack != player.method_6047();
    }

    public static class_1799 getItemStackFromString(String string) {
        Optional optional = class_7923.field_41178.method_17966(new class_2960(string));
        if (optional.isPresent()) {
            return ((class_1792)optional.get()).method_7854();
        }
        return class_1799.field_8037;
    }

    public static String toggleBedColor(String string) {
        switch (string) {
            case "minecraft:white_bed": {
                string = "minecraft:orange_bed";
                break;
            }
            case "minecraft:orange_bed": {
                string = "minecraft:magenta_bed";
                break;
            }
            case "minecraft:magenta_bed": {
                string = "minecraft:light_blue_bed";
                break;
            }
            case "minecraft:light_blue_bed": {
                string = "minecraft:yellow_bed";
                break;
            }
            case "minecraft:yellow_bed": {
                string = "minecraft:lime_bed";
                break;
            }
            case "minecraft:lime_bed": {
                string = "minecraft:pink_bed";
                break;
            }
            case "minecraft:pink_bed": {
                string = "minecraft:gray_bed";
                break;
            }
            case "minecraft:gray_bed": {
                string = "minecraft:light_gray_bed";
                break;
            }
            case "minecraft:light_gray_bed": {
                string = "minecraft:cyan_bed";
                break;
            }
            case "minecraft:cyan_bed": {
                string = "minecraft:purple_bed";
                break;
            }
            case "minecraft:purple_bed": {
                string = "minecraft:blue_bed";
                break;
            }
            case "minecraft:blue_bed": {
                string = "minecraft:brown_bed";
                break;
            }
            case "minecraft:brown_bed": {
                string = "minecraft:green_bed";
                break;
            }
            case "minecraft:green_bed": {
                string = "minecraft:red_bed";
                break;
            }
            case "minecraft:red_bed": {
                string = "minecraft:black_bed";
                break;
            }
            case "minecraft:black_bed": {
                string = "minecraft:white_bed";
            }
        }
        return string;
    }

    public static String toggleTextColor(String string) {
        switch (string) {
            case "screen.color.dark_red": {
                string = "screen.color.red";
                break;
            }
            case "screen.color.red": {
                string = "screen.color.gold";
                break;
            }
            case "screen.color.gold": {
                string = "screen.color.yellow";
                break;
            }
            case "screen.color.yellow": {
                string = "screen.color.dark_green";
                break;
            }
            case "screen.color.dark_green": {
                string = "screen.color.green";
                break;
            }
            case "screen.color.green": {
                string = "screen.color.aqua";
                break;
            }
            case "screen.color.aqua": {
                string = "screen.color.dark_aqua";
                break;
            }
            case "screen.color.dark_aqua": {
                string = "screen.color.dark_blue";
                break;
            }
            case "screen.color.dark_blue": {
                string = "screen.color.blue";
                break;
            }
            case "screen.color.blue": {
                string = "screen.color.purple";
                break;
            }
            case "screen.color.purple": {
                string = "screen.color.dark_purple";
                break;
            }
            case "screen.color.dark_purple": {
                string = "screen.color.white";
                break;
            }
            case "screen.color.white": {
                string = "screen.color.gray";
                break;
            }
            case "screen.color.gray": {
                string = "screen.color.dark_gray";
                break;
            }
            case "screen.color.dark_gray": {
                string = "screen.color.black";
                break;
            }
            case "screen.color.black": {
                string = "screen.color.dark_red";
            }
        }
        return string;
    }

    public static Color hexToColor(String hex) {
        if (!Utils.isHexadecimal(hex = hex.replace("#", ""))) {
            return null;
        }
        switch (hex.length()) {
            case 6: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            case 8: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        return null;
    }

    public static int getColor(String s) {
        int color = 0;
        if (Utils.hexToColor(s) != null) {
            color = Utils.hexToColor(s).getRGB();
        }
        return color;
    }

    public static boolean isHexadecimal(String input) {
        Pattern pattern = Pattern.compile("\\p{XDigit}+");
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static class_2561 unparsedTextFromJson(String json) {
        try {
            class_5250 text = class_2561.class_2562.method_10877((String)json);
            if (text != null) {
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_5244.field_39003;
    }
}

