/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.awt.Color;
import lordrius.essentialgui.Config;
import lordrius.essentialgui.gui.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_746;

public class PlayerWarningArea
extends class_332 {
    private class_2960 GUI_ICONS = new class_2960("textures/gui/icons.png");
    private class_2960 ICONS = new class_2960("essentialgui:textures/icons.png");
    private class_2960 EQUIPMENT = new class_2960("essentialgui:textures/gui/equipment.png");
    private class_310 client;
    private class_327 textRenderer;
    private class_746 player;
    private int health;
    private int hunger;
    private int saturation;
    private int oxygen;
    private int frozenTicks;
    private int awakeDays;
    private int warnings;
    private int width;
    private int height;
    private boolean isChatOpen;
    private boolean withCounters;
    private boolean isDarkTexture;

    public PlayerWarningArea(class_310 client, class_4597.class_4598 vertexConsumers) {
        super(client, vertexConsumers);
        this.client = client;
        this.textRenderer = client.field_1772;
        this.player = client.field_1724;
        this.health = class_3532.method_15386((float)this.player.method_6032());
        this.hunger = this.player.method_7344().method_7586();
        this.saturation = (int)this.player.method_7344().method_7589();
        this.oxygen = this.getPlayerOxygen((class_1657)this.player)[0];
        this.frozenTicks = this.player.method_32312() / 20;
        this.awakeDays = this.getAwakeDays(this.player);
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.isChatOpen = client.field_1755 instanceof class_408;
        this.withCounters = Config.playerWarningAreaWarningCounters != false && !this.isChatOpen;
        this.isDarkTexture = Config.playerWarningAreaTextureType.contains("dark");
        if (Config.playerWarningArea.booleanValue()) {
            if (Config.playerWarningAreaTimeSinceLastRest.booleanValue() && client.field_1724.field_6012 % 1201 == 1200) {
                client.method_1562().method_2883((class_2596)new class_2799(class_2799.class_2800.field_12775));
            }
            this.drawWarningArea(this);
        }
    }

    private void drawWarningArea(class_332 context) {
        int y;
        int x;
        boolean needsRest = Config.playerWarningAreaTimeSinceLastRest != false && this.player.method_37908().method_8597().comp_642() && this.awakeDays > 0;
        boolean lowHealth = Config.playerWarningAreaHealthWarning != false && this.health <= 10;
        boolean lowFood = Config.playerWarningAreaHungerWarning != false && this.hunger <= 10;
        boolean lowOxygen = Config.playerWarningAreaOxygenWarning != false && this.player.method_33190() && (this.player.method_5869() || this.getPlayerOxygen((class_1657)this.player)[0] < this.getPlayerOxygen((class_1657)this.player)[1]);
        boolean hasSaturation = Config.playerWarningAreaSaturationWarning != false && this.saturation > 0 && this.player.method_33190() && !(this.player.method_5854() instanceof class_1309);
        boolean isFreezing = Config.playerWarningAreaFreezeWarning != false && this.frozenTicks > 0 && this.player.method_33190();
        int separation = this.isDarkTexture ? 26 : 23;
        int n = x = this.isChatOpen ? 2 : 1;
        int n2 = this.isChatOpen ? (this.isDarkTexture ? this.height - 39 : this.height - 38) : (y = this.isDarkTexture ? this.height - 25 : this.height - 23);
        if (needsRest) {
            this.drawRestWarning(context, x + separation * this.warnings, y);
            ++this.warnings;
        }
        if (lowHealth) {
            this.drawHealthWarning(context, x + separation * this.warnings, y);
            ++this.warnings;
        }
        if (lowFood) {
            this.drawHungerWarning(context, x + separation * this.warnings, y);
            ++this.warnings;
        }
        if (lowOxygen) {
            this.drawPlayerOxygenWarning(context, x + separation * this.warnings, y);
            ++this.warnings;
        }
        if (hasSaturation) {
            context.method_25302(this.ICONS, this.width / 2 + 10, this.height - 35, 0, 241, 5, 5);
        }
        if (isFreezing) {
            this.drawFreezeWarning(context, x + separation * this.warnings, y);
            ++this.warnings;
        }
        if (Config.playerWarningAreaCriticalHealthWarning.booleanValue()) {
            if (this.client.field_1690.field_1907.method_1434() || this.isChatOpen) {
                return;
            }
            if (this.client.field_1690.method_31044() == class_5498.field_26664) {
                this.drawCriticalHealthCursorWarning(context);
            }
        }
    }

    private int getAwakeDays(class_746 player) {
        return player.method_3143().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429)) / 24000;
    }

    private void drawRestWarning(class_332 context, int x, int y) {
        int yPos;
        String days = String.valueOf(this.awakeDays);
        int color = this.awakeDays >= 3 ? Draw.RED.getRGB() : Draw.GRAY.getRGB();
        int xPos = this.isDarkTexture ? x + 4 : x + 2;
        int n = yPos = this.isDarkTexture ? y + 4 : y + 3;
        if (this.isDarkTexture) {
            this.drawWarningDark(context, x, y, this.withCounters, days, color);
        } else {
            this.drawWarningRectangle(context, x, y, this.withCounters, days, color);
        }
        class_1799 bed = Utils.getItemStackFromString(Config.playerWarningAreaTimeSinceLastRestBedItem);
        context.method_51427(bed, xPos, yPos);
    }

    private void drawHealthWarning(class_332 context, int x, int y) {
        int yPos;
        String health = String.valueOf(this.health);
        int xPos = this.isDarkTexture ? x + 3 : x + 2;
        int n = yPos = this.isDarkTexture ? y + 3 : y + 2;
        if (this.isDarkTexture) {
            this.drawWarningDark(context, x, y, this.withCounters, health, Draw.RED.getRGB());
        } else {
            this.drawWarningRectangle(context, x, y, this.withCounters, health, Draw.RED.getRGB());
        }
        context.method_25293(this.ICONS, xPos, yPos, 18, 18, 18.0f, -9.0f, 9, 9, 256, 256);
    }

    private void drawHungerWarning(class_332 context, int x, int y) {
        int yPos;
        String hunger = String.valueOf(this.hunger);
        int xPos = this.isDarkTexture ? x + 3 : x + 2;
        int n = yPos = this.isDarkTexture ? y + 3 : y + 2;
        if (this.isDarkTexture) {
            this.drawWarningDark(context, x, y, this.withCounters, hunger, Draw.RED.getRGB());
        } else {
            this.drawWarningRectangle(context, x, y, this.withCounters, hunger, Draw.RED.getRGB());
        }
        context.method_25293(this.ICONS, xPos, yPos, 18, 18, 45.0f, -9.0f, 9, 9, 256, 256);
    }

    private void drawPlayerOxygenWarning(class_332 context, int x, int y) {
        int yPos;
        String oxygen = Utils.ticksToMinutes(this.oxygen + 19);
        int xPos = this.isDarkTexture ? x + 3 : x + 2;
        int n = yPos = this.isDarkTexture ? y + 3 : y + 2;
        if (this.isDarkTexture) {
            this.drawWarningDark(context, x, y, this.withCounters, oxygen, Draw.RED.getRGB());
        } else {
            this.drawWarningRectangle(context, x, y, this.withCounters, oxygen, Draw.RED.getRGB());
        }
        context.method_25293(this.ICONS, xPos, yPos, 18, 18, 27.0f, -9.0f, 9, 9, 256, 256);
        if (Config.playerWarningAreaOxygenBar.booleanValue()) {
            boolean top = Config.playerWarningAreaOxygenBarHudLocation.contains("top");
            int oxygenBarSizeX = Integer.parseInt(Config.statsBarsWidth);
            int oxygenBarSizeY = Integer.parseInt(Config.statsBarsHeight);
            int oxygenX = (this.width - oxygenBarSizeX - 2) / 2;
            int oxygenY = top ? this.height / 2 - 50 : this.height / 2 + 40;
            this.drawPlayerOxygenBar(context, (class_1657)this.player, oxygenX, oxygenY, oxygenBarSizeX, oxygenBarSizeY);
        }
    }

    private void drawFreezeWarning(class_332 context, int x, int y) {
        int yPos;
        String frozenTicks = this.frozenTicks + "/7";
        int xPos = this.isDarkTexture ? x + 3 : x + 2;
        int n = yPos = this.isDarkTexture ? y + 3 : y + 2;
        if (this.isDarkTexture) {
            this.drawWarningDark(context, x, y, this.withCounters, frozenTicks, Draw.RED.getRGB());
        } else {
            this.drawWarningRectangle(context, x, y, this.withCounters, frozenTicks, Draw.RED.getRGB());
        }
        context.method_25293(this.ICONS, xPos, yPos, 18, 18, 63.0f, -9.0f, 9, 9, 256, 256);
    }

    private void drawCriticalHealthCursorWarning(class_332 context) {
        if (this.health <= 10) {
            context.method_51422(1.0f, 0.0f, 0.0f, 1.0f);
        } else {
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        context.method_25302(this.GUI_ICONS, (this.width - 15) / 2, (this.height - 15) / 2, 0, 0, 15, 15);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawPlayerOxygenBar(class_332 context, class_1657 entity, int x, int y, int maxWidth, int maxHeight) {
        int oxygen = this.getPlayerOxygen((class_1657)this.player)[0];
        int oxygenMax = this.getPlayerOxygen((class_1657)this.player)[1];
        int scaled = oxygen * maxWidth / oxygenMax;
        Draw.drawOxygenBar(context, x, y - 3, maxWidth, maxHeight, scaled, Utils.ticksToMinutes(oxygen + 19));
    }

    private void drawWarningDark(class_332 context, int x, int y, boolean withCounters, String counter, int textColor) {
        context.method_25302(this.EQUIPMENT, x, y, 154, 186, 25, 24);
        if (withCounters) {
            context.method_25302(this.EQUIPMENT, x, y - 14, 154, 211, 25, 15);
        }
        if (withCounters) {
            context.method_25300(this.textRenderer, counter, x + 13, y - 10, textColor);
        }
    }

    private void drawWarningRectangle(class_332 context, int x, int y, boolean withCounters, String counter, int textColor) {
        Draw.drawCustomRectangle(context, x, y, 21, 21, new Color(127, 0, 0, 200).getRGB());
        if (withCounters) {
            Draw.drawBoxTextCenter(context, x + 3, y - 11, 17, counter, Draw.getSectionColor().getRGB(), textColor);
        }
    }

    private int[] getPlayerOxygen(class_1657 player) {
        int oxygen = player.method_5669();
        int oxygenMax = player.method_5748();
        if (player.method_6112(class_1294.field_5923) != null) {
            oxygen += player.method_6112(class_1294.field_5923).method_5584();
            oxygenMax += player.method_6112(class_1294.field_5923).method_5584();
        }
        int[] i = new int[]{oxygen, oxygenMax};
        return i;
    }
}

