/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lordrius.essentialgui.Config;
import lordrius.essentialgui.events.KeyBindings;
import lordrius.essentialgui.gui.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1074;
import net.minecraft.class_1262;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_408;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.class_8109;

public class PlayerEquipment
extends class_332 {
    private class_2960 WIDGETS = new class_2960("textures/gui/widgets.png");
    private class_2960 ICONS = new class_2960("essentialgui:textures/icons.png");
    private class_2960 EQUIPMENT = new class_2960("essentialgui:textures/gui/equipment.png");
    private class_2960 DARK_EQUIPMENT = new class_2960("essentialgui:textures/gui/equipment_dark.png");
    private class_2960 TEXTURE;
    private class_2960 SHULKER = new class_2960("essentialgui:textures/gui/shulker_box.png");
    private class_2960 BUNDLE = new class_2960("essentialgui:textures/gui/bundle.png");
    private class_310 client;
    private class_327 textRenderer;
    private int width;
    private int height;
    private class_1799 helmet;
    private class_1799 chestplate;
    private class_1799 leggings;
    private class_1799 boots;
    private class_1799 mainHand;
    private class_1799 offHand;
    private boolean helmetDamaged;
    private boolean chestplateDamaged;
    private boolean leggingsDamaged;
    private boolean bootsDamaged;
    private boolean mainHandDamaged;
    private boolean offHandDamaged;
    private int helmetDur;
    private int chestplateDur;
    private int leggingsDur;
    private int bootsDur;
    private int mainHandDur;
    private int offHandDur;
    private String helmetDurability;
    private String chestplateDurability;
    private String leggingsDurability;
    private String bootsDurability;
    private String mainHandDurability;
    private String offHandDurability;
    private int helmetDurabilityWidth;
    private int chestplateDurabilityWidth;
    private int leggingsDurabilityWidth;
    private int bootsDurabilityWidth;
    private int mainHandDurabilityWidth;
    private int offHandDurabilityWidth;
    private boolean isLeftAltPressed;
    private boolean isChatOpen;
    private boolean shulkerBoxInHand;
    private boolean bundleInHand;
    private boolean isDarkMode;
    public static boolean isPlayerStatsOpen;
    private int cursorIcons;

    public PlayerEquipment(class_310 client, class_4597.class_4598 vertexConsumers) {
        super(client, vertexConsumers);
        this.client = client;
        this.textRenderer = client.field_1772;
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.helmet = client.field_1724.method_6118(class_1304.field_6169);
        this.chestplate = client.field_1724.method_6118(class_1304.field_6174);
        this.leggings = client.field_1724.method_6118(class_1304.field_6172);
        this.boots = client.field_1724.method_6118(class_1304.field_6166);
        this.mainHand = client.field_1724.method_6118(class_1304.field_6173);
        this.offHand = client.field_1724.method_6118(class_1304.field_6171);
        this.helmetDamaged = !this.helmet.method_7960() && this.helmet.method_7909() instanceof class_1738;
        this.chestplateDamaged = !this.chestplate.method_7960() && (this.chestplate.method_7909() instanceof class_1738 || this.chestplate.method_7909() instanceof class_1770);
        this.leggingsDamaged = !this.leggings.method_7960();
        this.bootsDamaged = !this.boots.method_7960();
        this.mainHandDamaged = !this.mainHand.method_7960() && this.mainHand.method_7963();
        this.offHandDamaged = !this.offHand.method_7960() && this.offHand.method_7963();
        this.helmetDur = this.helmet.method_7936() - this.helmet.method_7919();
        this.chestplateDur = this.chestplate.method_7936() - this.chestplate.method_7919();
        this.leggingsDur = this.leggings.method_7936() - this.leggings.method_7919();
        this.bootsDur = this.boots.method_7936() - this.boots.method_7919();
        this.mainHandDur = this.mainHand.method_7936() - this.mainHand.method_7919();
        this.offHandDur = this.offHand.method_7936() - this.offHand.method_7919();
        boolean percentStyle = Config.playerOnScreenEquipmentDurabilityFormat.contains("percent");
        this.helmetDurability = String.valueOf(percentStyle && this.helmetDamaged ? this.helmetDur * 100 / this.helmet.method_7936() + "%" : Integer.valueOf(this.helmetDur));
        this.chestplateDurability = String.valueOf(percentStyle && this.chestplateDamaged ? this.chestplateDur * 100 / this.chestplate.method_7936() + "%" : Integer.valueOf(this.chestplateDur));
        this.leggingsDurability = String.valueOf(percentStyle && this.leggingsDamaged ? this.leggingsDur * 100 / this.leggings.method_7936() + "%" : Integer.valueOf(this.leggingsDur));
        this.bootsDurability = String.valueOf(percentStyle && this.bootsDamaged ? this.bootsDur * 100 / this.boots.method_7936() + "%" : Integer.valueOf(this.bootsDur));
        this.mainHandDurability = String.valueOf(percentStyle && this.mainHandDamaged ? this.mainHandDur * 100 / this.mainHand.method_7936() + "%" : Integer.valueOf(this.mainHandDur));
        this.offHandDurability = String.valueOf(percentStyle && this.offHandDamaged ? this.offHandDur * 100 / this.offHand.method_7936() + "%" : Integer.valueOf(this.offHandDur));
        this.helmetDurabilityWidth = this.textRenderer.method_1727(this.helmetDurability);
        this.chestplateDurabilityWidth = this.textRenderer.method_1727(this.chestplateDurability);
        this.leggingsDurabilityWidth = this.textRenderer.method_1727(this.leggingsDurability);
        this.bootsDurabilityWidth = this.textRenderer.method_1727(this.bootsDurability);
        this.mainHandDurabilityWidth = this.textRenderer.method_1727(this.mainHandDurability);
        this.offHandDurabilityWidth = this.textRenderer.method_1727(this.offHandDurability);
        this.isLeftAltPressed = KeyBindings.contextualMenu.method_1434();
        this.isChatOpen = client.field_1755 instanceof class_408;
        this.shulkerBoxInHand = Config.playerEquipmentShulkerBoxHud != false && !this.mainHand.method_7960() && class_2248.method_9503((class_1792)this.mainHand.method_7909()) instanceof class_2480 && client.field_1765 != null && client.field_1765.method_17783() != class_239.class_240.field_1332 && client.field_1765.method_17783() != class_239.class_240.field_1331;
        this.bundleInHand = Config.playerEquipmentBundleHud != false && !this.mainHand.method_7960() && this.mainHand.method_7909() == class_1802.field_27023 && client.field_1765 != null && client.field_1765.method_17783() != class_239.class_240.field_1332 && client.field_1765.method_17783() != class_239.class_240.field_1331;
        this.isDarkMode = Config.playerStatsHudTextureType.contains("dark");
        isPlayerStatsOpen = false;
        this.cursorIcons = 0;
        this.TEXTURE = this.isDarkMode ? this.DARK_EQUIPMENT : this.EQUIPMENT;
        this.drawPlayerEquipment(this);
    }

    private void drawPlayerEquipment(class_332 context) {
        int quiverY;
        boolean quiverHotbar = Config.playerEquipmentQuiverHudLocation.contains("hotbar");
        int lowDurabilityX = this.width / 2 + 32;
        int lowDurabilityY = this.height / 2 - 24;
        int quiverX = quiverHotbar ? (!this.offHand.method_7960() ? this.width / 2 - 143 : this.width / 2 - 120) : lowDurabilityX;
        int n = quiverY = quiverHotbar ? this.height - 22 : lowDurabilityY;
        if (!this.client.field_1724.method_7325()) {
            if (Config.playerStatsHud.booleanValue()) {
                this.drawPlayerStatsHud(context);
            }
            if (Config.playerEquipmentQuiverHud.booleanValue()) {
                this.drawPlayerQuiverHud(context, quiverX + 23 * this.cursorIcons, quiverY);
            }
            if (Config.playerEquipmentFoodStatsHud.booleanValue()) {
                this.drawPlayerFoodStatsHud(context);
            }
            if (Config.playerEquipmentLowDurabilityWarningHud.booleanValue()) {
                this.drawLowDurabilityWarningHud(context, lowDurabilityX + 23 * this.cursorIcons, lowDurabilityY);
            }
            if (Config.playerEquipmentShulkerBoxHud.booleanValue()) {
                this.drawPlayerShulkerBoxHud(context);
            }
            if (Config.playerOnScreenEquipment.booleanValue()) {
                this.drawPlayerOnScreenEquipment(context);
            }
            if (Config.playerEquipmentBundleHud.booleanValue()) {
                this.drawPlayerBundleHud(context);
            }
            if (Config.playerEquipmentInventoryCount.booleanValue() && !this.client.field_1724.method_7337()) {
                this.drawPlayerInventoryCount(context);
            }
        }
    }

    private void drawPlayerStatsHud(class_332 context) {
        if (this.shulkerBoxInHand || this.bundleInHand) {
            return;
        }
        if (this.client.field_1765 != null && this.client.field_1765.method_17783() == class_239.class_240.field_1332) {
            return;
        }
        if (this.client.field_1765 != null && this.client.field_1765.method_17783() == class_239.class_240.field_1331) {
            return;
        }
        if (this.isLeftAltPressed && !this.isChatOpen) {
            isPlayerStatsOpen = true;
            int equipmentX = (this.width - 101) / 2;
            int equipmentY = (this.height - 86) / 2 + 20;
            int xpStatsX = equipmentX;
            int xpStatsY = equipmentY - 37;
            int healthStatsX = equipmentX - 102;
            int healthStatsY = equipmentY - 37;
            int epfStatsX = healthStatsX;
            int epfStatsY = equipmentY;
            int attackStatsX = equipmentX + 102;
            int attackStatsY = xpStatsY;
            int statusEffectsX = equipmentX + 102;
            int statusEffectsY = equipmentY;
            int helmetX = equipmentX + 8;
            int helmetY = equipmentY + 8;
            int chestplateX = equipmentX + 8;
            int chestplateY = equipmentY + 26;
            int leggingsX = equipmentX + 8;
            int leggingsY = equipmentY + 44;
            int bootsX = equipmentX + 8;
            int bootsY = equipmentY + 62;
            int mainHandX = equipmentX + 77;
            int mainHandY = equipmentY + 8;
            int offHandX = equipmentX + 77;
            int offHandY = equipmentY + 26;
            int arrowsX = equipmentX + 77;
            int arrowsY = equipmentY + 44;
            int totemsX = equipmentX + 77;
            int totemsY = equipmentY + 62;
            context.method_25302(this.TEXTURE, equipmentX, equipmentY, 102, 37, 101, 86);
            class_490.method_2486((class_332)context, (int)(equipmentX + 49), (int)(equipmentY + 76), (int)31, (float)0.0f, (float)0.0f, (class_1309)this.client.field_1724);
            this.drawInventoryHelmet(context, this.helmet, helmetX, helmetY);
            this.drawInventoryChestplate(context, this.chestplate, chestplateX, chestplateY);
            this.drawInventoryLeggings(context, this.leggings, leggingsX, leggingsY);
            this.drawInventoryBoots(context, this.boots, bootsX, bootsY);
            this.drawInventoryMainHand(context, this.mainHand, mainHandX, mainHandY);
            this.drawInventoryOffHand(context, this.offHand, offHandX, offHandY);
            this.drawInventoryArrows(context, arrowsX, arrowsY);
            this.drawInventoryTotems(context, totemsX, totemsY);
            if (Config.playerStatsHudXpStats.booleanValue()) {
                this.drawPlayerXpStats(context, this.client.field_1724, xpStatsX, xpStatsY);
            }
            if (Config.playerStatsHudHealthStats.booleanValue()) {
                this.drawPlayerHealthStats(context, (class_1657)this.client.field_1724, healthStatsX, healthStatsY);
            }
            if (Config.playerStatsHudEpfStats.booleanValue()) {
                this.drawPlayerEpfStats(context, (class_1657)this.client.field_1724, epfStatsX, epfStatsY);
            }
            if (Config.playerStatsHudAttackStats.booleanValue()) {
                this.drawPlayerAttackStats(context, (class_1657)this.client.field_1724, attackStatsX, attackStatsY);
            }
            if (Config.playerStatsHudStatusEffects.booleanValue()) {
                this.drawPlayerStatusEffects(context, statusEffectsX, statusEffectsY);
            }
        }
    }

    private void drawPlayerXpStats(class_332 context, class_746 player, int x, int y) {
        class_2960 skin = player.method_3117();
        context.method_25302(this.TEXTURE, x, y, 102, 0, 101, 36);
        RenderSystem.enableBlend();
        context.method_25293(skin, x + 8, y + 8, 19, 20, 8.0f, 8.0f, 8, 8, 64, 64);
        context.method_25293(skin, x + 8, y + 8, 19, 20, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
        String level = class_2561.method_43471((String)"hud.player_equipment_hud.xp_level").getString() + String.format(Locale.GERMAN, "\u00a7a%,d", player.field_7520);
        String xp = class_2561.method_43471((String)"hud.player_equipment_hud.xp").getString() + String.format(Locale.GERMAN, "\u00a7a%,d", player.field_7495);
        context.method_25303(this.textRenderer, level, x + 34, y + 7, 0xFFFFFF);
        context.method_25303(this.textRenderer, xp, x + 34, y + 21, 0xFFFFFF);
    }

    private void drawPlayerHealthStats(class_332 context, class_1657 player, int x, int y) {
        int healthValue = (int)Math.ceil(player.method_6032());
        int hungerValue = player.method_7344().method_7586();
        int saturationValue = (int)player.method_7344().method_7589();
        String health = (healthValue >= 0 && healthValue <= 7 ? "\u00a7c" : (healthValue > 7 && healthValue <= 14 ? "\u00a76" : "\u00a7a")) + healthValue;
        String hunger = (hungerValue >= 0 && hungerValue <= 7 ? "\u00a7c" : (hungerValue > 7 && hungerValue <= 14 ? "\u00a76" : "\u00a7a")) + hungerValue;
        String saturation = (saturationValue > 0 ? "\u00a7a" : "\u00a7c") + saturationValue;
        context.method_25302(this.TEXTURE, x, y, 0, 0, 101, 36);
        context.method_25300(this.textRenderer, health, x + 41, y + 14, 0xFFFFFF);
        this.method_25300(this.textRenderer, hunger, x + 60, y + 7, 0xFFFFFF);
        this.method_25300(this.textRenderer, saturation, x + 60, y + 21, 0xFFFFFF);
    }

    private void drawPlayerEpfStats(class_332 context, class_1657 player, int x, int y) {
        class_8109 damageSources = player.method_48923();
        int armorValue = player.method_6096();
        int armorToughnessValue = (int)player.method_26825(class_5134.field_23725);
        int blastAmount = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)damageSources.method_48807((class_1927)null));
        int fireAmount = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)damageSources.method_48813());
        int projectileAmount = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)damageSources.method_48803((class_1665)null, null));
        int featherFallingAmount = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)damageSources.method_48827());
        String armor = (armorValue > 0 ? "\u00a7a" : "\u00a7c") + armorValue;
        String armorToughness = (armorToughnessValue > 0 ? "\u00a7a" : "\u00a76") + armorToughnessValue;
        String blastProtection = (blastAmount > 0 && blastAmount <= 20 ? "\u00a7a" : (blastAmount > 20 ? "\u00a7c" : "\u00a76")) + blastAmount;
        String fireProtection = (fireAmount > 0 && fireAmount <= 20 ? "\u00a7a" : (fireAmount > 20 ? "\u00a7c" : "\u00a76")) + fireAmount;
        String projectileProtection = (projectileAmount > 0 && projectileAmount <= 20 ? "\u00a7a" : (projectileAmount > 20 ? "\u00a7c" : "\u00a76")) + projectileAmount;
        String featherFallingProtection = (featherFallingAmount > 0 && featherFallingAmount <= 20 ? "\u00a7a" : (featherFallingAmount > 20 ? "\u00a7c" : "\u00a76")) + featherFallingAmount;
        context.method_25302(this.TEXTURE, x, y, 0, 37, 101, 86);
        context.method_25300(this.textRenderer, armor, x + 17, y + 14, 0xFFFFFF);
        context.method_25300(this.textRenderer, armorToughness, x + 84, y + 14, 0xFFFFFF);
        context.method_25300(this.textRenderer, blastProtection, x + 39, y + 41, 0xFFFFFF);
        context.method_25300(this.textRenderer, fireProtection, x + 62, y + 41, 0xFFFFFF);
        context.method_25300(this.textRenderer, projectileProtection, x + 39, y + 65, 0xFFFFFF);
        context.method_25300(this.textRenderer, featherFallingProtection, x + 62, y + 65, 0xFFFFFF);
    }

    private void drawPlayerAttackStats(class_332 context, class_1657 player, int x, int y) {
        String attack = "\u00a7a" + PlayerEquipment.getPlayerAttack(player)[0];
        String attackSpeed = String.format(Locale.ROOT, "\u00a7a%.1f", PlayerEquipment.getPlayerAttack(player)[1]);
        context.method_25302(this.TEXTURE, x, y, 0, 124, 101, 36);
        context.method_25300(this.textRenderer, attack, x + 40, y + 14, 0xFFFFFF);
        context.method_25300(this.textRenderer, attackSpeed, x + 62, y + 14, 0xFFFFFF);
    }

    public static double[] getPlayerAttack(class_1657 player) {
        class_1799 mainHand = player.method_6118(class_1304.field_6173);
        double attackValue = player.method_26825(class_5134.field_23721);
        double attackSpeedValue = player.method_26825(class_5134.field_23723);
        if (!mainHand.method_7960()) {
            for (class_1322 modifier : mainHand.method_7926(class_1304.field_6173).get((Object)class_5134.field_23721)) {
                attackValue += modifier.method_6186();
            }
            if (mainHand.method_7942()) {
                attackValue += (double)class_1890.method_8218((class_1799)mainHand, (class_1310)class_1310.field_6290);
            }
        }
        double[] d = new double[]{attackValue, attackSpeedValue};
        return d;
    }

    private void drawPlayerStatusEffects(class_332 context, int x, int y) {
        context.method_25302(this.TEXTURE, x, y, 0, 161, 101, 86);
        this.drawStatusEffectsPlayerStats(context, x, y);
    }

    private void drawStatusEffectsPlayerStats(class_332 context, int x, int y) {
        Collection collection = this.client.field_1724.method_6026();
        if (!collection.isEmpty()) {
            int separator = 7;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            List iterable = Ordering.natural().sortedCopy((Iterable)collection);
            for (class_1293 statusEffectInstance : iterable) {
                class_1291 statusEffect = statusEffectInstance.method_5579();
                String prefix = statusEffect.method_18792() == class_4081.field_18271 ? "\u00a72" : "\u00a7c";
                String effect = prefix + class_1074.method_4662((String)statusEffectInstance.method_5579().method_5567(), (Object[])new Object[0]);
                if (statusEffectInstance.method_5578() >= 1 && statusEffectInstance.method_5578() <= 9) {
                    effect = effect + " " + class_1074.method_4662((String)("enchantment.level." + (statusEffectInstance.method_5578() + 1)), (Object[])new Object[0]);
                }
                effect = effect + " \u00a77(" + class_1292.method_5577((class_1293)statusEffectInstance, (float)1.0f).getString() + ")";
                float scale = 0.7f;
                int effectX = Math.round((float)x / scale);
                int effectY = Math.round((float)y / scale);
                context.method_51448().method_22903();
                context.method_51448().method_22905(scale, scale, 1.0f);
                context.method_25303(this.textRenderer, effect, effectX + 7, effectY + 7, 0xFFFFFF);
                context.method_51448().method_22909();
                y += separator;
            }
        } else {
            context.method_25303(this.textRenderer, class_1074.method_4662((String)"hud.player_equipment_hud.status_effects_none", (Object[])new Object[0]), x + 7, y + 7, 0xFFFFFF);
        }
    }

    private void drawPlayerQuiverHud(class_332 context, int x, int y) {
        String arrows;
        boolean isBow = !this.mainHand.method_7960() && this.mainHand.method_7909() instanceof class_1811 || !this.offHand.method_7960() && this.offHand.method_7909() instanceof class_1811;
        boolean hasEnchantments = (isBow && this.mainHand.method_7942() && this.mainHand.method_7921().toString().contains("infinity") || this.offHand.method_7942() && this.offHand.method_7921().toString().contains("infinity")) && this.getArrowCount() > 0;
        boolean infiniteArrows = hasEnchantments || this.client.field_1724.method_7337();
        int arrowCount = this.getArrowCount();
        String string = infiniteArrows ? "\u00a72\u221e" : (arrows = (arrowCount <= 0 ? "\u00a74" : (arrowCount > 0 && arrowCount < 10 ? "\u00a7c" : "\u00a72")) + arrowCount);
        if (isBow) {
            if (Config.playerEquipmentQuiverHudLocation.contains("hotbar")) {
                this.drawQuiverHotbar(context, x, y, arrows);
            } else {
                if (Utils.isCenterHudOpen()) {
                    return;
                }
                if (!class_437.method_25442()) {
                    return;
                }
                this.drawQuiverCrosshair(context, x, y, arrowCount, arrows);
                ++this.cursorIcons;
            }
        }
    }

    private void drawQuiverHotbar(class_332 context, int x, int y, String arrows) {
        RenderSystem.enableBlend();
        context.method_25302(this.WIDGETS, x, y, 24, 23, 22, 22);
        context.method_25302(this.ICONS, x + 2, y + 3, 96, 0, 16, 16);
        RenderSystem.disableBlend();
        context.method_25303(this.textRenderer, arrows, x + 20 - this.textRenderer.method_1727(arrows), y + 12, -1);
    }

    private void drawQuiverCrosshair(class_332 context, int x, int y, int arrowCount, String arrows) {
        int yPos = arrowCount >= 10 ? 37 : 0;
        context.method_25302(this.EQUIPMENT, x, y, 204, yPos, 22, 36);
        context.method_25302(this.ICONS, x + 2, y + 17, 96, 0, 16, 16);
        context.method_25300(this.textRenderer, arrows, x + 12, y + 4, -1);
    }

    private void drawPlayerFoodStatsHud(class_332 context) {
        class_4174 foodComponent;
        boolean offHandFood;
        if (!this.client.field_1724.method_33190()) {
            return;
        }
        boolean mainHandFood = !this.mainHand.method_7960() && this.mainHand.method_19267();
        boolean bl = offHandFood = !this.offHand.method_7960() && this.offHand.method_19267();
        class_4174 class_41742 = mainHandFood ? this.mainHand.method_7909().method_19264() : (foodComponent = offHandFood ? this.offHand.method_7909().method_19264() : null);
        if (mainHandFood || offHandFood) {
            String foodAmount = String.valueOf(foodComponent.method_19230());
            int foodAmountWidth = this.client.field_1772.method_1727(foodAmount);
            int foodX = ((class_4061)this.client.field_1690.method_42565().method_41753()).method_7362() == 2 && this.client.field_1724.method_7261(0.0f) < 1.0f ? this.width / 2 + 120 : this.width / 2 + 98;
            int foodY = this.height - 22;
            RenderSystem.enableBlend();
            context.method_25302(this.WIDGETS, foodX, foodY, 24, 23, 22, 22);
            context.method_25293(this.ICONS, foodX + 4, foodY + 4, 13, 13, 45.0f, -9.0f, 9, 9, 256, 256);
            RenderSystem.disableBlend();
            context.method_25303(this.textRenderer, foodAmount, foodX + 20 - foodAmountWidth, foodY + 12, 0xFFFFFF);
        }
    }

    private void drawLowDurabilityWarningHud(class_332 context, int x, int y) {
        if (!this.client.field_1690.method_31044().method_31034()) {
            return;
        }
        if (!this.client.field_1724.method_33190()) {
            return;
        }
        if (this.mainHandDamaged && this.mainHandDur <= 20 && !Utils.isCenterHudOpen()) {
            if (System.currentTimeMillis() / 1000L % 2L == 1L) {
                context.method_25302(this.EQUIPMENT, x, y, 204, 0, 22, 36);
                context.method_25300(this.textRenderer, this.mainHandDurability, x + 12, y + 4, this.mainHand.method_31580());
                context.method_51427(this.mainHand, x + 2, y + 17);
            }
            ++this.cursorIcons;
        }
    }

    private void drawPlayerInventoryCount(class_332 context) {
        boolean attackIndicator;
        boolean foodInHand = Config.playerEquipmentFoodStatsHud != false && !this.mainHand.method_7960() && this.mainHand.method_19267() || Config.playerEquipmentFoodStatsHud != false && !this.offHand.method_7960() && this.offHand.method_19267();
        boolean bl = attackIndicator = ((class_4061)this.client.field_1690.method_42565().method_41753()).method_7362() == 2 && this.client.field_1724.method_7261(0.0f) < 1.0f;
        int countX = attackIndicator ? (foodInHand ? this.width / 2 + 143 : this.width / 2 + 121) : (foodInHand ? this.width / 2 + 121 : this.width / 2 + 98);
        int countY = this.height - 22;
        if (!this.mainHand.method_7960()) {
            int count = this.getInventoryCount(this.mainHand.method_7909());
            RenderSystem.enableBlend();
            context.method_25302(this.WIDGETS, countX, countY, 24, 23, 22, 22);
            RenderSystem.disableBlend();
            context.method_51427(new class_1799((class_1935)class_1802.field_27023), countX + 3, countY + 2);
            context.method_51432(this.textRenderer, new class_1799((class_1935)this.mainHand.method_7909()), countX + 3, countY + 3, String.valueOf(count));
        }
    }

    private void drawPlayerShulkerBoxHud(class_332 context) {
        int shulkerX = (this.width - 178) / 2;
        int shulkerY = (this.height - 90) / 2;
        if (this.shulkerBoxInHand) {
            boolean customColor = ((class_2480)class_2248.method_9503((class_1792)this.mainHand.method_7909())).method_10528() != null;
            class_2487 nbtCompound = this.mainHand.method_7941("BlockEntityTag");
            if (nbtCompound != null && nbtCompound.method_10573("Items", 9) && this.isLeftAltPressed && !this.isChatOpen) {
                int i;
                class_2371 defaultedList = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)nbtCompound, (class_2371)defaultedList);
                if (customColor) {
                    float[] shulkerColor = ((class_2480)class_2248.method_9503((class_1792)this.mainHand.method_7909())).method_10528().method_7787();
                    context.method_51422(shulkerColor[0], shulkerColor[1], shulkerColor[2], 1.0f);
                } else {
                    int r = 151;
                    int g = 101;
                    int b = 151;
                    context.method_51422((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
                }
                this.method_25302(this.SHULKER, shulkerX, shulkerY, 0, 0, 176, 81);
                context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                context.method_51433(this.textRenderer, this.mainHand.method_7964().getString(), shulkerX + 7, shulkerY + 6, Draw.black.getRGB(), false);
                for (i = 0; i < 9; ++i) {
                    Draw.drawItem(context, (class_1799)defaultedList.get(i), shulkerX + 18 * i + 8, shulkerY + 18);
                }
                for (i = 9; i < 18; ++i) {
                    Draw.drawItem(context, (class_1799)defaultedList.get(i), shulkerX + 18 * i - 154, shulkerY + 36);
                }
                for (i = 18; i < 27; ++i) {
                    Draw.drawItem(context, (class_1799)defaultedList.get(i), shulkerX + 18 * i - 316, shulkerY + 54);
                }
            }
        }
    }

    private void drawPlayerBundleHud(class_332 context) {
        class_2487 nbtCompound;
        int bundleX = (this.width - 158) / 2;
        int bundleY = (this.height - 200) / 2;
        if (this.bundleInHand && (nbtCompound = this.mainHand.method_7969()) != null && nbtCompound.method_10545("Items") && this.isLeftAltPressed && !this.isChatOpen) {
            class_1799 itemStack;
            int i;
            context.method_25302(this.BUNDLE, bundleX, bundleY, 0, 0, 158, 171);
            context.method_51433(this.textRenderer, this.mainHand.method_7964().getString(), bundleX + 7, bundleY + 6, Draw.black.getRGB(), false);
            class_2499 nbtList = nbtCompound.method_10554("Items", 10);
            for (i = 0; i < 8; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i + 8, bundleY + 18);
            }
            for (i = 8; i < 16; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 136, bundleY + 36);
            }
            for (i = 16; i < 24; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 280, bundleY + 54);
            }
            for (i = 24; i < 32; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 424, bundleY + 72);
            }
            for (i = 32; i < 40; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 568, bundleY + 90);
            }
            for (i = 40; i < 48; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 712, bundleY + 108);
            }
            for (i = 48; i < 56; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 856, bundleY + 126);
            }
            for (i = 56; i < 64; ++i) {
                itemStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                Draw.drawItem(context, itemStack, bundleX + 18 * i - 1000, bundleY + 144);
            }
        }
    }

    private void drawPlayerOnScreenEquipment(class_332 context) {
        int playerEquipmentX;
        boolean isTopLeft = Config.playerOnScreenEquipmentHudLocation.contains("top_left");
        boolean isRightSide = Config.playerOnScreenEquipmentHudLocation.contains("middle_right");
        boolean isBottom = Config.playerOnScreenEquipmentHudLocation.contains("bottom");
        boolean isVanillaTexture = Config.playerOnScreenEquipmentTextureType.contains("vanilla");
        boolean isEssGuiTexture = Config.playerOnScreenEquipmentTextureType.contains("essential_gui");
        boolean showArms = Config.playerOnScreenEquipmentArms;
        boolean showBorders = !Config.playerOnScreenEquipmentTextureType.contains("borderless");
        int n = playerEquipmentX = isRightSide ? this.width - 21 : 3;
        int playerEquipmentY = isTopLeft ? 3 : (Config.playerOnScreenEquipmentArms != false ? this.height / 2 - 42 : this.height / 2 - 17);
        int helmetX = playerEquipmentX + 1;
        int helmetY = playerEquipmentY + 1;
        int chestplateX = playerEquipmentX + 1;
        int chestplateY = playerEquipmentY + 20;
        int leggingsX = playerEquipmentX + 1;
        int leggingsY = playerEquipmentY + 39;
        int bootsX = playerEquipmentX + 1;
        int bootsY = playerEquipmentY + 58;
        int mainHandX = playerEquipmentX + 1;
        int mainHandY = playerEquipmentY + 77;
        int offHandX = playerEquipmentX + 1;
        int offHandY = playerEquipmentY + 96;
        if (isBottom) {
            playerEquipmentX = this.width / 2 - 112;
            playerEquipmentY = this.height - 61;
            offHandX = playerEquipmentX - 5;
            offHandY = playerEquipmentY - 20;
            helmetX = playerEquipmentX - 5;
            helmetY = playerEquipmentY - 1;
            chestplateX = playerEquipmentX - 5;
            chestplateY = playerEquipmentY + 18;
            mainHandX = playerEquipmentX + 213;
            mainHandY = playerEquipmentY - 20;
            leggingsX = playerEquipmentX + 213;
            leggingsY = playerEquipmentY - 1;
            bootsX = playerEquipmentX + 213;
            bootsY = playerEquipmentY + 18;
        }
        if (!isBottom) {
            if (isEssGuiTexture) {
                Draw.drawCustomRectangle(context, playerEquipmentX - 2, playerEquipmentY - 2, 21, showArms ? 116 : 78, showBorders);
                for (i = 0; i < (showArms ? 6 : 4); ++i) {
                    Draw.drawBoxItem(context, playerEquipmentX, playerEquipmentY + 19 * i, showBorders);
                }
            } else if (isVanillaTexture) {
                RenderSystem.enableBlend();
                if (showArms) {
                    context.method_25302(this.EQUIPMENT, playerEquipmentX - 2, playerEquipmentY - 2, 234, 0, 22, 117);
                } else {
                    context.method_25302(this.EQUIPMENT, playerEquipmentX - 2, playerEquipmentY - 2, 234, 0, 22, 58);
                    context.method_25302(this.EQUIPMENT, playerEquipmentX - 2, playerEquipmentY + 56, 234, 96, 22, 21);
                }
            }
        } else if (isEssGuiTexture) {
            Draw.drawCustomRectangle(context, playerEquipmentX - 8, showArms ? playerEquipmentY - 23 : playerEquipmentY - 4, 21, showArms ? 59 : 40, showBorders);
            Draw.drawCustomRectangle(context, playerEquipmentX + 210, showArms ? playerEquipmentY - 23 : playerEquipmentY - 4, 21, showArms ? 59 : 40, showBorders);
            for (i = 0; i < (showArms ? 3 : 2); ++i) {
                Draw.drawBoxItem(context, playerEquipmentX - 6, playerEquipmentY - 19 * i + 17, showBorders);
                Draw.drawBoxItem(context, playerEquipmentX + 212, playerEquipmentY - 19 * i + 17, showBorders);
            }
        } else if (isVanillaTexture) {
            RenderSystem.enableBlend();
            if (showArms) {
                context.method_25302(this.EQUIPMENT, playerEquipmentX - 8, playerEquipmentY - 23, 234, 0, 22, 39);
                context.method_25302(this.EQUIPMENT, playerEquipmentX - 8, playerEquipmentY + 16, 234, 96, 22, 21);
                context.method_25302(this.EQUIPMENT, playerEquipmentX + 210, playerEquipmentY - 23, 234, 0, 22, 39);
                context.method_25302(this.EQUIPMENT, playerEquipmentX + 210, playerEquipmentY + 16, 234, 96, 22, 21);
            } else {
                context.method_25302(this.EQUIPMENT, playerEquipmentX - 8, playerEquipmentY - 4, 234, 0, 22, 20);
                context.method_25302(this.EQUIPMENT, playerEquipmentX - 8, playerEquipmentY + 16, 234, 96, 22, 21);
                context.method_25302(this.EQUIPMENT, playerEquipmentX + 210, playerEquipmentY - 4, 234, 0, 22, 20);
                context.method_25302(this.EQUIPMENT, playerEquipmentX + 210, playerEquipmentY + 16, 234, 96, 22, 21);
            }
        }
        this.drawOnScreenHelmet(context, helmetX, helmetY);
        this.drawOnScreenChestplate(context, chestplateX, chestplateY);
        this.drawOnScreenLeggings(context, leggingsX, leggingsY);
        this.drawOnScreenBoots(context, bootsX, bootsY);
        if (showArms) {
            this.drawOnScreenMainHand(context, mainHandX, mainHandY);
            this.drawOnScreenOffHand(context, offHandX, offHandY);
        }
        if (Config.playerOnScreenEquipmentDurability.booleanValue()) {
            boolean borders = Config.playerOnScreenEquipmentDurabilityStyle.contains("borders");
            boolean background = Config.playerOnScreenEquipmentDurabilityStyle.contains("background");
            if (this.helmetDamaged) {
                helmetX = isRightSide || isBottom ? helmetX - this.helmetDurabilityWidth - 6 : helmetX + 23;
                Draw.drawBoxText(context, helmetX, helmetY += 5, this.helmetDurability, borders, background, this.helmet.method_31580());
            }
            if (this.chestplateDamaged) {
                chestplateX = isRightSide || isBottom ? chestplateX - this.chestplateDurabilityWidth - 6 : chestplateX + 23;
                Draw.drawBoxText(context, chestplateX, chestplateY += 5, this.chestplateDurability, borders, background, this.chestplate.method_31580());
            }
            if (this.leggingsDamaged) {
                leggingsX = isRightSide ? leggingsX - this.leggingsDurabilityWidth - 6 : leggingsX + 23;
                Draw.drawBoxText(context, leggingsX, leggingsY += 5, this.leggingsDurability, borders, background, this.leggings.method_31580());
            }
            if (this.bootsDamaged) {
                bootsX = isRightSide ? bootsX - this.bootsDurabilityWidth - 6 : bootsX + 23;
                Draw.drawBoxText(context, bootsX, bootsY += 5, this.bootsDurability, borders, background, this.boots.method_31580());
            }
            if (Config.playerOnScreenEquipmentArms.booleanValue()) {
                if (this.mainHandDamaged) {
                    mainHandX = isRightSide ? mainHandX - this.mainHandDurabilityWidth - 6 : mainHandX + 23;
                    Draw.drawBoxText(context, mainHandX, mainHandY += 5, this.mainHandDurability, borders, background, this.mainHand.method_31580());
                }
                if (this.offHandDamaged) {
                    offHandX = isRightSide || isBottom ? offHandX - this.offHandDurabilityWidth - 6 : offHandX + 23;
                    Draw.drawBoxText(context, offHandX, offHandY += 5, this.offHandDurability, borders, background, this.offHand.method_31580());
                }
            }
        }
    }

    private void drawOnScreenHelmet(class_332 context, int x, int y) {
        boolean isHelmetArmor = this.helmet.method_7909() instanceof class_1738;
        if (this.helmet.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 0, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.helmet, x, !isHelmetArmor ? y - 1 : y);
        }
    }

    private void drawOnScreenChestplate(class_332 context, int x, int y) {
        if (this.chestplate.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 16, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.chestplate, x, y);
        }
    }

    private void drawOnScreenLeggings(class_332 context, int x, int y) {
        if (this.leggings.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 32, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.leggings, x, y);
        }
    }

    private void drawOnScreenBoots(class_332 context, int x, int y) {
        if (this.boots.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 48, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.boots, x, y);
        }
    }

    private void drawOnScreenMainHand(class_332 context, int x, int y) {
        if (this.mainHand.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 80, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.mainHand, x, y);
        }
    }

    private void drawOnScreenOffHand(class_332 context, int x, int y) {
        if (this.offHand.method_7960()) {
            context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
            RenderSystem.enableBlend();
            context.method_25302(this.ICONS, x, y, 64, 0, 16, 16);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.drawItem(context, this.offHand, x, y);
        }
    }

    private void drawInventoryHelmet(class_332 context, class_1799 helmet, int x, int y) {
        if (helmet.method_7960()) {
            context.method_25302(this.ICONS, x, y, 176, 0, 16, 16);
        } else {
            Draw.drawItem(context, helmet, x, y);
        }
    }

    private void drawInventoryChestplate(class_332 context, class_1799 chestplate, int x, int y) {
        if (chestplate.method_7960()) {
            context.method_25302(this.ICONS, x, y, 192, 0, 16, 16);
        } else {
            Draw.drawItem(context, chestplate, x, y);
        }
    }

    private void drawInventoryLeggings(class_332 context, class_1799 leggings, int x, int y) {
        if (leggings.method_7960()) {
            context.method_25302(this.ICONS, x, y, 208, 0, 16, 16);
        } else {
            Draw.drawItem(context, leggings, x, y);
        }
    }

    private void drawInventoryBoots(class_332 context, class_1799 boots, int x, int y) {
        if (boots.method_7960()) {
            context.method_25302(this.ICONS, x, y, 224, 0, 16, 16);
        } else {
            Draw.drawItem(context, boots, x, y);
        }
    }

    private void drawInventoryMainHand(class_332 context, class_1799 mainHand, int x, int y) {
        if (mainHand.method_7960()) {
            context.method_25302(this.ICONS, x, y, 0, 16, 16, 16);
        } else {
            Draw.drawItem(context, mainHand, x, y);
        }
    }

    private void drawInventoryOffHand(class_332 context, class_1799 offHand, int x, int y) {
        if (offHand.method_7960()) {
            context.method_25302(this.ICONS, x, y, 240, 0, 16, 16);
        } else {
            Draw.drawItem(context, offHand, x, y);
        }
    }

    private void drawInventoryArrows(class_332 context, int x, int y) {
        String arrows = String.valueOf(this.getArrowCount());
        int arrowsWidth = this.client.field_1772.method_1727(arrows);
        if (this.getArrowCount() <= 0) {
            context.method_25302(this.ICONS, x, y, 16, 16, 16, 16);
        } else {
            context.method_25302(this.ICONS, x, y, 96, 0, 16, 16);
            context.method_25303(this.textRenderer, arrows, x + 17 - arrowsWidth, y + 9, 0xFFFFFF);
        }
    }

    private void drawInventoryTotems(class_332 context, int x, int y) {
        if (this.getTotemsCount() <= 0) {
            context.method_25302(this.ICONS, x, y, 48, 16, 16, 16);
        } else {
            Draw.drawItem(context, new class_1799((class_1935)class_1802.field_8288, this.getTotemsCount()), x, y);
        }
    }

    private int getInventoryCount(class_1792 item) {
        class_1661 inventory = this.client.field_1724.method_31548();
        int itemCount = 0;
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960() || stack.method_7909() != item) continue;
            itemCount += stack.method_7947();
        }
        return itemCount;
    }

    private int getArrowCount() {
        return this.getInventoryCount(class_1802.field_8107);
    }

    private int getTotemsCount() {
        return this.getInventoryCount(class_1802.field_8288);
    }
}

