/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Color;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lordrius.essentialgui.Config;
import lordrius.essentialgui.gui.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class ClientPlayerWorld
extends class_332 {
    private class_310 client;
    private class_327 textRenderer;
    private class_1297 entity;
    private class_2338 blockPos;
    private class_2791 chunk;
    private int width;
    private boolean isComplete;
    private boolean isShortened;
    private boolean isColoredText;

    public ClientPlayerWorld(class_310 client, class_4597.class_4598 vertexConsumers) {
        super(client, vertexConsumers);
        this.client = client;
        this.textRenderer = client.field_1772;
        this.width = client.method_22683().method_4486();
        this.entity = client.method_1560();
        this.blockPos = client.method_1560().method_24515();
        this.chunk = client.field_1687.method_22350(this.blockPos);
        this.isComplete = Config.clientPlayerWorldPrefixStyle.contains("complete");
        this.isShortened = Config.clientPlayerWorldPrefixStyle.contains("shortened");
        this.isColoredText = Config.clientPlayerWorldColoredText;
        this.drawClientPlayerWorld(this);
    }

    private void drawClientPlayerWorld(class_332 context) {
        boolean isBiomeWeatherDarkTexture = Config.biomeWeatherTimeTextureType.contains("dark");
        boolean isBiomeWeatherHour = Config.biomeWeatherTimeHour;
        boolean isBiomeWeatherLeft = Config.biomeWeatherTime != false && Config.biomeWeatherTimeHudLocation.contains("top_left");
        boolean isBiomeWeatherRight = Config.biomeWeatherTime != false && Config.biomeWeatherTimeHudLocation.contains("top_right");
        boolean isRightSide = Config.clientPlayerWorldHudLocation.contains("top_right");
        boolean showBorders = !Config.clientPlayerWorldHudStyle.contains("borderless");
        boolean individual = Config.clientPlayerWorldHudStyle.contains("individual");
        boolean compactBlock = Config.clientPlayerWorldHudStyle.equalsIgnoreCase("screen.hud_style.compact_block") || Config.clientPlayerWorldHudStyle.equalsIgnoreCase("screen.hud_style.compact_block_borderless");
        boolean compactBlocks = Config.clientPlayerWorldHudStyle.equalsIgnoreCase("screen.hud_style.compact_blocks") || Config.clientPlayerWorldHudStyle.equalsIgnoreCase("screen.hud_style.compact_blocks_borderless");
        boolean debug = Config.clientPlayerWorldHudStyle.contains("debug");
        int biomeWeatherOffset = isBiomeWeatherLeft && !isRightSide || isBiomeWeatherRight && isRightSide ? (isBiomeWeatherDarkTexture ? (isBiomeWeatherHour ? 50 : 34) : (isBiomeWeatherHour ? 46 : 32)) : 0;
        int x = isRightSide ? this.width - 1 : 4;
        int y = 4 + biomeWeatherOffset;
        if (individual) {
            for (int i = 0; i < this.getStringListIndividual().size(); ++i) {
                String s = Draw.getPrefixColor() + this.getStringListIndividual().get(i);
                if (isRightSide) {
                    Draw.drawBoxTextRight(context, x, 14 * i + y, s, showBorders);
                    continue;
                }
                Draw.drawBoxText(context, x, 14 * i + y, s, showBorders);
            }
        } else if (compactBlock) {
            if (isRightSide) {
                Draw.drawBoxTextDynamicWithStringsRight(context, x, y, this.getStringListCompact(), showBorders);
            } else {
                Draw.drawBoxTextDynamicWithStrings(context, x, y, this.getStringListCompact(), showBorders);
            }
        } else if (compactBlocks) {
            int worldInfoY;
            int playerPositionY = this.getClientPerformanceStrings().size() > 0 ? y + 11 * this.getClientPerformanceStrings().size() + 4 : y;
            int n = worldInfoY = this.getPlayerPositionStrings().size() > 0 ? playerPositionY + 11 * this.getPlayerPositionStrings().size() + 4 : playerPositionY;
            if (isRightSide) {
                Draw.drawBoxTextDynamicWithStringsRight(context, x, y, this.getClientPerformanceStrings(), showBorders);
                Draw.drawBoxTextDynamicWithStringsRight(context, x, playerPositionY, this.getPlayerPositionStrings(), showBorders);
                Draw.drawBoxTextDynamicWithStringsRight(context, x, worldInfoY, this.getWorldInfoStrings(), showBorders);
            } else {
                Draw.drawBoxTextDynamicWithStrings(context, x, y, this.getClientPerformanceStrings(), showBorders);
                Draw.drawBoxTextDynamicWithStrings(context, x, playerPositionY, this.getPlayerPositionStrings(), showBorders);
                Draw.drawBoxTextDynamicWithStrings(context, x, worldInfoY, this.getWorldInfoStrings(), showBorders);
            }
        } else if (debug) {
            for (int i = 0; i < this.getStringListIndividual().size(); ++i) {
                String string = Draw.getPrefixColor() + this.getStringListIndividual().get(i);
                Objects.requireNonNull(this.textRenderer);
                int j = 9;
                int k = this.textRenderer.method_1727(string);
                int l = isRightSide ? this.client.method_22683().method_4486() - k : x;
                int m = y + 10 * i;
                context.method_25294(l - 3, m - 3, l + k - 1, m + j - 2, new Color(Config.getSectionsRed(), Config.getSectionsGreen(), Config.getSectionsBlue(), Config.getSectionsAlpha()).getRGB());
                context.method_25303(this.textRenderer, string, l - 2, m - 2, Draw.GRAY.getRGB());
            }
        } else {
            this.drawSimpleHUD(context, showBorders);
        }
    }

    private List<String> getStringListCompact() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getClientPerformanceStrings());
        if (this.getClientPerformanceStrings().size() > 0 && (this.getPlayerPositionStrings().size() > 0 || this.getWorldInfoStrings().size() > 0)) {
            list.add("");
        }
        list.addAll(this.getPlayerPositionStrings());
        if (this.getWorldInfoStrings().size() > 0 && (this.getPlayerPositionStrings().size() > 0 || this.getClientPerformanceStrings().size() <= 0)) {
            list.add("");
        }
        list.addAll(this.getWorldInfoStrings());
        return list;
    }

    private List<String> getStringListIndividual() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getClientPerformanceStrings());
        list.addAll(this.getPlayerPositionStrings());
        list.addAll(this.getWorldInfoStrings());
        return list;
    }

    private List<String> getClientPerformanceStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (Config.clientPerformance.booleanValue()) {
            if (Config.clientPerformanceFps.booleanValue()) {
                list.add(this.getClientFps());
            }
            if (Config.clientPerformanceCpuLoad.booleanValue()) {
                list.add(this.getClientCPU());
            }
            if (Config.clientPerformanceMemory.booleanValue()) {
                list.add(this.getClientMemory());
            }
            if (Config.clientPerformanceLatency.booleanValue() && !this.client.method_1496()) {
                list.add(this.getClientLatency());
            }
            if (Config.clientPerformanceNetworkPackets.booleanValue() && !this.client.method_1496()) {
                list.add(this.getDebugNetwork());
            }
        }
        return list;
    }

    private List<String> getPlayerPositionStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (Config.playerPosition.booleanValue()) {
            if (Config.playerPositionCoords.booleanValue()) {
                list.add(this.getPlayerCoordinates());
                if (Config.playerPositionDimensionalCoords.booleanValue() && this.client.field_1687.method_8597().comp_643()) {
                    list.add(this.getPlayerCoordinatesNether());
                }
            }
            if (Config.playerPositionChunk.booleanValue()) {
                list.add(this.getPlayerChunkPosition());
            }
            if (Config.playerPositionFacing.booleanValue()) {
                list.add(this.getPlayerFacing());
            }
            if (Config.playerPositionRotation.booleanValue()) {
                list.add(this.getPlayerRotation());
            }
            if (Config.playerPositionLight.booleanValue()) {
                list.add(this.getPlayerLight());
            }
            if (Config.playerPositionSpeed.booleanValue()) {
                list.add(this.getPlayerSpeed());
            }
        }
        return list;
    }

    private List<String> getWorldInfoStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (Config.worldInfo.booleanValue()) {
            if (Config.worldInfoBiome.booleanValue()) {
                list.add(this.getBiomeName());
            }
            if (Config.worldInfoDebugEntities.booleanValue()) {
                list.add(this.getDebugEntities());
            }
            if (Config.worldInfoDebugTileEntities.booleanValue()) {
                list.add(this.getDebugTileEntities());
            }
            if (Config.worldInfoTime.booleanValue()) {
                list.add(this.getWorldDayTime());
            }
            if (Config.worldInfoDays.booleanValue()) {
                list.add(this.getWorldDays());
            }
        }
        return list;
    }

    private String getClientFps() {
        boolean unlimited;
        boolean hasVsync = (Boolean)this.client.field_1690.method_42433().method_41753();
        int refreshRate = this.client.method_22683().method_22092();
        int maxfps = (Integer)this.client.field_1690.method_42524().method_41753();
        boolean bl = unlimited = (Integer)this.client.field_1690.method_42524().method_41753() == 260;
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.fps_start").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.fps_prefix").getString() : "");
        String prefix = header + "\u00a7r" + this.client.method_47599();
        return prefix + (String)(hasVsync ? "/" + refreshRate : (unlimited ? "" : "/" + maxfps));
    }

    private String getClientCPU() {
        String header;
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        double cpu = osBean.getCpuLoad() * 100.0;
        String string = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.cpu").getString() : (header = this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.cpu_prefix").getString() : "");
        String prefix = this.isColoredText ? (cpu > 0.0 && cpu < 46.0 ? "\u00a72" : (cpu >= 46.0 && cpu < 76.0 ? "\u00a76" : "\u00a7c")) : "\u00a77";
        return String.format(header + "\u00a7r" + prefix + "%.0f", cpu) + "%";
    }

    private String getClientMemory() {
        String header;
        long l = Runtime.getRuntime().maxMemory();
        long m = Runtime.getRuntime().totalMemory();
        long n = Runtime.getRuntime().freeMemory();
        long o = m - n;
        long p = o * 100L / l;
        float f = (float)o / 1024.0f / 1024.0f / 1024.0f;
        float g = (float)l / 1024.0f / 1024.0f / 1024.0f;
        String string = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.memory").getString() : (header = this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.memory_prefix").getString() : "");
        String color = this.isColoredText ? (p >= 0L && p < 46L ? "\u00a72" : (p >= 46L && p < 76L ? "\u00a76" : "\u00a7c")) : "\u00a77";
        return String.format(Locale.ROOT, header + "\u00a7r" + color + "%d%%\u00a7r (%.1f/%.1fGB)", p, Float.valueOf(f), Float.valueOf(g));
    }

    private String getClientLatency() {
        String header;
        int latency;
        class_634 handler = this.client.field_1724.field_3944;
        class_640 playerListEntry = handler.method_2871(this.client.field_1724.method_5667());
        int n = latency = playerListEntry != null ? playerListEntry.method_2959() : 0;
        String string = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.latency").getString() : (header = this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.latency_prefix").getString() : "");
        String color = this.isColoredText ? (latency <= 179 ? "\u00a72" : "\u00a7c") : "\u00a77";
        return header + "\u00a7r" + color + latency + class_2561.method_43471((String)"hud.client-player-world.latency_suffix").getString();
    }

    private String getDebugNetwork() {
        float f = this.client.method_1562().method_48296().method_10745();
        float g = this.client.method_1562().method_48296().method_10762();
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.network").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.network_prefix").getString() : "");
        String arrowUp = this.isColoredText ? "\u00a7c\u2191\u00a7r" : "\u2191";
        String arrowDown = this.isColoredText ? "\u00a72\u2193\u00a7r" : "\u2193";
        return String.format(header + "\u00a7r%.0f " + arrowUp + " %.0f " + arrowDown, Float.valueOf(f), Float.valueOf(g));
    }

    private String getPlayerCoordinates() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.coordinates").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.coordinates_prefix").getString() : "");
        String colored = String.format(Locale.ROOT, header + "\u00a7c%d \u00a72%d \u00a79%d", this.entity.method_31477(), this.entity.method_31478(), this.entity.method_31479());
        String nonColored = String.format(Locale.ROOT, header + "\u00a7r%d %d %d", this.entity.method_31477(), this.entity.method_31478(), this.entity.method_31479());
        return this.isColoredText ? colored : nonColored;
    }

    private String getPlayerCoordinatesSimple() {
        String colored = String.format(Locale.ROOT, "\u00a7c%d \u00a72%d \u00a79%d", this.entity.method_31477(), this.entity.method_31478(), this.entity.method_31479());
        String nonColored = String.format(Locale.ROOT, "\u00a7r%d %d %d", this.entity.method_31477(), this.entity.method_31478(), this.entity.method_31479());
        return this.isColoredText ? colored : nonColored;
    }

    private String getPlayerCoordinatesNether() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.coordinates_nether").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.coordinates_nether_prefix").getString() : "");
        return String.format(Locale.ROOT, header + "\u00a7r\u00a78%d %d", this.entity.method_31477() * 8, this.entity.method_31479() * 8);
    }

    private String getPlayerChunkPosition() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.chunk").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.chunk_prefix").getString() : "");
        String colored = String.format(header + "\u00a7c%d \u00a72%d \u00a79%d", this.blockPos.method_10263() & 0xF, this.blockPos.method_10264() & 0xF, this.blockPos.method_10260() & 0xF) + (this.isSlimeChunk() ? "  \u00a7a\\\u263b/" : "");
        String nonColored = String.format(header + "\u00a7r%d %d %d", this.blockPos.method_10263() & 0xF, this.blockPos.method_10264() & 0xF, this.blockPos.method_10260() & 0xF) + (this.isSlimeChunk() ? "  \u00a77\\\u263b/" : "");
        return this.isColoredText ? colored : nonColored;
    }

    private String getPlayerFacing() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.facing").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.facing.prefix").getString() : "");
        return String.format(Locale.ROOT, header + "\u00a7r%s", this.getPlayerFacingAxis());
    }

    private String getPlayerFacingAxis() {
        boolean axisInfo = Config.playerPositionFacingAxisInfo;
        int yaw = (int)this.client.field_1724.method_36454();
        yaw += 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        int facingValue = yaw / 45;
        class_5250 facingPoint = class_2561.method_43473();
        String axis = "";
        switch (facingValue) {
            case 0: {
                facingPoint = class_2561.method_43471((String)"hud.facing.south");
                axis = this.isColoredText ? " \u00a7r(\u00a79+Z\u00a7r)" : " \u00a7r(+Z\u00a7r)";
                break;
            }
            case 1: {
                facingPoint = class_2561.method_43471((String)"hud.facing.south-west");
                axis = this.isColoredText ? " \u00a7r(\u00a79+Z\u00a7r)" : " \u00a7r(+Z\u00a7r)";
                break;
            }
            case 2: {
                facingPoint = class_2561.method_43471((String)"hud.facing.west");
                axis = this.isColoredText ? " \u00a7r(\u00a7c-X\u00a77)" : " \u00a7r(-X\u00a77)";
                break;
            }
            case 3: {
                facingPoint = class_2561.method_43471((String)"hud.facing.north-west");
                axis = this.isColoredText ? " \u00a7r(\u00a79-Z\u00a7r)" : " \u00a7r(-Z\u00a7r)";
                break;
            }
            case 4: {
                facingPoint = class_2561.method_43471((String)"hud.facing.north");
                axis = this.isColoredText ? " \u00a7r(\u00a79-Z\u00a7r)" : " \u00a7r(-Z\u00a7r)";
                break;
            }
            case 5: {
                facingPoint = class_2561.method_43471((String)"hud.facing.north-east");
                axis = this.isColoredText ? " \u00a7r(\u00a79-Z\u00a7r)" : " \u00a7r(-Z\u00a7r)";
                break;
            }
            case 6: {
                facingPoint = class_2561.method_43471((String)"hud.facing.east");
                axis = this.isColoredText ? " \u00a7r(\u00a7c+X\u00a7r)" : " \u00a7r(+X\u00a7r)";
                break;
            }
            case 7: {
                facingPoint = class_2561.method_43471((String)"hud.facing.south-east");
                axis = this.isColoredText ? " \u00a7r(\u00a79+Z\u00a7r)" : " \u00a7r(+Z\u00a7r)";
            }
        }
        return facingPoint.getString().concat(axisInfo ? axis : "");
    }

    private String getPlayerRotation() {
        float degreesPitch = class_3532.method_15393((float)this.entity.method_36455());
        float degreesYaw = class_3532.method_15393((float)this.entity.method_36454());
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.rotation").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.rotation_prefix").getString() : "");
        return String.format(Locale.ROOT, header + "\u00a7r%.1f/%.1f", Float.valueOf(degreesYaw), Float.valueOf(degreesPitch));
    }

    private String getPlayerLight() {
        if (this.chunk != null) {
            String lightBlockPrefix;
            String lightSkyPrefix;
            String lightSubstractedPrefix;
            int getLightSubstracted = this.client.field_1687.method_2935().method_12130().method_22363(this.blockPos, 0);
            int getLightSky = this.client.field_1687.method_8314(class_1944.field_9284, this.blockPos);
            int getLightBlock = this.client.field_1687.method_8314(class_1944.field_9282, this.blockPos);
            String string = this.isColoredText ? (getLightSubstracted <= 0 ? "\u00a7c" : "\u00a72") : (lightSubstractedPrefix = "\u00a77");
            String string2 = this.isColoredText ? (getLightSky <= 0 ? "\u00a7c" : "\u00a73") : (lightSkyPrefix = "\u00a77");
            String string3 = this.isColoredText ? (getLightBlock <= 0 ? "\u00a7c" : "\u00a76") : (lightBlockPrefix = "\u00a77");
            String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.light").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.light_prefix").getString() : "");
            return header + "\u00a7r" + lightSubstractedPrefix + getLightSubstracted + "\u00a7r (" + lightSkyPrefix + getLightSky + " \u00a7r| " + lightBlockPrefix + getLightBlock + "\u00a7r)";
        }
        return "";
    }

    private String getPlayerSpeed() {
        class_243 lastPos = new class_243(this.client.field_1724.field_6038, this.client.field_1724.field_5971, this.client.field_1724.field_5989);
        class_243 pos = new class_243(this.client.field_1724.method_23317(), this.client.field_1724.method_23318(), this.client.field_1724.method_23321());
        double speed = Math.abs(lastPos.method_1022(pos) * 20.0);
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.speed").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.speed_prefix").getString() : "");
        return String.format(Locale.ROOT, header + "\u00a7r%.1f" + class_2561.method_43471((String)"hud.client-player-world.speed_suffix").getString(), speed);
    }

    private String getBiomeName() {
        if (this.chunk != null) {
            boolean coldBiome = ((class_1959)this.client.field_1687.method_23753(this.blockPos).comp_349()).method_33599(this.blockPos);
            boolean hotBiome = ((class_1959)this.client.field_1687.method_23753(this.blockPos).comp_349()).method_8712() > 1.0f;
            String biome = (String)this.client.field_1687.method_23753(this.blockPos).method_40229().map(biomeKey -> biomeKey.method_29177().toString(), biome_ -> "[unregistered " + biome_ + "]");
            String biomePath = biome.replaceAll(":", ".");
            boolean isVanillaBiome = biome.contains("minecraft");
            String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.biome").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.biome_prefix").getString() : "");
            String nonVanillaBiome = Utils.capitalizeTitleString(((class_5321)this.client.field_1687.method_23753(this.blockPos).method_40229().left().get()).method_29177().method_12832().replace("_", " "));
            String prefix = this.isColoredText ? (isVanillaBiome ? (coldBiome ? "\u00a73" : (hotBiome ? "\u00a76" : "\u00a72")) : "\u00a75") : "\u00a77";
            return header + "\u00a7r" + prefix + (isVanillaBiome ? class_2561.method_43471((String)("biome." + biomePath)).getString() : nonVanillaBiome);
        }
        return "";
    }

    private String getDebugEntities() {
        String debugEntitiesString = this.client.field_1769.method_3272().replaceAll("E: ", "").replaceAll(",.*", "");
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.entities").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.entities_prefix").getString() : "");
        return String.format(header + "\u00a7r" + debugEntitiesString, new Object[0]);
    }

    private String getDebugTileEntities() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.tiles").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.tiles_prefix").getString() : "");
        return header + "\u00a7r" + this.client.field_1687.method_8500(this.blockPos).method_12214().size();
    }

    private String getWorldDayTime() {
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.time").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.time_prefix").getString() : "");
        return header + Utils.getTimeString(Config.worldInfoTimeStyle);
    }

    private String getWorldDays() {
        long timeOfDay = this.client.field_1687.method_8532();
        long days = timeOfDay / 24000L;
        String header = this.isComplete ? class_2561.method_43471((String)"hud.client-player-world.days").getString() : (this.isShortened ? class_2561.method_43471((String)"hud.client-player-world.days_prefix").getString() : "");
        return String.format(Locale.GERMAN, header + "\u00a7r%,d", days);
    }

    private boolean isSlimeChunk() {
        if (this.client.method_1496()) {
            return class_2919.method_12662((int)this.chunk.method_12004().field_9181, (int)this.chunk.method_12004().field_9180, (long)this.client.method_1576().method_27728().method_28057().method_28028(), (long)987234911L).method_43048(10) == 0;
        }
        return false;
    }

    private void drawSimpleHUD(class_332 context, boolean withBorders) {
        int width = this.client.method_22683().method_4486();
        int height = this.client.method_22683().method_4502();
        String s = this.getPlayerCoordinatesSimple() + "\u00a7r \u00b7 " + this.getPlayerFacingAxis() + " \u00a7r\u00b7 " + Utils.getTimeString(Config.worldInfoTimeStyle);
        int sWidth = this.textRenderer.method_1727(s);
        Draw.drawBoxTextCenter(context, (width - sWidth + 2) / 2, height - 85, sWidth, s, withBorders);
    }
}

