/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import lordrius.essentialgui.Config;
import lordrius.essentialgui.gui.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

public class BiomeWeatherTime
extends class_332 {
    private class_2960 TEXTURE = new class_2960("essentialgui:textures/gui/biome_weather_time.png");
    private class_327 textRenderer;
    private class_1937 world;
    private class_2338 blockPos;
    private class_2791 chunk;
    private int width;
    private int height;

    public BiomeWeatherTime(class_310 client, class_4597.class_4598 vertexConsumers) {
        super(client, vertexConsumers);
        this.textRenderer = client.field_1772;
        this.world = client.field_1687;
        this.blockPos = client.field_1719.method_24515();
        this.chunk = client.field_1687.method_22350(this.blockPos);
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        if (Config.biomeWeatherTimeHudLocation.contains("top_center")) {
            if (client.field_1690.field_1907.method_1434()) {
                return;
            }
            if (client.field_1765.method_17783() == class_239.class_240.field_1331 || client.field_1765.method_17783() == class_239.class_240.field_1332) {
                return;
            }
        }
        this.drawBiomeWeatherTime(this);
    }

    private void drawBiomeWeatherTime(class_332 context) {
        int iconScale;
        int x;
        boolean isDarkTexture = Config.biomeWeatherTimeTextureType.contains("dark");
        boolean isTopLeft = Config.biomeWeatherTimeHudLocation.contains("top_left");
        boolean isTopRight = Config.biomeWeatherTimeHudLocation.contains("top_right");
        boolean isBottomRight = Config.biomeWeatherTimeHudLocation.contains("bottom_right");
        boolean isCustom = Config.biomeWeatherTimeHudLocation.contains("custom");
        boolean showWorldTime = Config.biomeWeatherTimeHour;
        boolean showBorders = !Config.biomeWeatherTimeTextureType.contains("borderless");
        String worldTimeStyle = Config.biomeWeatherTimeHourStyle;
        int n = isCustom ? Config.biomeWeatherTimeHudLocationX : (isTopLeft ? 1 : (isTopRight || isBottomRight ? (isDarkTexture ? this.width - 94 : this.width - 88) : (x = isDarkTexture ? this.width / 2 - 47 : this.width / 2 - 44)));
        int y = isCustom ? Config.biomeWeatherTimeHudLocationY : (isTopLeft || isTopRight ? 1 : (isBottomRight ? (isDarkTexture ? this.height - 34 : this.height - 32) : 1 + Utils.getBossBarsRendered() * 20));
        int iconsX = x + 2;
        int iconsY = y + 3;
        int n2 = iconScale = isDarkTexture ? 27 : 25;
        if (isDarkTexture) {
            this.method_25302(this.TEXTURE, x, y, 0, 0, 93, 33);
        } else {
            Draw.drawCustomRectangle(context, x, y, 86, 30, showBorders);
            for (int i = 0; i < 3; ++i) {
                Draw.drawCustomRectangle(context, iconsX + 28 * i, iconsY - 1, 26, 26, showBorders);
            }
        }
        if (showWorldTime) {
            int offset;
            int n3 = isBottomRight ? (isDarkTexture ? 50 : 46) : (offset = 0);
            if (isDarkTexture) {
                context.method_25302(this.TEXTURE, x, y + 34 - offset, 0, 33, 93, 15);
                context.method_25300(this.textRenderer, Utils.getTimeString(worldTimeStyle), x + 47, y + 38 - offset, Draw.GRAY.getRGB());
            } else {
                Draw.drawBoxTextCenter(context, x + 3, y + 35 - offset, 82, Utils.getTimeString(worldTimeStyle), showBorders);
            }
            float scale = 0.6f;
            int i = Math.round((float)x / scale + (float)(isDarkTexture ? 6 : 4));
            int j = isBottomRight ? Math.round((float)y / scale - (float)(isDarkTexture ? 22 : 20)) : Math.round((float)y / scale + (float)(isDarkTexture ? 61 : 56));
            context.method_51448().method_22903();
            context.method_51448().method_22905(scale, scale, 1.0f);
            context.method_51427(class_1802.field_8557.method_7854(), i, j);
            context.method_51427(class_1802.field_8557.method_7854(), i + (isDarkTexture ? 127 : 121), j);
            context.method_51448().method_22909();
        }
        this.drawDayTimeIcon(context, iconsX + 1, iconsY, iconScale);
        this.drawBiomeIcon(context, isDarkTexture ? iconsX + 31 : iconsX + 29, iconsY, iconScale);
        this.drawWeatherIcon(context, isDarkTexture ? iconsX + 61 : iconsX + 57, iconsY, iconScale);
        if (Config.biomeWeatherTimeSlimes.booleanValue()) {
            this.drawSlimeIcon(context, isDarkTexture ? iconsX + 19 : iconsX + 17, isDarkTexture ? iconsY + 18 : iconsY + 16, 9);
        }
    }

    private void drawDayTimeIcon(class_332 context, int x, int y, int scale) {
        Object id = "";
        id = this.world.method_8597().comp_642() ? (Utils.isSunrise() ? "sunrise" : (Utils.isMorning() ? "morning" : (Utils.isDay() ? "day" : (Utils.isNoon() ? "noon" : (Utils.isSunset() ? "sunset" : "moon_phase" + this.world.method_30273()))))) : (this.world.method_8597().comp_643() ? "nether_day" : "end_day");
        class_2960 identifier = new class_2960("essentialgui:textures/environment/" + (String)id + ".png");
        context.method_25293(identifier, x, y, scale, scale, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void drawWeatherIcon(class_332 context, int x, int y, int scale) {
        String id = "";
        boolean coldBiome = ((class_1959)this.world.method_23753(this.blockPos).comp_349()).method_33599(this.blockPos);
        id = this.world.method_8597().comp_642() ? (this.world.method_8419() ? (this.world.method_8546() ? "thunder" : (coldBiome ? "snow" : "rain")) : (Utils.isNight() ? "clear_night" : "clear")) : (this.world.method_8597().comp_643() ? "nether_weather" : "end_weather");
        class_2960 identifier = new class_2960("essentialgui:textures/environment/" + id + ".png");
        context.method_25293(identifier, x, y, scale, scale, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void drawSlimeIcon(class_332 context, int x, int y, int scale) {
        if (Utils.isNight() && this.world.method_8597().comp_642() && (this.world.method_30273() == 0 || this.world.method_30273() == 4)) {
            class_2960 identifier = new class_2960("essentialgui:textures/icons.png");
            context.method_25293(identifier, x, y, scale, scale, this.world.method_30273() == 0 ? 192.0f : 208.0f, 32.0f, 16, 16, 256, 256);
        }
    }

    private void drawBiomeIcon(class_332 context, int x, int y, int scale) {
        if (this.chunk != null) {
            boolean isMinecraftBiome = ((class_5321)this.world.method_23753(this.blockPos).method_40229().left().get()).method_29177().method_12836().contains("minecraft");
            String biomeName = (String)this.world.method_23753(this.blockPos).method_40229().map(biomeKey -> biomeKey.method_29177().method_12832(), biome_ -> "[unregistered " + biome_ + "]");
            class_2960 identifier = new class_2960("essentialgui:textures/biome/" + (isMinecraftBiome ? biomeName : "none") + ".png");
            context.method_25293(identifier, x, y, scale, scale, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }
}

