/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.mixin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4228;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import team.creative.ambientsounds.sound.OggAudioStreamExtended;

@Mixin(value={class_4228.class})
public abstract class OggAudioStreamMixin
implements OggAudioStreamExtended {
    private static final Random RANDOM = new Random();
    @Shadow
    private long field_18907;
    @Shadow
    @Final
    private AudioFormat field_18908;
    @Shadow
    @Final
    private InputStream field_18909;
    @Shadow
    private ByteBuffer field_18910;

    @Override
    public void setPositionRandomly(long length) throws IOException {
        if (length == 0L) {
            return;
        }
        int skipped = RANDOM.nextInt((int)(length - length / 4L));
        this.field_18909.skipNBytes(skipped);
        STBVorbis.stb_vorbis_flush_pushdata((long)this.field_18907);
        this.field_18910.limit(0);
        this.method_19677();
        if (!this.seekTillPage()) {
            throw new IOException("No page found till end of file.");
        }
    }

    private boolean seekTillPage() throws IOException {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer data = memorystack.mallocPointer(1);
            IntBuffer channels = memorystack.mallocInt(1);
            IntBuffer samples = memorystack.mallocInt(1);
            while (true) {
                int used = STBVorbis.stb_vorbis_decode_frame_pushdata((long)this.field_18907, (ByteBuffer)this.field_18910, (IntBuffer)channels, (PointerBuffer)data, (IntBuffer)samples);
                this.field_18910.position(this.field_18910.position() + used);
                int error = STBVorbis.stb_vorbis_get_error((long)this.field_18907);
                if (error == 1) {
                    this.method_19678();
                    if (this.method_19677()) continue;
                    boolean bl = false;
                    return bl;
                }
                if (error != 0) {
                    throw new IOException("Failed to read Ogg file " + error);
                }
                if (used == 0) {
                    this.field_18910.limit(0);
                    this.method_19677();
                    continue;
                }
                int k = samples.get(0);
                if (k == 0) continue;
                int l = channels.get(0);
                if (l != 2 && l != 1) {
                    throw new IllegalStateException("Invalid number of channels: " + l);
                }
                boolean bl = true;
                return bl;
            }
        }
    }

    @Shadow
    private void method_19678() {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private boolean method_19677() throws IOException {
        throw new UnsupportedOperationException();
    }
}

