/*
 * Decompiled with CFR 0.152.
 */
package com.trajectoryguard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.trajectoryguard.KeyInputHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1778;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1823;
import net.minecraft.class_1835;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryGuard {
    public static final Logger logger = LoggerFactory.getLogger((String)"MOD_ID");
    private static final Color MISS_COLOR = Color.GRAY;
    private static final Color ENTITY_HIT_COLOR = Color.RED;
    private static final Color BLOCK_HIT_COLOR = Color.GREEN;
    private static final class_310 client = class_310.method_1551();
    static final double trajectoryOffsetHorizontal = 0.06;
    static final double trajectoryOffsetVertical = -0.025;
    static class_243 hitDestination;

    public static void register() {
        WorldRenderEvents.END.register(context -> TrajectoryGuard.renderTrajectories(context.matrixStack(), context.tickDelta()));
    }

    private static void renderTrajectories(class_4587 matrixStack, float partialTicks) {
        Color color;
        class_746 player = TrajectoryGuard.client.field_1724;
        if (!KeyInputHandler.TrajectoryGuardActive || player.method_7325()) {
            return;
        }
        matrixStack.method_22903();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        class_243 camPos = TrajectoryGuard.client.field_1773.method_19418().method_19326();
        Trajectory trajectory = TrajectoryGuard.getTrajectory(partialTicks, player, camPos);
        ArrayList<class_243> path = trajectory.path;
        switch (trajectory.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_1333: {
                Color color2 = MISS_COLOR;
                break;
            }
            case field_1331: {
                Color color2 = ENTITY_HIT_COLOR;
                break;
            }
            case field_1332: {
                Color color2 = color = BLOCK_HIT_COLOR;
            }
        }
        if (!path.isEmpty()) {
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            TrajectoryGuard.drawLines(tessellator, bufferBuilder, matrixStack, path, color, camPos);
            double cameraX = camPos.field_1352;
            double cameraZ = camPos.field_1350;
            double dx = TrajectoryGuard.hitDestination.field_1352 - cameraX;
            double dz = TrajectoryGuard.hitDestination.field_1350 - cameraZ;
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (KeyInputHandler.TrajectoryBoxActive && distance <= 150.0) {
                TrajectoryGuard.drawEndOfLine(tessellator, bufferBuilder, matrixStack, color, partialTicks, camPos);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        matrixStack.method_22909();
    }

    private static Trajectory getTrajectory(float partialTicks, class_746 player, class_243 camPos) {
        if (!KeyInputHandler.TrajectoryGuardActive || player.method_7325()) {
            return new Trajectory(new ArrayList<class_243>(), class_239.class_240.field_1333);
        }
        ArrayList<class_243> path = new ArrayList<class_243>();
        class_239.class_240 type = class_239.class_240.field_1333;
        class_1268 hand = class_1268.field_5808;
        class_1799 stack = player.method_6047();
        if (!TrajectoryGuard.isThrowable(stack)) {
            hand = class_1268.field_5810;
            stack = player.method_6079();
            if (!TrajectoryGuard.isThrowable(stack)) {
                return new Trajectory(path, type);
            }
        }
        class_1792 item = stack.method_7909();
        double throwPower = TrajectoryGuard.getThrowPower(item);
        double gravity = TrajectoryGuard.getProjectileGravity(item);
        double yaw = Math.toRadians(player.method_36454());
        double pitch = Math.toRadians(player.method_36455());
        double throwPitch = TrajectoryGuard.getThrowPitch(item, pitch);
        class_243 arrowPos = TrajectoryGuard.getLerpedPos(player, partialTicks).method_1019(TrajectoryGuard.getHandOffset(hand, yaw));
        class_243 arrowMotion = TrajectoryGuard.getStartingMotion(yaw, pitch, throwPower, throwPitch);
        int renderPathCount = 0;
        for (int i = 0; i < 105; ++i) {
            double entityHitDistance;
            class_243 lastPos;
            path.add(arrowPos);
            arrowPos = arrowPos.method_1019(arrowMotion);
            arrowMotion = arrowMotion.method_1021(0.99);
            arrowMotion = arrowMotion.method_1031(0.0, -gravity, 0.0);
            class_243 class_2432 = lastPos = path.size() > 1 ? path.get(path.size() - 2) : TrajectoryGuard.client.field_1724.method_33571();
            if (type != class_239.class_240.field_1333) continue;
            class_3965 bResult = TrajectoryGuard.client.field_1687.method_17742(new class_3959(lastPos, arrowPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            class_238 box = new class_238(lastPos, arrowPos);
            Predicate<class_1297> predicate = e -> e.method_49108() && !e.method_7325() && !e.method_5655() && e.method_19538().method_1022(camPos) >= 1.7;
            double maxDistSq = 4096.0;
            class_3966 eResult = class_1675.method_18075((class_1297)player, (class_243)lastPos, (class_243)arrowPos, (class_238)box, predicate, (double)maxDistSq);
            double blockHitDistance = bResult != null && bResult.method_17783() != class_239.class_240.field_1333 ? bResult.method_17784().method_1025(lastPos) : Double.MAX_VALUE;
            double d = entityHitDistance = eResult != null && eResult.method_17783() != class_239.class_240.field_1333 ? eResult.method_17784().method_1025(lastPos) : Double.MAX_VALUE;
            if (entityHitDistance < blockHitDistance) {
                type = class_239.class_240.field_1331;
                hitDestination = eResult.method_17784();
                if (renderPathCount > 0) continue;
                renderPathCount = i;
                i = 97;
                continue;
            }
            if (blockHitDistance < Double.MAX_VALUE) {
                type = class_239.class_240.field_1332;
                hitDestination = bResult.method_17784();
                bResult.method_17784();
                if (renderPathCount > 0) continue;
                renderPathCount = i;
                i = 97;
                continue;
            }
            hitDestination = lastPos;
        }
        path = new ArrayList<class_243>(TrajectoryGuard.interpolateTrajectory(path, hitDestination, 2, player));
        return new Trajectory(path, type);
    }

    public static ArrayList<class_243> interpolateTrajectory(ArrayList<class_243> points, class_243 hitDestination, int numPointsBetween, class_746 player) {
        int n = points.size();
        if (n >= 3) {
            double[] x = new double[n];
            double[] y = new double[n];
            double[] z = new double[n];
            double[] t = new double[n];
            for (int i = 0; i < n; ++i) {
                x[i] = points.get(i).method_10216();
                y[i] = points.get(i).method_10214();
                z[i] = points.get(i).method_10215();
                t[i] = i;
            }
            Spline splineX = TrajectoryGuard.computeSpline(t, x);
            Spline splineY = TrajectoryGuard.computeSpline(t, y);
            Spline splineZ = TrajectoryGuard.computeSpline(t, z);
            ArrayList<class_243> interpolatedPoints = new ArrayList<class_243>();
            for (int i = 0; i < n - 1; ++i) {
                interpolatedPoints.add(points.get(i));
                int pointsToInterpolate = Math.max(0, numPointsBetween - i / 5);
                for (int j = 1; j <= pointsToInterpolate; ++j) {
                    double tInterp = t[i] + (double)j * (t[i + 1] - t[i]) / (double)(pointsToInterpolate + 1);
                    double newX = splineX.evaluate(tInterp);
                    double newY = splineY.evaluate(tInterp);
                    double newZ = splineZ.evaluate(tInterp);
                    interpolatedPoints.add(new class_243(newX, newY, newZ));
                }
            }
            interpolatedPoints.add(points.get(n - 1));
            int cutoffIndex = 1;
            for (int i = interpolatedPoints.size() - 1; i > 0; --i) {
                double distanceBetweenPoints;
                class_243 currentPoint = (class_243)interpolatedPoints.get(i);
                class_243 previousPoint = (class_243)interpolatedPoints.get(i - 1);
                double distanceToHit = currentPoint.method_1025(hitDestination);
                if (!(distanceToHit < (distanceBetweenPoints = currentPoint.method_1025(previousPoint)))) continue;
                cutoffIndex = i;
                break;
            }
            ArrayList<class_243> returnList = new ArrayList<class_243>(interpolatedPoints.subList(0, cutoffIndex));
            returnList.add(TrajectoryGuard.client.field_1687.method_17742(new class_3959((class_243)returnList.get(returnList.size() - 1), (class_243)interpolatedPoints.get(cutoffIndex), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player)).method_17784());
            return returnList;
        }
        return points;
    }

    private static Spline computeSpline(double[] t, double[] y) {
        int n = t.length - 1;
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = t[i + 1] - t[i];
        }
        double[] alpha = new double[n];
        for (int i = 1; i < n; ++i) {
            alpha[i] = 3.0 / h[i] * (y[i + 1] - y[i]) - 3.0 / h[i - 1] * (y[i] - y[i - 1]);
        }
        double[] l = new double[n + 1];
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        l[0] = 1.0;
        mu[0] = 0.0;
        z[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            l[i] = 2.0 * (t[i + 1] - t[i - 1]) - h[i - 1] * mu[i - 1];
            mu[i] = h[i] / l[i];
            z[i] = (alpha[i] - h[i - 1] * z[i - 1]) / l[i];
        }
        l[n] = 1.0;
        z[n] = 0.0;
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
        }
        return new Spline(y, b, c, d, t);
    }

    public static ArrayList<class_243> simplifyPoints(ArrayList<class_243> points, class_243 camPos) {
        if (points.size() < 3) {
            return points;
        }
        ArrayList<class_243> result = new ArrayList<class_243>(points);
        int i = 0;
        double angleThreshold = 0.0;
        double ANGLE_INCREMENT = 0.02;
        int consecutiveRemovals = 0;
        while (i < result.size() - 2) {
            class_243 p1 = result.get(i);
            class_243 p2 = result.get(i + 1);
            class_243 p3 = result.get(i + 2);
            double angle = TrajectoryGuard.calculateAngle(p1, p2, p3);
            double d = angleThreshold >= 0.0 ? angleThreshold : 0.0;
            if (angle < d && consecutiveRemovals <= 24 && p2.method_1025(camPos) >= 9.0) {
                result.remove(i + 1);
                ++consecutiveRemovals;
                if (i + 2 < result.size()) {
                    p3 = result.get(i + 1);
                    class_243 p4 = result.get(i + 2);
                    double d2 = TrajectoryGuard.calculateAngle(p1, p3, p4);
                    double d3 = angleThreshold >= 0.0 ? angleThreshold : 0.0;
                    if (d2 >= d3) {
                        ++i;
                        consecutiveRemovals = 0;
                    }
                }
            } else {
                ++i;
                consecutiveRemovals = 0;
            }
            angleThreshold += 0.02;
        }
        return result;
    }

    private static double calculateAngle(class_243 p1, class_243 p2, class_243 p3) {
        class_243 v1 = p2.method_1020(p1);
        class_243 v2 = p3.method_1020(p2);
        double dotProduct = v1.method_1026(v2);
        double magnitude1 = v1.method_1033();
        double magnitude2 = v2.method_1033();
        double angleRad = Math.acos(dotProduct / (magnitude1 * magnitude2));
        return Math.toDegrees(angleRad);
    }

    private static void drawLines(class_289 tessellator, class_287 bufferBuilder, class_4587 matrixStack, ArrayList<class_243> path, Color color, class_243 camPos) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34539);
        boolean isDrawingSegment = false;
        double cameraX = camPos.field_1352;
        double cameraZ = camPos.field_1350;
        double maxDistance = 150.0;
        for (int i = 0; i < path.size(); ++i) {
            class_243 point = path.get(i);
            double dx = point.field_1352 - cameraX;
            double dz = point.field_1350 - cameraZ;
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (distance > maxDistance) break;
            if (!TrajectoryGuard.isPointObstructedByBlock(camPos, point) && !TrajectoryGuard.isPointObstructedByEntity(camPos, point)) {
                if (!isDrawingSegment) {
                    bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
                    TrajectoryGuard.setColor(color, 0.75f);
                    isDrawingSegment = true;
                }
                bufferBuilder.method_22918(matrix, (float)(point.field_1352 - camPos.field_1352), (float)(point.field_1351 - camPos.field_1351), (float)(point.field_1350 - camPos.field_1350)).method_1344();
                continue;
            }
            if (!isDrawingSegment) continue;
            tessellator.method_1350();
            isDrawingSegment = false;
        }
        if (isDrawingSegment) {
            tessellator.method_1350();
        }
    }

    private static boolean isPointObstructedByBlock(class_243 camPos, class_243 point) {
        class_3965 hitResult = TrajectoryGuard.client.field_1687.method_17742(new class_3959(camPos, point, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)TrajectoryGuard.client.field_1724));
        return hitResult.method_17783() != class_239.class_240.field_1333 && hitResult.method_17784().method_1025(camPos) < camPos.method_1025(point);
    }

    private static boolean isPointObstructedByEntity(class_243 camPos, class_243 point) {
        class_238 box = new class_238(camPos, point);
        Predicate<class_1297> predicate = e -> e.method_49108() && !e.method_7325() && !e.method_5655() && e.method_19538().method_1022(camPos) >= 1.7;
        class_3966 eResult = class_1675.method_18075((class_1297)TrajectoryGuard.client.field_1724, (class_243)camPos, (class_243)point, (class_238)box, predicate, (double)camPos.method_1025(point));
        return eResult != null && eResult.method_17783() == class_239.class_240.field_1331;
    }

    private static void drawEndOfLine(class_289 tessellator, class_287 bufferBuilder, class_4587 matrixStack, Color color, float partialTicks, class_243 camPos) {
        class_1268 hand = class_1268.field_5808;
        if (!TrajectoryGuard.isThrowable(TrajectoryGuard.client.field_1724.method_6047())) {
            hand = class_1268.field_5810;
        }
        class_243 offset = TrajectoryGuard.getHandOffset(hand, Math.toRadians(TrajectoryGuard.client.field_1724.method_36454()));
        double boxSize = 0.5;
        boolean isDrawingSegment = false;
        if (!isDrawingSegment) {
            RenderSystem.setShader(class_757::method_34539);
            bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1592);
            matrixStack.method_22903();
            matrixStack.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
            isDrawingSegment = false;
            TrajectoryGuard.drawOutlinedBoxBetter(matrixStack, (class_4588)bufferBuilder, TrajectoryGuard.hitDestination.field_1352 - offset.field_1352 - 0.5, TrajectoryGuard.hitDestination.field_1351 - -0.025 - 0.5 - 0.05, TrajectoryGuard.hitDestination.field_1350 - offset.field_1350 - 0.5, TrajectoryGuard.hitDestination.field_1352 - offset.field_1352 + 0.5, TrajectoryGuard.hitDestination.field_1351 - -0.025 + 0.5 - 0.05, TrajectoryGuard.hitDestination.field_1350 - offset.field_1350 + 0.5, color, 1.0f, camPos);
            tessellator.method_1350();
            matrixStack.method_22909();
        } else if (isDrawingSegment) {
            isDrawingSegment = false;
        }
    }

    private static void drawOutlinedBoxBetter(class_4587 matrixStack, class_4588 buffer, double x1, double y1, double z1, double x2, double y2, double z2, Color color, float alpha, class_243 camPos) {
        int i;
        int[] colorInt = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        class_243[] points = new class_243[]{new class_243(x1, y1, z1), new class_243(x1, y1, z2), new class_243(x1, y2, z1), new class_243(x1, y2, z2), new class_243(x2, y1, z1), new class_243(x2, y1, z2), new class_243(x2, y2, z1), new class_243(x2, y2, z2)};
        boolean[] obstructed = new boolean[8];
        boolean allObstructed = true;
        for (i = 0; i < 8; ++i) {
            boolean bl = obstructed[i] = TrajectoryGuard.isPointInsideBlock(points[i]) || TrajectoryGuard.isPointObstructedByBlock(camPos, points[i]);
            if (obstructed[i]) continue;
            allObstructed = false;
        }
        if (allObstructed) {
            return;
        }
        for (i = 0; i < 8; ++i) {
            if (obstructed[i]) continue;
            for (int j = 0; j < 8; ++j) {
                if (i == j || !TrajectoryGuard.isAdjacent(points[i], points[j])) continue;
                class_3965 hitResult = TrajectoryGuard.client.field_1687.method_17742(new class_3959(points[i], points[j], class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)TrajectoryGuard.client.field_1724));
                class_243 hitPoint = hitResult.method_17784();
                TrajectoryGuard.drawThatLine(matrixStack, buffer, points[i], hitPoint, colorInt, alpha);
            }
        }
    }

    private static void drawThatLine(class_4587 matrixStack, class_4588 buffer, class_243 start, class_243 end, int[] colorInt, float alpha) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        buffer.method_22918(matrix, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_1344();
        buffer.method_22918(matrix, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_1344();
    }

    private static boolean isAdjacent(class_243 p1, class_243 p2) {
        return p1.field_1352 == p2.field_1352 && p1.field_1351 == p2.field_1351 || p1.field_1352 == p2.field_1352 && p1.field_1350 == p2.field_1350 || p1.field_1351 == p2.field_1351 && p1.field_1350 == p2.field_1350;
    }

    private static boolean isPointInsideBlock(class_243 point) {
        class_3965 hitResult = TrajectoryGuard.client.field_1687.method_17742(new class_3959(point.method_1031(0.0, 0.001, 0.0), point, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)TrajectoryGuard.client.field_1724));
        return hitResult.method_17783() != class_239.class_240.field_1333;
    }

    private static class_243 getLerpedPos(class_746 player, float partialTicks) {
        return new class_243(player.field_6014 + (player.method_23317() - player.field_6014) * (double)partialTicks, player.field_6036 + (player.method_23318() - player.field_6036) * (double)partialTicks, player.field_5969 + (player.method_23321() - player.field_5969) * (double)partialTicks);
    }

    private static class_243 getHandOffset(class_1268 hand, double yaw) {
        class_1306 mainArm = (class_1306)TrajectoryGuard.client.field_1690.method_42552().method_41753();
        boolean rightSide = mainArm == class_1306.field_6183 && hand == class_1268.field_5808 || mainArm == class_1306.field_6182 && hand == class_1268.field_5810;
        double sideMultiplier = rightSide ? -1.0 : 1.0;
        return new class_243(Math.cos(yaw) * 0.06 * sideMultiplier, (double)TrajectoryGuard.client.field_1724.method_5751() + -0.025, Math.sin(yaw) * 0.06 * sideMultiplier);
    }

    private static class_243 getStartingMotion(double yaw, double pitch, double throwPower, double throwPitch) {
        double cosOfPitch = Math.cos(pitch + throwPitch);
        return new class_243(-Math.sin(yaw) * cosOfPitch, -Math.sin(pitch + throwPitch), Math.cos(yaw) * cosOfPitch).method_1029().method_1021(throwPower);
    }

    private static double getThrowPower(class_1792 item) {
        if (item instanceof class_1753) {
            float bowPower = (float)(72000 - TrajectoryGuard.client.field_1724.method_6014()) / 20.0f;
            if ((bowPower = bowPower * bowPower + bowPower * 2.0f) > 3.0f || bowPower <= 0.3f) {
                bowPower = 3.0f;
            }
            return bowPower;
        }
        if (item instanceof class_1764) {
            return 3.15;
        }
        if (item instanceof class_1835) {
            return 2.5;
        }
        if (item instanceof class_1823) {
            return 1.5;
        }
        if (item instanceof class_1771) {
            return 1.5;
        }
        if (item instanceof class_1776) {
            return 1.5;
        }
        if (item instanceof class_1787) {
            return 1.0;
        }
        if (item instanceof class_4537) {
            return 0.5;
        }
        if (item instanceof class_1779) {
            return 0.7;
        }
        if (item instanceof class_1778) {
            return 2.0;
        }
        return 0.0;
    }

    private static double getProjectileGravity(class_1792 item) {
        if (item instanceof class_1753) {
            return 0.05;
        }
        if (item instanceof class_1764) {
            return 0.05;
        }
        if (item instanceof class_1835) {
            return 0.05;
        }
        if (item instanceof class_4537) {
            return 0.05;
        }
        if (item instanceof class_1779) {
            return 0.07;
        }
        if (item instanceof class_1787) {
            return 0.05;
        }
        if (item instanceof class_1778) {
            return 0.0;
        }
        return 0.03;
    }

    private static double getThrowPitch(class_1792 item, double pitch) {
        double normalizedPitch = Math.abs(pitch);
        double modifier = 1.0 - normalizedPitch / 90.0;
        if (item instanceof class_4537) {
            return -0.2 * modifier;
        }
        if (item instanceof class_1779) {
            return -0.2 * modifier;
        }
        if (item instanceof class_1787) {
            return -0.1 * modifier;
        }
        return 0.0;
    }

    private static boolean isThrowable(class_1799 stack) {
        return stack.method_7909() instanceof class_1811 || stack.method_7909() instanceof class_1823 || stack.method_7909() instanceof class_1771 || stack.method_7909() instanceof class_1776 || stack.method_7909() instanceof class_1835 || stack.method_7909() instanceof class_1778;
    }

    private static void setColor(Color color, float alpha) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
    }

    private static class Trajectory {
        private final ArrayList<class_243> path;
        private final class_239.class_240 type;

        public Trajectory(ArrayList<class_243> path, class_239.class_240 type) {
            this.path = path;
            this.type = type;
        }
    }

    private static class Spline {
        private final double[] a;
        private final double[] b;
        private final double[] c;
        private final double[] d;
        private final double[] t;

        public Spline(double[] a, double[] b, double[] c, double[] d, double[] t) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.t = t;
        }

        public double evaluate(double x) {
            int i = this.findInterval(x);
            double dx = x - this.t[i];
            return this.a[i] + this.b[i] * dx + this.c[i] * dx * dx + this.d[i] * dx * dx * dx;
        }

        private int findInterval(double x) {
            for (int i = 0; i < this.t.length - 1; ++i) {
                if (!(x >= this.t[i]) || !(x <= this.t[i + 1])) continue;
                return i;
            }
            return this.t.length - 2;
        }
    }
}

