/*
 * Decompiled with CFR 0.152.
 */
package jewtvet.elytrahud;

import com.mojang.blaze3d.systems.RenderSystem;
import jewtvet.elytrahud.Common;
import jewtvet.elytrahud.ConfigEnums;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Quaternionf;

public class HudRenderer {
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("elytrahud", "textures/hud_widgets.png");
    private final class_310 client;
    private int scaledWidth;
    private int scaledHeight;
    private int defaultY = 10;
    private double displayedSpeed = 0.0;
    private double displayedDur = 1.0;
    public double displayedHeight = 0.0;
    private double displayedVertical = 0.0;
    private double displayedYaw = 180.0;
    private double displayedPitch = 0.0;
    private double displayedRoll = 0.0;

    public HudRenderer(class_310 client) {
        this.client = client;
    }

    public void render(class_332 graphics, float tickDelta) {
        int rate_x = 10;
        int dur_x = 10;
        int vert_x = 10;
        this.displayedSpeed = class_3532.method_16436((double)tickDelta, (double)this.displayedSpeed, (double)Common.hudData.speed);
        this.displayedDur = Common.hudData.durability;
        this.displayedHeight = Common.hudData.height;
        this.displayedVertical = Common.hudData.vertical_speed;
        this.displayedYaw = Common.hudData.yaw * -1.0 + 180.0;
        this.displayedPitch = Common.hudData.pitch;
        this.displayedRoll = Common.hudData.roll;
        int intAirspeed = (int)Math.round(this.displayedSpeed);
        int intDur = Common.hudData.currentDurability;
        int intHeight = (int)Math.round(this.displayedHeight);
        int intVertical = (int)Math.round(this.displayedVertical);
        int intPitch = (int)Math.round(this.displayedPitch);
        this.defaultY = Common.CONFIG.render_values == ConfigEnums.render_values.Yes ? 15 : 10;
        this.scaledWidth = this.client.method_22683().method_4486();
        this.scaledHeight = this.client.method_22683().method_4502();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (Common.CONFIG.render_airspeed == ConfigEnums.render_airspeed.Yes) {
            rate_x += 102;
            dur_x += 102;
            int speedometer_size = 100;
            int speedometer_x = 10;
            int speedometer_y = speedometer_size + this.defaultY;
            int[] back_gr_airspeed = new int[]{speedometer_x, this.scaledHeight - speedometer_y, 0, 0, 100, 100};
            int[] pointer_airspeed = new int[]{speedometer_x + 49, this.scaledHeight - speedometer_y + 8, 215, 105, 2, 42};
            int[] fore_gr_airspeed = new int[]{speedometer_x + 45, this.scaledHeight - speedometer_y + 45, 215, 73, 10, 10};
            int[] title_airspeed = new int[]{speedometer_x + 33, this.scaledHeight - speedometer_y - 10, 215, 0, 34, 9};
            int[] value_airspeed = new int[]{speedometer_x + 40, this.scaledHeight - speedometer_y + 101, 215, 165, 21, 11};
            if (this.displayedSpeed > 80.0) {
                this.displayedSpeed = 80.0;
            }
            this.renderMeter(graphics, speedometer_x + 50, this.scaledHeight - speedometer_y + 50, (float)Math.toRadians(this.displayedSpeed * 4.5), back_gr_airspeed, pointer_airspeed, fore_gr_airspeed, title_airspeed, value_airspeed, intAirspeed);
        }
        if (Common.CONFIG.render_horizon == ConfigEnums.render_horizon.Yes) {
            dur_x += 52;
            int rate_size = 50;
            int rate_y = rate_size + this.defaultY;
            int intPitchY = intPitch / 2;
            if (intPitchY < -44) {
                intPitchY = -44;
            } else if (intPitchY > 44) {
                intPitchY = 44;
            }
            int horizon_y = 41 + intPitchY;
            int[] horizon_rate = new int[]{rate_x + 3, this.scaledHeight - rate_y + 3, 170, horizon_y, 44, 44};
            int[] back_gr_rate = new int[]{rate_x, this.scaledHeight - rate_y, 100, 100, 50, 50};
            int[] pointer_rate = new int[]{rate_x + 12, this.scaledHeight - rate_y + 24, 215, 176, 26, 3};
            int[] title_rate = new int[]{rate_x + 10, this.scaledHeight - rate_y - 10, 215, 179, 29, 9};
            int[] value_rate = new int[]{rate_x + 15, this.scaledHeight - rate_y + 51, 215, 165, 21, 11};
            this.renderHorizon(graphics, rate_x + 25, this.scaledHeight - rate_y + 25, (float)Math.toRadians(this.displayedRoll), horizon_rate, back_gr_rate, pointer_rate, title_rate, value_rate, intPitch);
        }
        if (Common.CONFIG.render_durability == ConfigEnums.render_durability.Yes) {
            int dur_size = 50;
            int dur_y = dur_size + this.defaultY;
            int topPoint = this.scaledHeight - dur_y + 2;
            int bottomPoint = topPoint + 44;
            int yCoordinate = (int)((double)topPoint + (1.0 - this.displayedDur) * (double)(bottomPoint - topPoint));
            int[] back_gr_dur = new int[]{dur_x, this.scaledHeight - dur_y, 150, 0, 15, 50};
            int[] pointer_dur = new int[]{dur_x + 8, yCoordinate, 215, 56, 4, 3};
            int[] title_dur = new int[]{dur_x, this.scaledHeight - dur_y - 10, 215, 18, 15, 9};
            int[] value_dur = new int[]{dur_x - 3, this.scaledHeight - dur_y + 51, 215, 165, 21, 11};
            this.renderBar(graphics, back_gr_dur, pointer_dur, title_dur, value_dur, intDur);
        }
        if (Common.CONFIG.render_altitude == ConfigEnums.render_altitude.Yes) {
            vert_x += 102;
            int altitude_size = 100;
            int altitude_x = 10 + altitude_size;
            int altitude_y = altitude_size + this.defaultY;
            int[] back_gr_altitude = new int[]{this.scaledWidth - altitude_x, this.scaledHeight - altitude_y, 0, 100, 100, 100};
            int[] pointer1_altitude = new int[]{this.scaledWidth - altitude_x + 49, this.scaledHeight - altitude_y + 32, 215, 147, 2, 18};
            int[] pointer2_altitude = new int[]{this.scaledWidth - altitude_x + 49, this.scaledHeight - altitude_y + 8, 215, 105, 2, 42};
            int[] fore_gr_altitude = new int[]{this.scaledWidth - altitude_x + 45, this.scaledHeight - altitude_y + 45, 215, 83, 10, 10};
            int[] title_altitude = new int[]{this.scaledWidth - altitude_x + 34, this.scaledHeight - altitude_y - 10, 215, 36, 32, 9};
            int[] value_altitude = new int[]{this.scaledWidth - altitude_x + 40, this.scaledHeight - altitude_y + 101, 215, 165, 21, 11};
            this.renderDoubleMeter(graphics, this.scaledWidth - altitude_x + 50, this.scaledHeight - altitude_y + 50, (float)Math.toRadians(this.displayedHeight * (double)0.36f), (float)Math.toRadians(this.displayedHeight * (double)3.6f), back_gr_altitude, pointer1_altitude, pointer2_altitude, fore_gr_altitude, title_altitude, value_altitude, intHeight);
        }
        if (Common.CONFIG.render_vertical == ConfigEnums.render_vertical.Yes) {
            int vert_size = 50;
            int vert_y = vert_size + this.defaultY;
            int[] back_gr_vert = new int[]{this.scaledWidth - (vert_x += vert_size), this.scaledHeight - vert_y, 100, 50, 50, 50};
            int[] pointer_vert = new int[]{this.scaledWidth - vert_x + 24, this.scaledHeight - vert_y + 7, 215, 147, 2, 18};
            int[] fore_gr_vert = new int[]{this.scaledWidth - vert_x + 22, this.scaledHeight - vert_y + 22, 215, 99, 6, 6};
            int[] title_vert = new int[]{this.scaledWidth - vert_x + 11, this.scaledHeight - vert_y - 10, 215, 27, 28, 9};
            int[] value_vert = new int[]{this.scaledWidth - vert_x + 15, this.scaledHeight - vert_y + 51, 215, 165, 21, 11};
            if (this.displayedVertical > 5.0) {
                this.displayedVertical = 5.0;
            } else if (this.displayedVertical < -5.0) {
                this.displayedVertical = -5.0;
            }
            this.renderMeter(graphics, this.scaledWidth - vert_x + 25, this.scaledHeight - vert_y + 25, (float)Math.toRadians((this.displayedVertical + 5.0) * 25.0 + 145.0) % 360.0f, back_gr_vert, pointer_vert, fore_gr_vert, title_vert, value_vert, intVertical);
        }
        if (Common.CONFIG.render_compass == ConfigEnums.render_compass.Yes) {
            int compass_screen = this.scaledWidth - 120;
            double compass_offset = (double)Common.CONFIG.compass_default_x / 100.0 * (double)compass_screen;
            int compass_x = (int)Math.round(compass_offset) + 10;
            int compass_y = 15;
            int[] back_gr_compass = new int[]{compass_x, compass_y, 100, 150, 100, 100};
            int[] pointer_compass = new int[]{compass_x + 45, compass_y + 3, 215, 59, 6, 5};
            int[] fore_gr_compass = new int[]{compass_x + 45, compass_y + 44, 215, 64, 10, 9};
            int[] title_compass = new int[]{compass_x + 35, compass_y - 8, 215, 45, 26, 11};
            this.renderCompass(graphics, compass_x + 50, compass_y + 50, (float)Math.toRadians(this.displayedYaw), back_gr_compass, pointer_compass, fore_gr_compass, title_compass);
            int intYaw = ((int)Math.round(Common.hudData.yaw) + 180) % 360;
            graphics.method_25303(this.client.field_1772, String.format("%3d\u00b0", intYaw), compass_x + 35 + 2, compass_y - 8 + 2, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderDoubleMeter(class_332 graphics, int center_x, int center_y, float angle1, float angle2, int[] back_gr, int[] pointer1, int[] pointer2, int[] fore_gr, int[] title, int[] value, int value_int) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_25302(WIDGETS_TEXTURE, back_gr[0], back_gr[1], back_gr[2], back_gr[3], back_gr[4], back_gr[5]);
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)center_x, (float)center_y, 0.0f);
        Quaternionf rotation1 = new Quaternionf().rotateZ(angle1);
        matrices.method_22907(rotation1);
        matrices.method_46416((float)(-center_x), (float)(-center_y), 0.0f);
        graphics.method_25302(WIDGETS_TEXTURE, pointer1[0], pointer1[1], pointer1[2], pointer1[3], pointer1[4], pointer1[5]);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416((float)center_x, (float)center_y, 0.0f);
        Quaternionf rotation2 = new Quaternionf().rotateZ(angle2);
        matrices.method_22907(rotation2);
        matrices.method_46416((float)(-center_x), (float)(-center_y), 0.0f);
        graphics.method_25302(WIDGETS_TEXTURE, pointer2[0], pointer2[1], pointer2[2], pointer2[3], pointer2[4], pointer2[5]);
        matrices.method_22909();
        graphics.method_25302(WIDGETS_TEXTURE, fore_gr[0], fore_gr[1], fore_gr[2], fore_gr[3], fore_gr[4], fore_gr[5]);
        if (Common.CONFIG.render_titles == ConfigEnums.render_titles.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, title[0], title[1], title[2], title[3], title[4], title[5]);
        }
        if (Common.CONFIG.render_values == ConfigEnums.render_values.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, value[0], value[1], value[2], value[3], value[4], value[5]);
            graphics.method_25303(this.client.field_1772, String.format("%3d", value_int), value[0] + 2, value[1] + 2, 0xFFFFFF);
        }
    }

    private void renderMeter(class_332 graphics, int center_x, int center_y, float angle, int[] back_gr, int[] pointer, int[] fore_gr, int[] title, int[] value, int value_int) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_25302(WIDGETS_TEXTURE, back_gr[0], back_gr[1], back_gr[2], back_gr[3], back_gr[4], back_gr[5]);
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)center_x, (float)center_y, 0.0f);
        Quaternionf rotation = new Quaternionf().rotateZ(angle);
        matrices.method_22907(rotation);
        matrices.method_46416((float)(-center_x), (float)(-center_y), 0.0f);
        graphics.method_25302(WIDGETS_TEXTURE, pointer[0], pointer[1], pointer[2], pointer[3], pointer[4], pointer[5]);
        matrices.method_22909();
        graphics.method_25302(WIDGETS_TEXTURE, fore_gr[0], fore_gr[1], fore_gr[2], fore_gr[3], fore_gr[4], fore_gr[5]);
        if (Common.CONFIG.render_titles == ConfigEnums.render_titles.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, title[0], title[1], title[2], title[3], title[4], title[5]);
        }
        if (Common.CONFIG.render_values == ConfigEnums.render_values.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, value[0], value[1], value[2], value[3], value[4], value[5]);
            graphics.method_25303(this.client.field_1772, String.format("%3d", value_int), value[0] + 2, value[1] + 2, 0xFFFFFF);
        }
    }

    private void renderHorizon(class_332 graphics, int center_x, int center_y, float angle_roll, int[] horizon, int[] back_gr, int[] pointer, int[] title, int[] value, int value_int) {
        int i;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int[][] horizon_list = new int[][]{{1, 10, 20}, {1, 16, 17}, {1, 22, 14}, {1, 24, 13}, {1, 26, 12}, {1, 30, 10}, {1, 32, 9}, {2, 34, 8}, {1, 36, 7}, {1, 38, 6}, {3, 40, 5}, {3, 42, 4}, {5, 44, 3}};
        int horizon_x = 0;
        for (i = 0; i < horizon_list.length; ++i) {
            graphics.method_25302(WIDGETS_TEXTURE, horizon[0] + horizon_x, horizon[1] - 3 + horizon_list[i][2], horizon[2] + horizon_x, horizon[3] + horizon_list[i][2], horizon_list[i][0], horizon_list[i][1]);
            horizon_x += horizon_list[i][0];
        }
        for (i = horizon_list.length - 1; i >= 0; --i) {
            graphics.method_25302(WIDGETS_TEXTURE, horizon[0] + horizon_x, horizon[1] - 3 + horizon_list[i][2], horizon[2] + horizon_x, horizon[3] + horizon_list[i][2], horizon_list[i][0], horizon_list[i][1]);
            horizon_x += horizon_list[i][0];
        }
        graphics.method_25302(WIDGETS_TEXTURE, back_gr[0], back_gr[1], back_gr[2], back_gr[3], back_gr[4], back_gr[5]);
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)center_x, (float)center_y, 0.0f);
        Quaternionf rotation = new Quaternionf().rotateZ(angle_roll);
        matrices.method_22907(rotation);
        matrices.method_46416((float)(-center_x), (float)(-center_y), 0.0f);
        graphics.method_25302(WIDGETS_TEXTURE, pointer[0], pointer[1], pointer[2], pointer[3], pointer[4], pointer[5]);
        matrices.method_22909();
        if (Common.CONFIG.render_titles == ConfigEnums.render_titles.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, title[0], title[1], title[2], title[3], title[4], title[5]);
        }
        if (Common.CONFIG.render_values == ConfigEnums.render_values.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, value[0], value[1], value[2], value[3], value[4], value[5]);
            graphics.method_25303(this.client.field_1772, String.format("%3d", value_int), value[0] + 2, value[1] + 2, 0xFFFFFF);
        }
    }

    private void renderCompass(class_332 graphics, int center_x, int center_y, float angle, int[] back_gr, int[] pointer, int[] fore_gr, int[] title) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)center_x, (float)center_y, 0.0f);
        Quaternionf rotation = new Quaternionf().rotateZ(angle);
        matrices.method_22907(rotation);
        matrices.method_46416((float)(-center_x), (float)(-center_y), 0.0f);
        graphics.method_25302(WIDGETS_TEXTURE, back_gr[0], back_gr[1], back_gr[2], back_gr[3], back_gr[4], back_gr[5]);
        matrices.method_22909();
        graphics.method_25302(WIDGETS_TEXTURE, pointer[0], pointer[1], pointer[2], pointer[3], pointer[4], pointer[5]);
        graphics.method_25302(WIDGETS_TEXTURE, fore_gr[0], fore_gr[1], fore_gr[2], fore_gr[3], fore_gr[4], fore_gr[5]);
        graphics.method_25302(WIDGETS_TEXTURE, title[0], title[1], title[2], title[3], title[4], title[5]);
    }

    private void renderBar(class_332 graphics, int[] back_gr, int[] pointer, int[] title, int[] value, int value_int) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_25302(WIDGETS_TEXTURE, back_gr[0], back_gr[1], back_gr[2], back_gr[3], back_gr[4], back_gr[5]);
        graphics.method_25302(WIDGETS_TEXTURE, pointer[0], pointer[1], pointer[2], pointer[3], pointer[4], pointer[5]);
        if (Common.CONFIG.render_titles == ConfigEnums.render_titles.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, title[0], title[1], title[2], title[3], title[4], title[5]);
        }
        if (Common.CONFIG.render_values == ConfigEnums.render_values.Yes) {
            graphics.method_25302(WIDGETS_TEXTURE, value[0], value[1], value[2], value[3], value[4], value[5]);
            graphics.method_25303(this.client.field_1772, String.format("%3d", value_int), value[0] + 2, value[1] + 2, 0xFFFFFF);
        }
    }
}

