/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.earthcomputer.clientcommands.features.Relogger;
import net.earthcomputer.clientcommands.task.LongTask;

public class TaskManager {
    private static final List<LongTask> newTasks = new ArrayList<LongTask>();
    private static final Map<String, LongTask> tasks = new LinkedHashMap<String, LongTask>();
    private static long nextTaskId = 1L;

    public static void tick() {
        newTasks.forEach(LongTask::initialize);
        newTasks.clear();
        if (tasks.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, LongTask>> iteratingTasks = new ArrayList<Map.Entry<String, LongTask>>(tasks.entrySet());
        while (!iteratingTasks.isEmpty()) {
            Iterator<Map.Entry<String, LongTask>> itr = iteratingTasks.iterator();
            while (itr.hasNext()) {
                Map.Entry<String, LongTask> taskEntry = itr.next();
                LongTask task = taskEntry.getValue();
                if (task.isCompleted()) {
                    task.onCompleted();
                    tasks.remove(taskEntry.getKey());
                    itr.remove();
                    continue;
                }
                task.body();
                if (!task.isCompleted()) {
                    task.increment();
                }
                if (!task.isDelayScheduled()) continue;
                task.unscheduleDelay();
                itr.remove();
            }
        }
    }

    public static void onWorldUnload(boolean isDisconnect) {
        ArrayList<Map.Entry<String, LongTask>> oldTasks = new ArrayList<Map.Entry<String, LongTask>>();
        Iterator<Map.Entry<String, LongTask>> itr = tasks.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, LongTask> entry = itr.next();
            if (!entry.getValue().stopOnWorldUnload(isDisconnect)) continue;
            itr.remove();
            oldTasks.add(entry);
        }
        ArrayList<LongTask> oldNewTasks = new ArrayList<LongTask>();
        Iterator<LongTask> itr2 = newTasks.iterator();
        while (itr2.hasNext()) {
            LongTask newTask = itr2.next();
            if (!newTask.stopOnWorldUnload(isDisconnect)) continue;
            itr2.remove();
            oldNewTasks.add(newTask);
        }
        if (isDisconnect && Relogger.isRelogging) {
            Relogger.relogSuccessTasks.add(() -> {
                for (Map.Entry oldTask : oldTasks) {
                    tasks.put((String)oldTask.getKey(), (LongTask)oldTask.getValue());
                }
                newTasks.addAll(oldNewTasks);
            });
        }
    }

    public static String addTask(String name, LongTask task) {
        String actualName = nextTaskId++ + "." + name;
        tasks.put(actualName, task);
        newTasks.add(task);
        return actualName;
    }

    public static int getTaskCount() {
        return tasks.size();
    }

    public static Iterable<String> getTaskNames() {
        return tasks.keySet();
    }

    public static void removeTask(String name) {
        LongTask task = tasks.get(name);
        if (task != null) {
            task._break();
        }
    }
}

