/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import java.util.ArrayList;
import java.util.List;
import net.earthcomputer.clientcommands.task.LongTask;

public class LongTaskList
extends LongTask {
    private List<LongTask> children = new ArrayList<LongTask>();

    public void addTask(LongTask task) {
        this.children.add(task);
    }

    @Override
    public void initialize() {
        if (!this.children.isEmpty()) {
            this.children.get(0).initialize();
        }
    }

    @Override
    public boolean condition() {
        return !this.children.isEmpty();
    }

    @Override
    public void increment() {
    }

    @Override
    public void body() {
        LongTask child = this.children.get(0);
        if (child.isCompleted()) {
            child.onCompleted();
            if (child.isDelayScheduled()) {
                this.scheduleDelay();
            }
            this.children.remove(0);
            if (!this.children.isEmpty()) {
                this.children.get(0).initialize();
            }
        } else {
            child.body();
            if (!child.isCompleted()) {
                child.increment();
            }
            if (child.isDelayScheduled()) {
                child.unscheduleDelay();
                this.scheduleDelay();
            }
        }
    }
}

