/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.mixin;

import dev.xpple.betterconfig.api.BetterConfigAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.ClientCommands;
import net.earthcomputer.clientcommands.GuiBlocker;
import net.earthcomputer.clientcommands.ServerBrandManager;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.features.Relogger;
import net.earthcomputer.clientcommands.features.RenderSettings;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.minecraft.class_310;
import net.minecraft.class_3928;
import net.minecraft.class_412;
import net.minecraft.class_424;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MixinMinecraftClient {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        RenderQueue.tick();
        TaskManager.tick();
        GuiBlocker.tick();
    }

    @Inject(method={"setWorld"}, at={@At(value="HEAD")})
    public void onSetWorld(class_638 world, CallbackInfo ci) {
        PlayerRandCracker.onRecreatePlayer();
        TaskManager.onWorldUnload(world == null);
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void onOpenScreen(class_437 screen, CallbackInfo ci) {
        if (!(screen == null || screen instanceof class_424 || screen instanceof class_3928 || screen instanceof class_435 || screen instanceof class_412 || screen instanceof class_433 || screen instanceof class_434 || screen instanceof class_442 || screen instanceof class_500)) {
            Relogger.cantHaveRelogSuccess();
        }
        if (!GuiBlocker.onOpenGui(screen)) {
            ci.cancel();
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="RETURN")})
    public void onDisconnect(class_437 screen, CallbackInfo ci) {
        ServerBrandManager.onDisconnect();
        if (!Relogger.isRelogging) {
            BetterConfigAPI.getInstance().getModConfig("clientcommands").resetTemporaryConfigs();
        }
        RenderSettings.clearEntityRenderSelectors();
    }

    @Inject(method={"getWindowTitle"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyWindowTitle(CallbackInfoReturnable<String> ci) {
        if (ClientCommands.SCRAMBLE_WINDOW_TITLE) {
            List chars = ((String)ci.getReturnValue()).chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(chars);
            ci.setReturnValue((Object)chars.stream().map(String::valueOf).collect(Collectors.joining()));
        }
    }
}

