/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.mixin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.earthcomputer.clientcommands.features.DebugRandom;
import net.earthcomputer.clientcommands.features.EntityGlowingTicket;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.interfaces.IEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements IEntity {
    @Shadow
    @Final
    @Mutable
    protected class_5819 field_5974;
    @Unique
    private final List<EntityGlowingTicket> glowingTickets = new ArrayList<EntityGlowingTicket>(0);

    @Override
    public void addGlowingTicket(int ticks, int color) {
        this.glowingTickets.add(new EntityGlowingTicket(ticks, color));
    }

    @Override
    public boolean hasGlowingTicket() {
        return !this.glowingTickets.isEmpty();
    }

    @Unique
    private int getGlowingTicketColor() {
        return this.glowingTickets.isEmpty() ? 0xFFFFFF : this.glowingTickets.get(this.glowingTickets.size() - 1).getColor();
    }

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;random:Lnet/minecraft/util/math/random/Random;", opcode=181, shift=At.Shift.AFTER)})
    private void onInitRandom(class_1299<?> type, class_1937 world, CallbackInfo ci) {
        if (type == DebugRandom.DEBUG_ENTITY_TYPE && !world.field_9236) {
            this.field_5974 = new DebugRandom((class_1297)this);
        }
    }

    @Inject(method={"isGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideIsGlowing(CallbackInfoReturnable<Boolean> ci) {
        if (!this.glowingTickets.isEmpty()) {
            ci.setReturnValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void tickGlowingTickets() {
        if (((class_1297)this).method_37908().field_9236) {
            Iterator<EntityGlowingTicket> itr = this.glowingTickets.iterator();
            while (itr.hasNext()) {
                EntityGlowingTicket glowingTicket = itr.next();
                if (glowingTicket.tick()) continue;
                itr.remove();
            }
        }
    }

    @Override
    public void tickDebugRandom() {
        class_5819 class_58192 = this.field_5974;
        if (class_58192 instanceof DebugRandom) {
            DebugRandom debugRandom = (DebugRandom)class_58192;
            debugRandom.tick();
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")})
    private void onRemoved(class_1297.class_5529 reason, CallbackInfo ci) {
        class_5819 class_58192 = this.field_5974;
        if (class_58192 instanceof DebugRandom) {
            DebugRandom debugRandom = (DebugRandom)class_58192;
            if (!(this instanceof class_1657) || reason != class_1297.class_5529.field_27002) {
                debugRandom.writeToFile();
            }
        }
    }

    @Inject(method={"onSwimmingStart"}, at={@At(value="HEAD")})
    public void onOnSwimmingStart(CallbackInfo ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.onSwimmingStart();
        }
    }

    @Inject(method={"playAmethystChimeSound"}, at={@At(value="HEAD")})
    private void onPlayAmethystChimeSound(CallbackInfo ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.onAmethystChime();
        }
    }

    @Inject(method={"spawnSprintingParticles"}, at={@At(value="HEAD")})
    public void onSprinting(CallbackInfo ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.onSprinting();
        }
    }

    @Inject(method={"getTeamColorValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectGetTeamColorValue(CallbackInfoReturnable<Integer> ci) {
        if (this.hasGlowingTicket()) {
            ci.setReturnValue((Object)this.getGlowingTicketColor());
        }
    }

    private boolean isThePlayer() {
        return this instanceof class_746;
    }

    @Override
    @Invoker
    public abstract int callGetPermissionLevel();
}

