/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalLong;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.features.ChorusManipulation;
import net.earthcomputer.clientcommands.interfaces.ICreativeSlot;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class PlayerRandCracker {
    public static final long MULTIPLIER = 25214903917L;
    public static final long ADDEND = 11L;
    public static final long MASK = 0xFFFFFFFFFFFFL;
    private static long seed;
    public static boolean isPredictingBlockBreaking;
    @Nullable
    private static Runnable postBlockBreakPredictAction;
    private static int expectedThrows;
    private static final Field RANDOM_SEED;

    private static int next(int bits) {
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(seed >>> 48 - bits);
    }

    public static int nextInt() {
        return PlayerRandCracker.next(32);
    }

    public static int nextInt(int bound) {
        int val;
        int bits;
        if ((bound & -bound) == bound) {
            return (int)((long)bound * (long)PlayerRandCracker.next(31) >> 31);
        }
        while ((bits = PlayerRandCracker.next(31)) - (val = bits % bound) + (bound - 1) < 0) {
        }
        return val;
    }

    public static float nextFloat() {
        return (float)PlayerRandCracker.next(24) / 1.6777216E7f;
    }

    public static void setSeed(long seed) {
        PlayerRandCracker.seed = seed;
    }

    public static long getSeed() {
        return seed;
    }

    public static void postSendBlockBreakingPredictionPacket() {
        if (postBlockBreakPredictAction != null) {
            postBlockBreakPredictAction.run();
            postBlockBreakPredictAction = null;
        }
    }

    public static void resetCracker() {
        Configs.playerCrackState = CrackState.UNCRACKED;
    }

    public static void resetCracker(String reason) {
        if (Configs.playerCrackState != CrackState.UNCRACKED) {
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"playerManip.reset", (Object[])new Object[]{class_2561.method_43471((String)("playerManip.reset." + reason))}).method_27692(class_124.field_1061));
        }
        PlayerRandCracker.resetCracker();
    }

    public static void onDropItem() {
        if (expectedThrows > 0 || PlayerRandCracker.canMaintainPlayerRNG()) {
            for (int i = 0; i < 4; ++i) {
                PlayerRandCracker.nextInt();
            }
        } else {
            PlayerRandCracker.resetCracker("dropItem");
        }
        if (expectedThrows > 0) {
            --expectedThrows;
        }
    }

    public static void onEntityCramming() {
        PlayerRandCracker.resetCracker("entityCramming");
    }

    public static void onDrink() {
    }

    public static void onEat(class_1799 stack, class_243 pos, int particleCount, int itemUseTimeLeft) {
        if (PlayerRandCracker.canMaintainPlayerRNG()) {
            int i;
            if (itemUseTimeLeft < 0 && particleCount != 16) {
                return;
            }
            for (i = 0; i < particleCount * 3 + 3; ++i) {
                PlayerRandCracker.nextInt();
            }
            if (Configs.getChorusManipulation() && stack.method_7909() == class_1802.field_8233) {
                ChorusManipulation.onEat(pos, particleCount, itemUseTimeLeft);
                if (particleCount == 16) {
                    for (i = 0; i < 5; ++i) {
                        PlayerRandCracker.nextInt();
                    }
                }
            }
        } else {
            PlayerRandCracker.resetCracker("food");
        }
    }

    public static void onUnderwater() {
        PlayerRandCracker.resetCracker("swim");
    }

    public static void onSwimmingStart() {
        PlayerRandCracker.resetCracker("enterWater");
    }

    public static void onAmethystChime() {
        PlayerRandCracker.resetCracker("amethystChime");
    }

    public static void onDamage() {
        PlayerRandCracker.resetCracker("playerHurt");
    }

    public static void onSprinting() {
        PlayerRandCracker.resetCracker("sprint");
    }

    public static void onEquipmentBreak() {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() <= 404) {
            PlayerRandCracker.resetCracker("itemBreak");
        }
    }

    public static void onPotionParticles() {
        PlayerRandCracker.resetCracker("potion");
    }

    public static void onGiveCommand() {
        PlayerRandCracker.resetCracker("give");
    }

    public static void onAnvilUse() {
        if (PlayerRandCracker.canMaintainPlayerRNG()) {
            PlayerRandCracker.nextInt();
        } else {
            PlayerRandCracker.resetCracker("anvil");
        }
    }

    public static void onMending() {
        PlayerRandCracker.resetCracker("mending");
    }

    public static void onXpOrb() {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() >= 755) {
            PlayerRandCracker.resetCracker("xp");
        }
    }

    public static void onFrostWalker() {
        PlayerRandCracker.resetCracker("frostWalker");
    }

    public static void onSoulSpeed() {
        PlayerRandCracker.resetCracker("soulSpeed");
    }

    public static void onBaneOfArthropods() {
        if (PlayerRandCracker.canMaintainPlayerRNG()) {
            PlayerRandCracker.nextInt();
        } else {
            PlayerRandCracker.resetCracker("baneOfArthropods");
        }
    }

    public static void onRecreatePlayer() {
        PlayerRandCracker.resetCracker("recreated");
    }

    public static void onUnbreaking(class_1799 stack, int amount, int unbreakingLevel) {
        if (PlayerRandCracker.canMaintainPlayerRNG()) {
            for (int i = 0; i < amount; ++i) {
                if (!(stack.method_7909() instanceof class_1738) || (double)PlayerRandCracker.nextFloat() >= 0.6) {
                    PlayerRandCracker.nextInt(unbreakingLevel + 1);
                    continue;
                }
                PlayerRandCracker.resetCracker("unbreaking");
            }
        }
    }

    public static void onUnbreakingUncertain(class_1799 stack, int minAmount, int maxAmount, int unbreakingLevel) {
        PlayerRandCracker.resetCracker("unbreaking");
    }

    public static void onItemDamage(int amount, class_1309 holder, class_1799 stack) {
        if (holder instanceof class_746 && !((class_746)holder).method_31549().field_7477 && stack.method_7963() && amount > 0) {
            int unbreakingLevel = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack);
            if (unbreakingLevel > 0) {
                PlayerRandCracker.onUnbreaking(stack, amount, unbreakingLevel);
            }
            if (Configs.toolBreakWarning && stack.method_7919() + amount >= stack.method_7936() - 30) {
                if (stack.method_7919() + amount >= stack.method_7936() - 15) {
                    class_310.method_1551().field_1724.method_5783(class_3417.field_14627, 10.0f, 0.1f);
                }
                class_5250 durability = class_2561.method_43470((String)String.valueOf(stack.method_7936() - stack.method_7919() - 1)).method_27692(class_124.field_1061);
                class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"playerManip.toolBreakWarning", (Object[])new Object[]{durability}).method_27692(class_124.field_1065), false);
            }
            if (Configs.infiniteTools && Configs.playerCrackState.knowsSeed()) {
                Runnable action = () -> PlayerRandCracker.throwItemsUntil(rand -> {
                    for (int i = 0; i < amount; ++i) {
                        if (stack.method_7909() instanceof class_1738 && (double)rand.nextFloat() < 0.6) {
                            return false;
                        }
                        if (rand.nextInt(unbreakingLevel + 1) != 0) continue;
                        return false;
                    }
                    return true;
                }, 64);
                if (isPredictingBlockBreaking) {
                    postBlockBreakPredictAction = action;
                } else {
                    action.run();
                }
            }
        }
    }

    public static void onItemDamageUncertain(int minAmount, int maxAmount, class_1309 holder, class_1799 stack) {
        int unbreakingLevel;
        if (holder instanceof class_746 && !((class_746)holder).method_31549().field_7477 && stack.method_7963() && maxAmount > 0 && (unbreakingLevel = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack)) > 0) {
            PlayerRandCracker.onUnbreakingUncertain(stack, minAmount, maxAmount, unbreakingLevel);
        }
    }

    public static void onUnexpectedItemEnchant() {
        PlayerRandCracker.resetCracker("enchanted");
    }

    private static boolean canMaintainPlayerRNG() {
        if (Configs.playerRNGMaintenance && Configs.playerCrackState.knowsSeed()) {
            Configs.playerCrackState = CrackState.CRACKED;
            return true;
        }
        return false;
    }

    public static ThrowItemsResult throwItemsUntil(Predicate<Random> condition, int max) {
        int i;
        int itemsNeeded;
        if (!Configs.playerCrackState.knowsSeed()) {
            return new ThrowItemsResult(ThrowItemsResult.Type.UNKNOWN_SEED, new Object[0]);
        }
        Configs.playerCrackState = CrackState.CRACKED;
        long seed = PlayerRandCracker.seed;
        Random rand = new Random(seed ^ 0x5DEECE66DL);
        for (itemsNeeded = 0; itemsNeeded <= max && !condition.test(rand); ++itemsNeeded) {
            for (i = 0; i < 4; ++i) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            }
            rand.setSeed(seed ^ 0x5DEECE66DL);
        }
        if (itemsNeeded > max) {
            return new ThrowItemsResult(ThrowItemsResult.Type.NOT_POSSIBLE, itemsNeeded);
        }
        for (i = 0; i < itemsNeeded; ++i) {
            if (PlayerRandCracker.throwItem()) continue;
            return new ThrowItemsResult(ThrowItemsResult.Type.NOT_ENOUGH_ITEMS, i, itemsNeeded);
        }
        return new ThrowItemsResult(ThrowItemsResult.Type.SUCCESS, new Object[0]);
    }

    public static boolean throwItem() {
        class_746 player = class_310.method_1551().field_1724;
        class_1735 matchingSlot = PlayerRandCracker.getBestItemThrowSlot((List<class_1735>)player.field_7512.field_7761);
        if (matchingSlot == null) {
            return false;
        }
        ++expectedThrows;
        class_310.method_1551().field_1761.method_2906(player.field_7512.field_7763, matchingSlot.field_7874, 0, class_1713.field_7795, (class_1657)player);
        return true;
    }

    public static class_1735 getBestItemThrowSlot(List<class_1735> slots) {
        slots = slots.stream().filter(slot -> {
            if (!slot.method_7681()) {
                return false;
            }
            if (slot instanceof ICreativeSlot) {
                return false;
            }
            if (class_1890.method_8225((class_1887)class_1893.field_9113, (class_1799)slot.method_7677()) != 0) {
                return false;
            }
            return slot.method_7677().method_7909() != class_1802.field_8233;
        }).collect(Collectors.toList());
        HashMap<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();
        for (class_1735 class_17352 : slots) {
            itemCounts.put(class_17352.method_7677().method_7909(), itemCounts.getOrDefault(class_17352.method_7677().method_7909(), 0) + class_17352.method_7677().method_7947());
        }
        if (itemCounts.isEmpty()) {
            return null;
        }
        class_1792 preferredItem = itemCounts.keySet().stream().max(Comparator.comparingInt(class_1792::method_7882).thenComparing(itemCounts::get)).get();
        return slots.stream().filter(slot -> slot.method_7677().method_7909() == preferredItem).findFirst().get();
    }

    public static OptionalLong getSeed(Random rand) {
        if (RANDOM_SEED == null) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(((AtomicLong)RANDOM_SEED.get(rand)).get());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Field randomSeedField;
        isPredictingBlockBreaking = false;
        postBlockBreakPredictAction = null;
        expectedThrows = 0;
        try {
            randomSeedField = Random.class.getDeclaredField("seed");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        try {
            randomSeedField.setAccessible(true);
        }
        catch (Exception e) {
            randomSeedField = null;
        }
        RANDOM_SEED = randomSeedField;
    }

    public static enum CrackState implements class_3542
    {
        UNCRACKED("uncracked"),
        CRACKED("cracked", true),
        ENCH_CRACKING_1("ench_cracking_1"),
        HALF_CRACKED("half_cracked"),
        ENCH_CRACKING_2("ench_cracking_2"),
        CRACKING("cracking"),
        EATING("eating"),
        MANIPULATING_ENCHANTMENTS("manipulating_enchantments"),
        WAITING_DUMMY_ENCHANT("waiting_dummy_enchant", true);

        private final String name;
        private final boolean knowsSeed;

        private CrackState(String name) {
            this(name, false);
        }

        private CrackState(String name, boolean knowsSeed) {
            this.name = name;
            this.knowsSeed = knowsSeed;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean knowsSeed() {
            return this.knowsSeed;
        }
    }

    public static class ThrowItemsResult {
        private final Type type;
        private final class_5250 message;

        public ThrowItemsResult(Type type, Object ... args) {
            this.type = type;
            this.message = class_2561.method_43469((String)type.getTranslationKey(), (Object[])args);
        }

        public Type getType() {
            return this.type;
        }

        public class_5250 getMessage() {
            return this.message;
        }

        public static enum Type {
            NOT_ENOUGH_ITEMS(false, "playerManip.notEnoughItems"),
            NOT_POSSIBLE(false, "playerManip.throwError"),
            UNKNOWN_SEED(false, "playerManip.uncracked"),
            SUCCESS(true, null);

            private final boolean success;
            private final String translationKey;

            private Type(boolean success, String translationKey) {
                this.success = success;
                this.translationKey = translationKey;
            }

            public boolean isSuccess() {
                return this.success;
            }

            public String getTranslationKey() {
                return this.translationKey;
            }
        }
    }
}

