/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.LongTaskList;
import net.earthcomputer.clientcommands.task.OneTickTask;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class EnchantmentCracker {
    public static final Logger LOGGER = LogUtils.getLogger();
    static Set<Integer> possibleXPSeeds = new HashSet<Integer>(0x100000);
    private static int firstXpSeed;
    public static class_2338 enchantingTablePos;
    private static boolean doneEnchantment;

    public static void drawEnchantmentGUIOverlay(class_332 context) {
        CrackState crackState = Configs.enchCrackState;
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(class_1074.method_4662((String)"enchCrack.state", (Object[])new Object[]{class_1074.method_4662((String)("enchCrack.state." + crackState.method_15434()), (Object[])new Object[0])}));
        lines.add(class_1074.method_4662((String)"playerManip.state", (Object[])new Object[]{class_1074.method_4662((String)("playerManip.state." + Configs.playerCrackState.method_15434()), (Object[])new Object[0])}));
        lines.add("");
        if (crackState == CrackState.CRACKED) {
            lines.add(class_1074.method_4662((String)"enchCrack.xpSeed.one", (Object[])new Object[]{possibleXPSeeds.iterator().next()}));
        } else if (crackState == CrackState.CRACKING) {
            lines.add(class_1074.method_4662((String)"enchCrack.xpSeed.many", (Object[])new Object[]{possibleXPSeeds.size()}));
        }
        lines.add("");
        if (enchantingTablePos != null) {
            lines.add(class_1074.method_4662((String)"enchCrack.bookshelfCount", (Object[])new Object[]{EnchantmentCracker.getEnchantPower((class_1937)class_310.method_1551().field_1687, enchantingTablePos)}));
            lines.add("");
        }
        if (crackState == CrackState.CRACKED) {
            lines.add(class_1074.method_4662((String)"enchCrack.enchantments", (Object[])new Object[0]));
        } else {
            lines.add(class_1074.method_4662((String)"enchCrack.clues", (Object[])new Object[0]));
        }
        for (int slot = 0; slot < 3; ++slot) {
            lines.add(class_1074.method_4662((String)"enchCrack.slot", (Object[])new Object[]{slot + 1}));
            List<class_1889> enchs = EnchantmentCracker.getEnchantmentsInTable(slot);
            if (enchs == null) continue;
            for (class_1889 class_18892 : enchs) {
                lines.add("   " + class_18892.field_9093.method_8179(class_18892.field_9094).getString());
            }
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int y = 0;
        for (String string : lines) {
            context.method_51433(fontRenderer, string, 0, y, 0xFFFFFF, false);
            Objects.requireNonNull(fontRenderer);
            y += 9;
        }
    }

    public static void resetCracker() {
        Configs.enchCrackState = CrackState.UNCRACKED;
        possibleXPSeeds.clear();
    }

    private static void prepareForNextEnchantmentSeedCrack(int serverReportedXPSeed) {
        serverReportedXPSeed &= 0xFFF0;
        for (int highBits = 0; highBits < 65536; ++highBits) {
            for (int low4Bits = 0; low4Bits < 16; ++low4Bits) {
                possibleXPSeeds.add(highBits << 16 | serverReportedXPSeed | low4Bits);
            }
        }
    }

    public static void addEnchantmentSeedInfo(class_1937 world, class_1718 container) {
        CrackState crackState = Configs.enchCrackState;
        if (crackState == CrackState.CRACKED) {
            return;
        }
        class_1799 itemToEnchant = container.method_7611(0).method_7677();
        if (itemToEnchant.method_7960() || !itemToEnchant.method_7923()) {
            return;
        }
        if (enchantingTablePos == null) {
            return;
        }
        class_2338 tablePos = enchantingTablePos;
        if (crackState == CrackState.UNCRACKED) {
            Configs.enchCrackState = CrackState.CRACKING;
            EnchantmentCracker.prepareForNextEnchantmentSeedCrack(container.method_17413());
        }
        int power = EnchantmentCracker.getEnchantPower(world, tablePos);
        class_5819 rand = class_5819.method_43047();
        int[] actualEnchantLevels = container.field_7808;
        int[] actualEnchantmentClues = container.field_7812;
        int[] actualLevelClues = container.field_7810;
        Iterator<Integer> xpSeedItr = possibleXPSeeds.iterator();
        block0: while (xpSeedItr.hasNext()) {
            int slot;
            int xpSeed = xpSeedItr.next();
            rand.method_43052((long)xpSeed);
            for (slot = 0; slot < 3; ++slot) {
                int level = class_1890.method_8227((class_5819)rand, (int)slot, (int)power, (class_1799)itemToEnchant);
                if (level < slot + 1) {
                    level = 0;
                }
                if (level == actualEnchantLevels[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
            for (slot = 0; slot < 3; ++slot) {
                if (actualEnchantLevels[slot] <= 0) continue;
                List<class_1889> enchantments = EnchantmentCracker.getEnchantmentList(rand, xpSeed, itemToEnchant, slot, actualEnchantLevels[slot]);
                if (enchantments == null || enchantments.isEmpty()) {
                    if (actualEnchantmentClues[slot] == -1 && actualLevelClues[slot] == -1) continue;
                    xpSeedItr.remove();
                    continue block0;
                }
                class_1889 clue = enchantments.get(rand.method_43048(enchantments.size()));
                if (class_7923.field_41176.method_10206((Object)clue.field_9093) == actualEnchantmentClues[slot] && clue.field_9094 == actualLevelClues[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
        }
        if (possibleXPSeeds.size() == 0) {
            Configs.enchCrackState = CrackState.UNCRACKED;
            LOGGER.warn("Invalid enchantment seed information. Has the server got unknown mods, is there a desync, or is the client just bugged?");
        } else if (possibleXPSeeds.size() == 1) {
            Configs.enchCrackState = CrackState.CRACKED;
            EnchantmentCracker.addPlayerRNGInfo(possibleXPSeeds.iterator().next());
        }
    }

    private static void addPlayerRNGInfo(int enchantmentSeed) {
        if (Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_1) {
            firstXpSeed = enchantmentSeed;
            Configs.playerCrackState = PlayerRandCracker.CrackState.HALF_CRACKED;
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_2) {
            long max_1 = Integer.toUnsignedLong(firstXpSeed) + 1L;
            long min_1 = Integer.toUnsignedLong(firstXpSeed);
            long max_2 = Integer.toUnsignedLong(enchantmentSeed) + 1L;
            long a = 24667315L * max_1 + 18218081L * max_2 >> 32;
            long b = -4824621L * min_1 + 7847617L * max_2 >> 32;
            boolean valid = true;
            long seed = 7847617L * a - 18218081L * b & 0xFFFFFFFFFFFFL;
            if ((int)(seed >>> 16) != firstXpSeed) {
                valid = false;
            }
            if ((int)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16) != enchantmentSeed) {
                valid = false;
            }
            if (valid) {
                PlayerRandCracker.setSeed(seed);
                Configs.playerCrackState = PlayerRandCracker.CrackState.CRACKED;
            } else {
                Configs.playerCrackState = PlayerRandCracker.CrackState.UNCRACKED;
                LOGGER.warn("Invalid player RNG information. Has the server got unknown mods, is there a desync, has an operator used /give, or is the client just bugged?");
            }
        }
    }

    public static void onEnchantedItem() {
        if (Configs.playerCrackState == PlayerRandCracker.CrackState.UNCRACKED && !EnchantmentCracker.isEnchantingPredictionEnabled()) {
            return;
        }
        if (Configs.playerCrackState.knowsSeed()) {
            possibleXPSeeds.clear();
            possibleXPSeeds.add(PlayerRandCracker.nextInt());
            Configs.playerCrackState = PlayerRandCracker.CrackState.CRACKED;
            Configs.enchCrackState = CrackState.CRACKED;
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.HALF_CRACKED) {
            possibleXPSeeds.clear();
            Configs.playerCrackState = PlayerRandCracker.CrackState.ENCH_CRACKING_2;
            Configs.enchCrackState = CrackState.UNCRACKED;
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.UNCRACKED || Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_1 || Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_2) {
            possibleXPSeeds.clear();
            Configs.playerCrackState = PlayerRandCracker.CrackState.ENCH_CRACKING_1;
            Configs.enchCrackState = CrackState.UNCRACKED;
        } else {
            PlayerRandCracker.onUnexpectedItemEnchant();
            Configs.enchCrackState = CrackState.UNCRACKED;
        }
        doneEnchantment = true;
    }

    public static ManipulateResult manipulateEnchantments(class_1792 item, Predicate<List<class_1889>> enchantmentsPredicate, boolean simulate) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        class_1799 stack = new class_1799((class_1935)item);
        long seed = PlayerRandCracker.getSeed();
        int timesNeeded = -2;
        int bookshelvesNeeded = 0;
        int slot = 0;
        List<class_1889> enchantments = null;
        int[] enchantLevels = new int[3];
        block0: for (int i = Configs.enchCrackState == CrackState.CRACKED ? -1 : 0; i < (Configs.playerCrackState.knowsSeed() ? Configs.getMaxEnchantItemThrows() : 0); ++i) {
            int xpSeed = i == -1 ? possibleXPSeeds.iterator().next() : (int)((seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16);
            class_5819 rand = class_5819.method_43047();
            for (bookshelvesNeeded = 0; bookshelvesNeeded <= 15; ++bookshelvesNeeded) {
                rand.method_43052((long)xpSeed);
                for (slot = 0; slot < 3; ++slot) {
                    int level = class_1890.method_8227((class_5819)rand, (int)slot, (int)bookshelvesNeeded, (class_1799)stack);
                    if (level < slot + 1) {
                        level = 0;
                    }
                    enchantLevels[slot] = level;
                }
                for (slot = 0; slot < 3; ++slot) {
                    enchantments = EnchantmentCracker.getEnchantmentList(rand, xpSeed, stack, slot, enchantLevels[slot]);
                    if (!enchantmentsPredicate.test(enchantments)) continue;
                    timesNeeded = i;
                    break block0;
                }
            }
            if (i == -1) continue;
            for (int j = 0; j < 4; ++j) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            }
        }
        if (timesNeeded == -2) {
            return null;
        }
        if (simulate) {
            return new ManipulateResult(timesNeeded, bookshelvesNeeded, slot, enchantments);
        }
        final LongTaskList taskList = new LongTaskList();
        if (timesNeeded != -1) {
            if (timesNeeded != 0) {
                player.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), 90.0f);
                player.field_3944.method_2883((class_2596)new class_2828.class_2831(player.method_36454(), 90.0f, player.method_24828()));
                Configs.playerCrackState = PlayerRandCracker.CrackState.MANIPULATING_ENCHANTMENTS;
            }
            for (int i = 0; i < timesNeeded; ++i) {
                taskList.addTask(new SimpleTask(){

                    @Override
                    public boolean condition() {
                        if (Configs.playerCrackState != PlayerRandCracker.CrackState.MANIPULATING_ENCHANTMENTS) {
                            taskList._break();
                            return false;
                        }
                        class_1735 slot = PlayerRandCracker.getBestItemThrowSlot((List<class_1735>)class_310.method_1551().field_1724.field_7512.field_7761);
                        return slot == null;
                    }

                    @Override
                    protected void onTick() {
                    }

                    @Override
                    public void onCompleted() {
                        PlayerRandCracker.throwItem();
                        this.scheduleDelay();
                    }
                });
            }
            taskList.addTask(new LongTask(){

                @Override
                public void initialize() {
                    Configs.playerCrackState = PlayerRandCracker.CrackState.WAITING_DUMMY_ENCHANT;
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"enchCrack.insn.dummy"));
                    doneEnchantment = false;
                }

                @Override
                public boolean condition() {
                    return Configs.playerCrackState == PlayerRandCracker.CrackState.WAITING_DUMMY_ENCHANT;
                }

                @Override
                public void increment() {
                }

                @Override
                public void body() {
                    this.scheduleDelay();
                }
            });
        }
        final int bookshelvesNeeded_f = bookshelvesNeeded;
        final int slot_f = slot;
        doneEnchantment = true;
        taskList.addTask(new OneTickTask(){

            @Override
            public void run() {
                if (Configs.enchCrackState == CrackState.CRACKED && doneEnchantment) {
                    class_338 chatHud = class_310.method_1551().field_1705.method_1743();
                    chatHud.method_1812((class_2561)class_2561.method_43471((String)"enchCrack.insn.ready").method_27692(class_124.field_1067));
                    chatHud.method_1812((class_2561)class_2561.method_43469((String)"enchCrack.insn.bookshelves", (Object[])new Object[]{bookshelvesNeeded_f}));
                    chatHud.method_1812((class_2561)class_2561.method_43469((String)"enchCrack.insn.slot", (Object[])new Object[]{slot_f + 1}));
                }
            }
        });
        TaskManager.addTask("enchantmentCracker", taskList);
        return new ManipulateResult(timesNeeded, bookshelvesNeeded, slot, enchantments);
    }

    public static boolean isEnchantingPredictionEnabled() {
        return Configs.getEnchantingPrediction();
    }

    private static int getEnchantPower(class_1937 world, class_2338 tablePos) {
        int power = 0;
        int protocolVersion = MultiVersionCompat.INSTANCE.getProtocolVersion();
        for (class_2338 bookshelfOffset : class_2331.field_36535) {
            class_2338 obstructionPos;
            if (protocolVersion <= 757) {
                obstructionPos = tablePos.method_10069(class_3532.method_15340((int)bookshelfOffset.method_10263(), (int)-1, (int)1), 0, class_3532.method_15340((int)bookshelfOffset.method_10260(), (int)-1, (int)1));
                if (!world.method_8320(tablePos.method_10081((class_2382)bookshelfOffset)).method_27852(class_2246.field_10504) || !world.method_8320(obstructionPos).method_26215()) continue;
                ++power;
                continue;
            }
            if (protocolVersion < 763) {
                obstructionPos = tablePos.method_10069(bookshelfOffset.method_10263() / 2, bookshelfOffset.method_10264(), bookshelfOffset.method_10260() / 2);
                if (!world.method_8320(tablePos.method_10081((class_2382)bookshelfOffset)).method_27852(class_2246.field_10504) || !world.method_8320(obstructionPos).method_26215()) continue;
                ++power;
                continue;
            }
            if (!class_2331.method_40445((class_1937)world, (class_2338)tablePos, (class_2338)bookshelfOffset)) continue;
            ++power;
        }
        return power;
    }

    private static List<class_1889> getEnchantmentList(class_5819 rand, int xpSeed, class_1799 stack, int enchantSlot, int level) {
        rand.method_43052((long)(xpSeed + enchantSlot));
        List list = class_1890.method_8230((class_5819)rand, (class_1799)stack, (int)level, (boolean)false);
        if (stack.method_7909() == class_1802.field_8529 && list.size() > 1) {
            list.remove(rand.method_43048(list.size()));
        }
        return list;
    }

    public static List<class_1889> getEnchantmentsInTable(int slot) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        CrackState crackState = Configs.enchCrackState;
        class_1718 enchContainer = (class_1718)player.field_7512;
        if (crackState != CrackState.CRACKED) {
            if (enchContainer.field_7812[slot] == -1) {
                return null;
            }
            class_1887 enchantment = class_1887.method_8191((int)enchContainer.field_7812[slot]);
            if (enchantment == null) {
                return null;
            }
            return Collections.singletonList(new class_1889(enchantment, enchContainer.field_7810[slot]));
        }
        class_5819 rand = class_5819.method_43047();
        int xpSeed = possibleXPSeeds.iterator().next();
        class_1799 enchantingStack = enchContainer.method_7611(0).method_7677();
        int enchantLevels = enchContainer.field_7808[slot];
        return EnchantmentCracker.getEnchantmentList(rand, xpSeed, enchantingStack, slot, enchantLevels);
    }

    static {
        enchantingTablePos = null;
        doneEnchantment = false;
    }

    public static enum CrackState implements class_3542
    {
        UNCRACKED("uncracked"),
        CRACKED("cracked"),
        CRACKING("cracking");

        private final String name;

        private CrackState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public record ManipulateResult(int itemThrows, int bookshelves, int slot, List<class_1889> enchantments) {
    }
}

