/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.earthcomputer.clientcommands.features.DebugRandom;
import net.earthcomputer.clientcommands.features.RandomCall;
import org.jetbrains.annotations.Nullable;

class DebugRandomSourcePanel
extends JPanel {
    private final List<List<RandomCall>> randomCalls;
    @Nullable
    private List<RandomCall> selectedTick = null;
    private int selectedStackTrace = 0;
    private final IntSet usedStackTraces = new IntOpenHashSet();
    private final JList<List<RandomCall>> randomCallsList;
    private final JList<RandomCall> callsInTickList;
    private final JList<String> allStackTraceList;

    DebugRandomSourcePanel(List<List<RandomCall>> randomCalls) {
        this.randomCalls = randomCalls;
        for (List<RandomCall> randomCallsThisTick : randomCalls) {
            for (RandomCall randomCall : randomCallsThisTick) {
                this.usedStackTraces.add(randomCall.stackTrace());
            }
        }
        this.setPreferredSize(new Dimension(1280, 720));
        this.setLayout(new BorderLayout());
        this.randomCallsList = new JList<List<RandomCall>>(new Vector<List<RandomCall>>(randomCalls));
        this.randomCallsList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = new JLabel(index + ": " + value.size());
            this.setupSelectionUI(list, label, isSelected, cellHasFocus);
            if (this.isSameAsSelectedTick((List<RandomCall>)value)) {
                label.setForeground(Color.GREEN);
            } else if (this.containsSelectedStackTrace((List<RandomCall>)value)) {
                label.setForeground(Color.RED);
            }
            return label;
        });
        this.randomCallsList.addListSelectionListener(e -> {
            int index = this.randomCallsList.getSelectedIndex();
            if (index >= 0 && index < this.randomCalls.size()) {
                this.setSelectedTick(this.randomCalls.get(index));
            }
        });
        this.callsInTickList = new JList();
        this.callsInTickList.setModel(new DefaultListModel());
        this.callsInTickList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JTextArea textArea = new JTextArea(value.nbt() + "\n" + DebugRandom.stackTraceById.get(value.stackTrace()));
            textArea.setEditable(false);
            this.setupSelectionUI(list, textArea, isSelected, cellHasFocus);
            if (value.stackTrace() == this.selectedStackTrace) {
                textArea.setBackground(Color.YELLOW);
            }
            return textArea;
        });
        this.callsInTickList.addListSelectionListener(e -> {
            int index = this.callsInTickList.getSelectedIndex();
            if (this.selectedTick != null && index >= 0 && index < this.selectedTick.size()) {
                this.setSelectedStackTrace(this.selectedTick.get(index).stackTrace());
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Ticks", new JSplitPane(1, new JScrollPane(this.randomCallsList), new JScrollPane(this.callsInTickList)));
        this.allStackTraceList = new JList<String>(new Vector<String>(DebugRandom.stackTraceById));
        this.allStackTraceList.addListSelectionListener(e -> this.setSelectedStackTrace(this.allStackTraceList.getSelectedIndex()));
        this.allStackTraceList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (!this.usedStackTraces.contains(index)) {
                return new JPanel();
            }
            JTextArea textArea = new JTextArea((String)value);
            textArea.setEditable(false);
            this.setupSelectionUI(list, textArea, isSelected, cellHasFocus);
            if (index == this.selectedStackTrace) {
                textArea.setBackground(Color.YELLOW);
            }
            return textArea;
        });
        tabbedPane.addTab("All traces", new JScrollPane(this.allStackTraceList));
        this.add((Component)tabbedPane, "Center");
        JPanel bottomPanel = new JPanel();
        JButton dumpStackTraceButton = new JButton("Dump stack trace");
        dumpStackTraceButton.addActionListener(e -> {
            if (this.selectedStackTrace >= 0 && this.selectedStackTrace < DebugRandom.stackTraceById.size()) {
                DebugRandom.LOGGER.info(DebugRandom.stackTraceById.get(this.selectedStackTrace));
            }
        });
        bottomPanel.add(dumpStackTraceButton);
        this.add((Component)bottomPanel, "South");
    }

    private void setSelectedStackTrace(int selectedStackTrace) {
        this.selectedStackTrace = selectedStackTrace;
        if (this.randomCallsList != null) {
            this.randomCallsList.repaint();
        }
        if (this.callsInTickList != null) {
            this.callsInTickList.repaint();
        }
        if (this.allStackTraceList != null) {
            this.allStackTraceList.repaint();
        }
    }

    private void setSelectedTick(List<RandomCall> randomCalls) {
        this.selectedStackTrace = -1;
        this.selectedTick = randomCalls;
        this.randomCallsList.repaint();
        DefaultListModel model = (DefaultListModel)this.callsInTickList.getModel();
        model.clear();
        model.addAll(randomCalls);
    }

    private boolean isSameAsSelectedTick(List<RandomCall> randomCalls) {
        if (this.selectedTick == null) {
            return false;
        }
        if (randomCalls.size() != this.selectedTick.size()) {
            return false;
        }
        for (int i = 0; i < randomCalls.size(); ++i) {
            if (randomCalls.get(i).stackTrace() == this.selectedTick.get(i).stackTrace()) continue;
            return false;
        }
        return true;
    }

    private boolean containsSelectedStackTrace(List<RandomCall> randomCalls) {
        for (RandomCall randomCall : randomCalls) {
            if (randomCall.stackTrace() != this.selectedStackTrace) continue;
            return true;
        }
        return false;
    }

    private void setupSelectionUI(JList<?> list, JComponent component, boolean isSelected, boolean cellHasFocus) {
        component.setBackground(list.getBackground());
        component.setForeground(list.getForeground());
        if (isSelected) {
            component.setBackground(list.getSelectionBackground());
            component.setForeground(list.getSelectionForeground());
        }
        if (cellHasFocus) {
            if (isSelected) {
                component.setBorder(UIManager.getBorder("List.focusSelectedCellHighlightBorder", component.getLocale()));
            }
            if (component.getBorder() == null) {
                component.setBorder(UIManager.getBorder("List.focusCellHighlightBorder", component.getLocale()));
            }
        }
    }
}

