/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;

public class MultibaseIntegerArgumentType
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "123", "-123", "0xf00baa", "0xF00BAA", "0123", "0b101");
    private final int minimum;
    private final int maximum;

    private MultibaseIntegerArgumentType(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public static MultibaseIntegerArgumentType multibaseInteger() {
        return MultibaseIntegerArgumentType.multibaseInteger(Integer.MIN_VALUE);
    }

    public static MultibaseIntegerArgumentType multibaseInteger(int min) {
        return MultibaseIntegerArgumentType.multibaseInteger(min, Integer.MAX_VALUE);
    }

    public static MultibaseIntegerArgumentType multibaseInteger(int min, int max) {
        return new MultibaseIntegerArgumentType(min, max);
    }

    public static int getMultibaseInteger(CommandContext<?> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int result;
        int start = reader.getCursor();
        if (reader.peek() == '0') {
            reader.skip();
            if (!reader.canRead()) {
                result = 0;
            } else if (reader.peek() == 'x' || reader.peek() == 'X') {
                reader.skip();
                int nStart = reader.getCursor();
                while (reader.canRead() && (reader.peek() >= '0' && reader.peek() <= '9' || reader.peek() >= 'a' && reader.peek() <= 'f' || reader.peek() >= 'A' && reader.peek() <= 'F')) {
                    reader.skip();
                }
                try {
                    result = Integer.parseInt(reader.getString().substring(nStart, reader.getCursor()), 16);
                }
                catch (NumberFormatException e) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)reader);
                }
            } else if (reader.peek() == 'b' || reader.peek() == 'B') {
                reader.skip();
                int nStart = reader.getCursor();
                while (reader.canRead() && (reader.peek() == '0' || reader.peek() == '1')) {
                    reader.skip();
                }
                try {
                    result = Integer.parseInt(reader.getString().substring(nStart, reader.getCursor()), 2);
                }
                catch (NumberFormatException e) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)reader);
                }
            } else if (reader.peek() >= '0' && reader.peek() <= '7') {
                int nStart = reader.getCursor();
                while (reader.canRead() && reader.peek() >= '0' && reader.peek() <= '7') {
                    reader.skip();
                }
                try {
                    result = Integer.parseInt(reader.getString().substring(nStart, reader.getCursor()), 8);
                }
                catch (NumberFormatException e) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)reader);
                }
            } else {
                reader.setCursor(start);
                result = reader.readInt();
            }
        } else {
            result = reader.readInt();
        }
        if (result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.minimum);
        }
        if (result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.maximum);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultibaseIntegerArgumentType)) {
            return false;
        }
        MultibaseIntegerArgumentType that = (MultibaseIntegerArgumentType)o;
        return this.maximum == that.maximum && this.minimum == that.minimum;
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

