/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ItemAndEnchantmentsPredicateArgumentType
implements ArgumentType<ItemAndEnchantmentsPredicate> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick with sharpness 4 without sweeping *", "minecraft:diamond_sword with sharpness *");
    private static final SimpleCommandExceptionType EXPECTED_WITH_WITHOUT_EXACTLY_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cenchant.expectedWithWithoutExactly"));
    private static final SimpleCommandExceptionType INCOMPATIBLE_ENCHANTMENT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cenchant.incompatible"));
    private static final DynamicCommandExceptionType ID_INVALID_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"argument.item.id.invalid", (Object[])new Object[]{id}));
    private Predicate<class_1792> itemPredicate = item -> true;
    private BiPredicate<class_1792, class_1887> enchantmentPredicate = (item, ench) -> true;
    private boolean constrainMaxLevel = false;

    private ItemAndEnchantmentsPredicateArgumentType() {
    }

    public static ItemAndEnchantmentsPredicateArgumentType itemAndEnchantmentsPredicate() {
        return new ItemAndEnchantmentsPredicateArgumentType();
    }

    public ItemAndEnchantmentsPredicateArgumentType withItemPredicate(Predicate<class_1792> predicate) {
        this.itemPredicate = predicate;
        return this;
    }

    public ItemAndEnchantmentsPredicateArgumentType withEnchantmentPredicate(BiPredicate<class_1792, class_1887> predicate) {
        this.enchantmentPredicate = predicate;
        return this;
    }

    public ItemAndEnchantmentsPredicateArgumentType constrainMaxLevel() {
        this.constrainMaxLevel = true;
        return this;
    }

    public static ItemAndEnchantmentsPredicate getItemAndEnchantmentsPredicate(CommandContext<?> context, String name) {
        return (ItemAndEnchantmentsPredicate)context.getArgument(name, ItemAndEnchantmentsPredicate.class);
    }

    public ItemAndEnchantmentsPredicate parse(StringReader reader) throws CommandSyntaxException {
        Parser parser = new Parser(reader);
        parser.parse();
        Predicate<List<class_1889>> predicate = enchantments -> {
            if (parser.exact && parser.with.size() != enchantments.size()) {
                return false;
            }
            for (class_1889 with : parser.with) {
                boolean found = false;
                for (class_1889 ench : enchantments) {
                    if (with.field_9093 != ench.field_9093 || with.field_9094 != -1 && with.field_9094 != ench.field_9094) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            if (parser.exact) {
                return true;
            }
            for (class_1889 without : parser.without) {
                for (class_1889 ench : enchantments) {
                    if (without.field_9093 != ench.field_9093 || without.field_9094 != -1 && without.field_9094 != ench.field_9094) continue;
                    return false;
                }
            }
            return true;
        };
        return new ItemAndEnchantmentsPredicate(parser.item, predicate, parser.with.size());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record ItemAndEnchantmentsPredicate(class_1792 item, Predicate<List<class_1889>> predicate, int numEnchantments) implements Predicate<class_1799>
    {
        @Override
        public boolean test(class_1799 stack) {
            if (this.item != stack.method_7909() && (this.item != class_1802.field_8529 || stack.method_7909() != class_1802.field_8598)) {
                return false;
            }
            Map enchantmentMap = class_1890.method_8222((class_1799)stack);
            ArrayList enchantments = new ArrayList(enchantmentMap.size());
            enchantmentMap.forEach((id, lvl) -> enchantments.add(new class_1889(id, lvl.intValue())));
            return this.predicate.test(enchantments);
        }
    }

    private class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;
        private class_1792 item;
        private final List<class_1889> with = new ArrayList<class_1889>();
        private final List<class_1889> without = new ArrayList<class_1889>();
        private boolean exact = false;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public void parse() throws CommandSyntaxException {
            this.item = this.parseItem();
            while (this.reader.canRead()) {
                this.parseSpace();
                this.parseInfoEnchantment();
                if (!this.exact) continue;
                return;
            }
        }

        private class_1792 parseItem() throws CommandSyntaxException {
            this.suggestEnchantableItem();
            int start = this.reader.getCursor();
            class_2960 identifier = class_2960.method_12835((StringReader)this.reader);
            class_1792 item = (class_1792)class_7923.field_41178.method_17966(identifier).orElseThrow(() -> {
                this.reader.setCursor(start);
                return ID_INVALID_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)identifier);
            });
            if (!(item.method_7837() > 0 && ItemAndEnchantmentsPredicateArgumentType.this.itemPredicate.test(item) || item == class_1802.field_8598 && ItemAndEnchantmentsPredicateArgumentType.this.itemPredicate.test(class_1802.field_8529))) {
                this.reader.setCursor(start);
                throw INCOMPATIBLE_ENCHANTMENT_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            if (item == class_1802.field_8598) {
                item = class_1802.field_8529;
            }
            return item;
        }

        private void parseInfoEnchantment() throws CommandSyntaxException {
            class_1799 stack = new class_1799((class_1935)this.item);
            Option option = this.parseWithWithoutExactly();
            boolean suggest = this.reader.canRead();
            this.parseSpace();
            if (option == Option.EXACT) {
                this.exact = true;
                return;
            }
            class_1887 enchantment = this.parseEnchantment(suggest, option, stack);
            suggest = this.reader.canRead();
            this.parseSpace();
            int level = this.parseEnchantmentLevel(suggest, option, stack, enchantment);
            if (option == Option.WITH) {
                this.with.add(new class_1889(enchantment, level));
            } else {
                this.without.add(new class_1889(enchantment, level));
            }
        }

        private Option parseWithWithoutExactly() throws CommandSyntaxException {
            String option;
            this.suggestWithWithoutExactly();
            int start = this.reader.getCursor();
            return switch (option = this.reader.readUnquotedString()) {
                case "with" -> Option.WITH;
                case "without" -> Option.WITHOUT;
                case "exactly" -> Option.EXACT;
                default -> {
                    this.reader.setCursor(start);
                    throw EXPECTED_WITH_WITHOUT_EXACTLY_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
                }
            };
        }

        private class_1887 parseEnchantment(boolean suggest, Option option, class_1799 stack) throws CommandSyntaxException {
            class_2960 identifier;
            class_1887 enchantment;
            ArrayList<class_1887> allowedEnchantments = new ArrayList<class_1887>();
            block0: for (class_1887 ench : class_7923.field_41176) {
                boolean skip = !ench.method_8192(stack) && stack.method_7909() != class_1802.field_8529 || !ItemAndEnchantmentsPredicateArgumentType.this.enchantmentPredicate.test(stack.method_7909(), ench);
                if (skip) continue;
                if (option == Option.WITH) {
                    for (class_1889 ench2 : this.with) {
                        if (ench2.field_9093 != ench && ench2.field_9093.method_8188(ench)) continue;
                        continue block0;
                    }
                    for (class_1889 ench2 : this.without) {
                        if (ench2.field_9093 != ench || ench2.field_9094 != -1) continue;
                        continue block0;
                    }
                } else {
                    for (class_1889 ench2 : this.with) {
                        if (ench2.field_9093 != ench || ench2.field_9094 != -1) continue;
                        continue block0;
                    }
                    for (class_1889 ench2 : this.without) {
                        if (ench2.field_9093 != ench || ench2.field_9094 != -1) continue;
                        continue block0;
                    }
                }
                allowedEnchantments.add(ench);
            }
            int start = this.reader.getCursor();
            if (suggest) {
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(start);
                    class_2172.method_9257(allowedEnchantments.stream().map(arg_0 -> ((class_2378)class_7923.field_41176).method_10221(arg_0)), (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
            }
            if (!(enchantment = (class_1887)class_7923.field_41176.method_17966(identifier = class_2960.method_12835((StringReader)this.reader)).orElseThrow(() -> {
                this.reader.setCursor(start);
                return class_7733.field_40401.createWithContext((ImmutableStringReader)this.reader, (Object)identifier, (Object)class_7924.field_41265.method_29177());
            })).method_8192(stack) && stack.method_7909() != class_1802.field_8529) {
                this.reader.setCursor(start);
                throw INCOMPATIBLE_ENCHANTMENT_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            return enchantment;
        }

        private int parseEnchantmentLevel(boolean suggest, Option option, class_1799 stack, class_1887 enchantment) throws CommandSyntaxException {
            int maxLevel;
            int level;
            if (ItemAndEnchantmentsPredicateArgumentType.this.constrainMaxLevel) {
                int enchantability = stack.method_7909().method_7837();
                level = 31 + enchantability / 4 + enchantability / 4;
                level += Math.round((float)level * 0.15f);
                for (maxLevel = enchantment.method_8183(); maxLevel >= 1 && level < enchantment.method_8182(maxLevel); --maxLevel) {
                }
            } else {
                maxLevel = enchantment.method_8183();
            }
            ArrayList<Integer> allowedLevels = new ArrayList<Integer>();
            block1: for (level = -1; level <= maxLevel; ++level) {
                if (level == 0) continue;
                if (option == Option.WITH) {
                    for (class_1889 ench : this.without) {
                        if (ench.field_9093 != enchantment || level != -1 && level != ench.field_9094) continue;
                        continue block1;
                    }
                } else {
                    for (class_1889 ench : this.with) {
                        if (ench.field_9093 != enchantment || level != -1 && level != ench.field_9094) continue;
                        continue block1;
                    }
                    for (class_1889 ench : this.without) {
                        if (ench.field_9093 != enchantment || level != -1 && level != ench.field_9094) continue;
                        continue block1;
                    }
                }
                allowedLevels.add(level);
            }
            int start = this.reader.getCursor();
            if (suggest) {
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(start);
                    Iterator iterator = allowedLevels.iterator();
                    while (iterator.hasNext()) {
                        int allowed = (Integer)iterator.next();
                        if (allowed == -1) {
                            builder.suggest("*");
                            continue;
                        }
                        builder.suggest(allowed);
                    }
                    suggestions.add(builder);
                };
            }
            if (!this.reader.canRead()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)this.reader);
            }
            if (this.reader.peek() == '*') {
                this.reader.skip();
                return -1;
            }
            int level2 = this.reader.readInt();
            if (level2 == -1 || !allowedLevels.contains(level2)) {
                this.reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)this.reader, (Object)level2);
            }
            return level2;
        }

        private void parseSpace() throws CommandSyntaxException {
            if (this.reader.canRead()) {
                if (this.reader.peek() != ' ') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)this.reader);
                }
                this.reader.skip();
            }
        }

        private void suggestEnchantableItem() {
            ArrayList<class_2960> allowed = new ArrayList<class_2960>();
            for (class_1792 item : class_7923.field_41178) {
                if (item.method_7837() > 0 && ItemAndEnchantmentsPredicateArgumentType.this.itemPredicate.test(item)) {
                    if (!MultiVersionCompat.INSTANCE.doesItemExist(item)) continue;
                    allowed.add(class_7923.field_41178.method_10221((Object)item));
                    continue;
                }
                if (item != class_1802.field_8598 || !ItemAndEnchantmentsPredicateArgumentType.this.itemPredicate.test(class_1802.field_8529) || !MultiVersionCompat.INSTANCE.doesItemExist(item)) continue;
                allowed.add(class_7923.field_41178.method_10221((Object)class_1802.field_8598));
            }
            int start = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(start);
                class_2172.method_9270((Iterable)allowed, (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
        }

        private void suggestWithWithoutExactly() {
            int start = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(start);
                class_2172.method_9253((String[])new String[]{"with", "without", "exactly"}, (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
        }

        private static enum Option {
            WITH,
            WITHOUT,
            EXACT;

        }
    }
}

