/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.xpple.clientarguments.arguments.CItemStackArgumentType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_7708;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class ItemGroupCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.citemgroup.notFound", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType OUT_OF_BOUNDS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.citemgroup.outOfBounds", (Object[])new Object[]{arg}));
    private static final SimpleCommandExceptionType SAVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.citemgroup.saveFile.failed"));
    private static final DynamicCommandExceptionType ILLEGAL_CHARACTER_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.citemgroup.addGroup.illegalCharacter", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType ALREADY_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.citemgroup.addGroup.alreadyExists", (Object[])new Object[]{arg}));
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("clientcommands");
    private static final Map<String, Group> groups = new HashMap<String, Group>();

    public static void registerItemGroups() {
        try {
            ItemGroupCommand.loadFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not load groups file, hence /citemgroup will not work!", (Throwable)e);
        }
        groups.forEach((key, group) -> group.registerItemGroup((String)key));
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"citemgroup").then(ClientCommandManager.literal((String)"modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(groups.keySet(), (SuggestionsBuilder)builder)).then(ClientCommandManager.literal((String)"add").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"itemstack", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)registryAccess)).then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ItemGroupCommand.addStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), false))))).executes(ctx -> ItemGroupCommand.addStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(1, false)))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ItemGroupCommand.removeStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"itemstack", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)registryAccess)).then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ItemGroupCommand.setStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), false))))).executes(ctx -> ItemGroupCommand.setStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(1, false))))))).then(ClientCommandManager.literal((String)"icon").then(ClientCommandManager.argument((String)"icon", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)registryAccess)).executes(ctx -> ItemGroupCommand.changeIcon((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"icon").method_9781(1, false)))))).then(ClientCommandManager.literal((String)"rename").then(ClientCommandManager.argument((String)"new", (ArgumentType)StringArgumentType.string()).executes(ctx -> ItemGroupCommand.renameGroup((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), StringArgumentType.getString((CommandContext)ctx, (String)"new")))))))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"group", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"icon", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)registryAccess)).executes(ctx -> ItemGroupCommand.addGroup((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"icon").method_9781(1, false))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(groups.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> ItemGroupCommand.removeGroup((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"group"))))));
    }

    private static int addGroup(FabricClientCommandSource source, String name, class_1799 icon) throws CommandSyntaxException {
        if (groups.containsKey(name)) {
            throw ALREADY_EXISTS_EXCEPTION.create((Object)name);
        }
        class_2960 identifier = class_2960.method_12829((String)("clientcommands:" + name));
        if (identifier == null) {
            throw ILLEGAL_CHARACTER_EXCEPTION.create((Object)name);
        }
        groups.put(name, new Group(icon, new class_2499()));
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.addGroup.success", (Object[])new Object[]{name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int removeGroup(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        groups.remove(name);
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.removeGroup.success", (Object[])new Object[]{name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int addStack(FabricClientCommandSource source, String name, class_1799 itemStack) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Group group = groups.get(name);
        class_2499 items = group.items();
        items.add((Object)itemStack.method_7953(new class_2487()));
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.addStack.success", (Object[])new Object[]{itemStack.method_7909().method_7848(), name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int removeStack(FabricClientCommandSource source, String name, int index) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Group group = groups.get(name);
        class_2499 items = group.items();
        if (index < 0 || index >= items.size()) {
            throw OUT_OF_BOUNDS_EXCEPTION.create((Object)index);
        }
        items.method_10536(index);
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.removeStack.success", (Object[])new Object[]{name, index}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int setStack(FabricClientCommandSource source, String name, int index, class_1799 itemStack) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Group group = groups.get(name);
        class_2499 items = group.items();
        if (index < 0 || index >= items.size()) {
            throw OUT_OF_BOUNDS_EXCEPTION.create((Object)index);
        }
        items.method_10606(index, (class_2520)itemStack.method_7953(new class_2487()));
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.setStack.success", (Object[])new Object[]{name, index, itemStack.method_7909().method_7848()}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int changeIcon(FabricClientCommandSource source, String name, class_1799 icon) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Group group = groups.get(name);
        class_2499 items = group.items();
        class_1799 old = group.icon();
        groups.put(name, new Group(icon, items));
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.changeIcon.success", (Object[])new Object[]{name, old.method_7909().method_7848(), icon.method_7909().method_7848()}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int renameGroup(FabricClientCommandSource source, String name, String _new) throws CommandSyntaxException {
        if (!groups.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        class_2960 identifier = class_2960.method_12829((String)("clientcommands:" + _new));
        if (identifier == null) {
            throw ILLEGAL_CHARACTER_EXCEPTION.create((Object)_new);
        }
        Group group = groups.remove(name);
        groups.put(_new, group);
        ItemGroupCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.citemgroup.renameGroup.success", (Object[])new Object[]{name, _new}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static void saveFile() throws CommandSyntaxException {
        try {
            class_2487 rootTag = new class_2487();
            class_2487 compoundTag = new class_2487();
            groups.forEach((key, value) -> {
                class_2487 group = new class_2487();
                group.method_10566("icon", (class_2520)value.icon().method_7953(new class_2487()));
                group.method_10566("items", (class_2520)value.items());
                compoundTag.method_10566(key, (class_2520)group);
            });
            rootTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
            rootTag.method_10566("Groups", (class_2520)compoundTag);
            File newFile = File.createTempFile("groups", ".dat", configPath.toFile());
            class_2507.method_10630((class_2487)rootTag, (File)newFile);
            File backupFile = new File(configPath.toFile(), "groups.dat_old");
            File currentFile = new File(configPath.toFile(), "groups.dat");
            class_156.method_27760((File)currentFile, (File)newFile, (File)backupFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw SAVE_FAILED_EXCEPTION.create();
        }
    }

    private static void loadFile() throws IOException {
        groups.clear();
        class_2487 rootTag = class_2507.method_10633((File)new File(configPath.toFile(), "groups.dat"));
        if (rootTag == null) {
            return;
        }
        int currentVersion = class_155.method_16673().method_37912().method_38494();
        int fileVersion = rootTag.method_10550("DataVersion");
        class_2487 compoundTag = rootTag.method_10562("Groups");
        DataFixer dataFixer = class_310.method_1551().method_1543();
        if (fileVersion >= currentVersion) {
            compoundTag.method_10541().forEach(key -> {
                if (class_2960.method_12829((String)("clientcommands:" + key)) == null) {
                    LOGGER.warn("Skipping item group with invalid name {}", key);
                    return;
                }
                class_2487 group = compoundTag.method_10562(key);
                class_1799 icon = ItemGroupCommand.singleItemFromNbt(group.method_10562("icon"));
                class_2499 items = group.method_10554("items", 10);
                groups.put((String)key, new Group(icon, items));
            });
        } else {
            compoundTag.method_10541().forEach(key -> {
                if (class_2960.method_12829((String)("clientcommands:" + key)) == null) {
                    LOGGER.warn("Skipping item group with invalid name {}", key);
                    return;
                }
                class_2487 group = compoundTag.method_10562(key);
                Dynamic oldStackDynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)group.method_10562("icon"));
                Dynamic newStackDynamic = dataFixer.update(class_1208.field_5712, oldStackDynamic, fileVersion, currentVersion);
                class_1799 icon = ItemGroupCommand.singleItemFromNbt((class_2487)newStackDynamic.getValue());
                class_2499 updatedListTag = new class_2499();
                group.method_10554("items", 10).forEach(tag -> {
                    Dynamic oldTagDynamic = new Dynamic((DynamicOps)class_2509.field_11560, tag);
                    Dynamic newTagDynamic = dataFixer.update(class_1208.field_5712, oldTagDynamic, fileVersion, currentVersion);
                    updatedListTag.add((Object)((class_2520)newTagDynamic.getValue()));
                });
                groups.put((String)key, new Group(icon, updatedListTag));
            });
        }
    }

    private static class_1799 singleItemFromNbt(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        if (!stack.method_7960()) {
            stack.method_7939(1);
        }
        return stack;
    }

    private record Group(class_1799 icon, class_2499 items) {
        void registerItemGroup(String key) {
            class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960("clientcommands", key), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43470((String)key)).method_47320(() -> this.icon).method_47317((displayContext, entries) -> {
                Set existingStacks = class_7708.method_47572();
                for (int i = 0; i < this.items.size(); ++i) {
                    class_1799 stack = ItemGroupCommand.singleItemFromNbt(this.items.method_10602(i));
                    if (stack.method_7960()) continue;
                    stack.method_7939(1);
                    if (!existingStacks.add(stack)) continue;
                    entries.method_45420(stack);
                }
            }).method_47324());
        }
    }
}

