/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.xpple.clientarguments.arguments.CBlockPosArgumentType;
import dev.xpple.clientarguments.arguments.CColorArgumentType;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.arguments.MultibaseIntegerArgumentType;
import net.earthcomputer.clientcommands.interfaces.IEntity;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class GlowCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cglow.entity.failed"));
    private static final int FLAG_KEEP_SEARCHING = 1;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode cglow = dispatcher.register(ClientCommandManager.literal((String)"cglow"));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cglow").then(ClientCommandManager.literal((String)"--keep-searching-entities").redirect((CommandNode)cglow, ctx -> ClientCommandHelper.withFlags((FabricClientCommandSource)ctx.getSource(), 1, true)))).then(ClientCommandManager.literal((String)"entities").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"targets", (ArgumentType)CEntityArgumentType.entities()).executes(ctx -> GlowCommand.glowEntities((FabricClientCommandSource)ctx.getSource(), (CEntitySelector)ctx.getArgument("targets", CEntitySelector.class), ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, 1) ? 0 : 30, 0xFFFFFF))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> GlowCommand.glowEntities((FabricClientCommandSource)ctx.getSource(), (CEntitySelector)ctx.getArgument("targets", CEntitySelector.class), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), 0xFFFFFF))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"color", (ArgumentType)CColorArgumentType.color()).executes(ctx -> GlowCommand.glowEntities((FabricClientCommandSource)ctx.getSource(), (CEntitySelector)ctx.getArgument("targets", CEntitySelector.class), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), Optional.ofNullable(CColorArgumentType.getCColor((CommandContext)ctx, (String)"color").method_532()).orElse(0xFFFFFF)))))).then(ClientCommandManager.literal((String)"colorCode").then(ClientCommandManager.argument((String)"color", (ArgumentType)MultibaseIntegerArgumentType.multibaseInteger(0, 0xFFFFFF)).executes(ctx -> GlowCommand.glowEntities((FabricClientCommandSource)ctx.getSource(), (CEntitySelector)ctx.getArgument("targets", CEntitySelector.class), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), MultibaseIntegerArgumentType.getMultibaseInteger(ctx, "color"))))))))).then(ClientCommandManager.literal((String)"area").then(ClientCommandManager.argument((String)"from", (ArgumentType)CBlockPosArgumentType.blockPos()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"to", (ArgumentType)CBlockPosArgumentType.blockPos()).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"to"), 1, 0xFFFFFF))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"to"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), 0xFFFFFF))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"color", (ArgumentType)CColorArgumentType.color()).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"to"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), Optional.ofNullable(CColorArgumentType.getCColor((CommandContext)ctx, (String)"color").method_532()).orElse(0xFFFFFF)))))).then(ClientCommandManager.literal((String)"colorCode").then(ClientCommandManager.argument((String)"color", (ArgumentType)MultibaseIntegerArgumentType.multibaseInteger(0, 0xFFFFFF)).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"to"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), MultibaseIntegerArgumentType.getMultibaseInteger(ctx, "color")))))))))).then(ClientCommandManager.literal((String)"block").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"block", (ArgumentType)CBlockPosArgumentType.blockPos()).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"block"), null, 1, 0xFFFFFF))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"block"), null, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), 0xFFFFFF))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"color", (ArgumentType)CColorArgumentType.color()).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"block"), null, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), Optional.ofNullable(CColorArgumentType.getCColor((CommandContext)ctx, (String)"color").method_532()).orElse(0xFFFFFF)))))).then(ClientCommandManager.literal((String)"colorCode").then(ClientCommandManager.argument((String)"color", (ArgumentType)MultibaseIntegerArgumentType.multibaseInteger(0, 0xFFFFFF)).executes(ctx -> GlowCommand.glowBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"block"), null, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"), MultibaseIntegerArgumentType.getMultibaseInteger(ctx, "color")))))))));
    }

    private static int glowEntities(final FabricClientCommandSource source, final CEntitySelector entitySelector, final int seconds, final int color) throws CommandSyntaxException {
        boolean keepSearching = ClientCommandHelper.getFlag(source, 1);
        if (keepSearching) {
            String taskName = TaskManager.addTask("cglow", new SimpleTask(){

                @Override
                public boolean condition() {
                    return class_310.method_1551().field_1724 != null;
                }

                @Override
                protected void onTick() {
                    class_746 player = class_310.method_1551().field_1724;
                    assert (player != null);
                    try {
                        for (class_1297 entity : entitySelector.getEntities(source)) {
                            ((IEntity)entity).addGlowingTicket(seconds * 20, color);
                        }
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
            });
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cglow.entity.keepSearching.success").method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.cancel", "/ctask stop " + taskName)));
            return 1;
        }
        List entities = entitySelector.getEntities(source);
        if (entities.isEmpty()) {
            throw FAILED_EXCEPTION.create();
        }
        for (class_1297 entity : entities) {
            ((IEntity)entity).addGlowingTicket(seconds * 20, color);
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cglow.entity.success", (Object[])new Object[]{entities.size()}));
        return entities.size();
    }

    private static int glowBlock(FabricClientCommandSource source, class_2338 pos1, class_2338 pos2, int seconds, int color) {
        ArrayList<class_238> boundingBoxes = new ArrayList<class_238>();
        if (pos2 == null) {
            boundingBoxes.addAll(class_310.method_1551().field_1687.method_8320(pos1).method_26218((class_1922)source.getWorld(), pos1).method_1090());
            if (boundingBoxes.isEmpty()) {
                boundingBoxes.add(new class_238(pos1));
            } else {
                boundingBoxes.replaceAll(box -> box.method_996(pos1));
            }
        } else {
            boundingBoxes.add(new class_238(pos1, pos2));
        }
        for (class_238 box2 : boundingBoxes) {
            RenderQueue.addCuboid(RenderQueue.Layer.ON_TOP, box2, box2, color, seconds * 20);
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cglow.area.success", (Object[])new Object[]{boundingBoxes.size()}));
        return boundingBoxes.size();
    }
}

