/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CBlockPosArgumentType;
import dev.xpple.clientarguments.arguments.CBlockStateArgumentType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_638;
import net.minecraft.class_7157;

public class GhostBlockCommand {
    private static final SimpleCommandExceptionType SET_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.setblock.failed"));
    private static final SimpleCommandExceptionType FILL_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.fill.failed"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cghostblock").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"pos", (ArgumentType)CBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"block", (ArgumentType)CBlockStateArgumentType.blockState((class_7157)registryAccess)).executes(ctx -> GhostBlockCommand.setGhostBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"pos"), CBlockStateArgumentType.getCBlockState((CommandContext)ctx, (String)"block").getBlockState())))))).then(ClientCommandManager.literal((String)"fill").then(ClientCommandManager.argument((String)"from", (ArgumentType)CBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"to", (ArgumentType)CBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"block", (ArgumentType)CBlockStateArgumentType.blockState((class_7157)registryAccess)).executes(ctx -> GhostBlockCommand.fillGhostBlocks((FabricClientCommandSource)ctx.getSource(), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgumentType.getCBlockPos((CommandContext)ctx, (String)"to"), CBlockStateArgumentType.getCBlockState((CommandContext)ctx, (String)"block").getBlockState())))))));
    }

    private static int setGhostBlock(FabricClientCommandSource source, class_2338 pos, class_2680 state) throws CommandSyntaxException {
        class_638 world = source.getWorld();
        assert (world != null);
        GhostBlockCommand.checkLoaded(world, pos);
        boolean result = world.method_8652(pos, state, 18);
        if (result) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cghostblock.set.success"));
            return 1;
        }
        throw SET_FAILED_EXCEPTION.create();
    }

    private static int fillGhostBlocks(FabricClientCommandSource source, class_2338 from, class_2338 to, class_2680 state) throws CommandSyntaxException {
        class_638 world = source.getWorld();
        assert (world != null);
        GhostBlockCommand.checkLoaded(world, from);
        GhostBlockCommand.checkLoaded(world, to);
        class_3341 range = class_3341.method_34390((class_2382)from, (class_2382)to);
        int successCount = 0;
        for (class_2338 pos : class_2338.method_10094((int)range.method_35415(), (int)range.method_35416(), (int)range.method_35417(), (int)range.method_35418(), (int)range.method_35419(), (int)range.method_35420())) {
            if (!world.method_8652(pos, state, 18)) continue;
            ++successCount;
        }
        if (successCount == 0) {
            throw FILL_FAILED_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cghostblock.fill.success", (Object[])new Object[]{successCount}));
        return successCount;
    }

    private static void checkLoaded(class_638 world, class_2338 pos) throws CommandSyntaxException {
        if (!world.method_22340(pos)) {
            throw CBlockPosArgumentType.UNLOADED_EXCEPTION.create();
        }
        if (!world.method_24794(pos)) {
            throw CBlockPosArgumentType.OUT_OF_WORLD_EXCEPTION.create();
        }
    }
}

