/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Set;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.arguments.ClientItemPredicateArgumentType;
import net.earthcomputer.clientcommands.command.arguments.ItemAndEnchantmentsPredicateArgumentType;
import net.earthcomputer.clientcommands.command.arguments.WithStringArgumentType;
import net.earthcomputer.clientcommands.features.FishingCracker;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.apache.commons.lang3.tuple.Pair;

public class FishCommand {
    private static final Set<class_1792> ENCHANTABLE_ITEMS = ImmutableSet.of((Object)class_1802.field_8529, (Object)class_1802.field_8378, (Object)class_1802.field_8102);
    private static final SimpleCommandExceptionType NEED_FISHING_MANIPULATION_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cfish.needFishingManipulation").method_27694(style -> style.method_10977(class_124.field_1061)).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.enable", "/cconfig clientcommands fishingManipulation set MANUAL")));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() >= 763) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cfish").then(ClientCommandManager.literal((String)"list-goals").executes(ctx -> FishCommand.listGoals((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.literal((String)"add-goal").then(ClientCommandManager.argument((String)"goal", (ArgumentType)ClientItemPredicateArgumentType.clientItemPredicate(registryAccess)).executes(ctx -> FishCommand.addGoal((FabricClientCommandSource)ctx.getSource(), ClientItemPredicateArgumentType.getClientItemPredicate((CommandContext<FabricClientCommandSource>)ctx, "goal")))))).then(ClientCommandManager.literal((String)"add-enchanted-goal").then(ClientCommandManager.argument((String)"goal", WithStringArgumentType.withString(ItemAndEnchantmentsPredicateArgumentType.itemAndEnchantmentsPredicate().withItemPredicate(ENCHANTABLE_ITEMS::contains).withEnchantmentPredicate((item, ench) -> ench.method_25950()).constrainMaxLevel())).executes(ctx -> FishCommand.addEnchantedGoal((FabricClientCommandSource)ctx.getSource(), WithStringArgumentType.getWithString(ctx, "goal", ItemAndEnchantmentsPredicateArgumentType.ItemAndEnchantmentsPredicate.class)))))).then(ClientCommandManager.literal((String)"remove-goal").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> FishCommand.removeGoal((FabricClientCommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"))))));
    }

    private static int listGoals(FabricClientCommandSource source) throws CommandSyntaxException {
        if (!Configs.getFishingManipulation().isEnabled()) {
            throw NEED_FISHING_MANIPULATION_EXCEPTION.create();
        }
        if (FishingCracker.goals.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cfish.listGoals.noGoals").method_27694(style -> style.method_10977(class_124.field_1061)));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfish.listGoals.success", (Object[])new Object[]{FishingCracker.goals.size()}));
            for (int i = 0; i < FishingCracker.goals.size(); ++i) {
                source.sendFeedback(class_2561.method_30163((String)(i + 1 + ": " + FishingCracker.goals.get(i).getPrettyString())));
            }
        }
        return FishingCracker.goals.size();
    }

    private static int addGoal(FabricClientCommandSource source, ClientItemPredicateArgumentType.ClientItemPredicate goal) throws CommandSyntaxException {
        if (!Configs.getFishingManipulation().isEnabled()) {
            throw NEED_FISHING_MANIPULATION_EXCEPTION.create();
        }
        FishingCracker.goals.add(goal);
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfish.addGoal.success", (Object[])new Object[]{goal.getPrettyString()}));
        return FishingCracker.goals.size();
    }

    private static int addEnchantedGoal(FabricClientCommandSource source, Pair<String, ItemAndEnchantmentsPredicateArgumentType.ItemAndEnchantmentsPredicate> stringAndItemAndEnchantments) throws CommandSyntaxException {
        if (!Configs.getFishingManipulation().isEnabled()) {
            throw NEED_FISHING_MANIPULATION_EXCEPTION.create();
        }
        String string = (String)stringAndItemAndEnchantments.getLeft();
        ItemAndEnchantmentsPredicateArgumentType.ItemAndEnchantmentsPredicate itemAndEnchantments = (ItemAndEnchantmentsPredicateArgumentType.ItemAndEnchantmentsPredicate)stringAndItemAndEnchantments.getRight();
        ClientItemPredicateArgumentType.EnchantedItemPredicate goal = new ClientItemPredicateArgumentType.EnchantedItemPredicate(string, itemAndEnchantments);
        FishingCracker.goals.add(goal);
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfish.addGoal.success", (Object[])new Object[]{string}));
        return FishingCracker.goals.size();
    }

    private static int removeGoal(FabricClientCommandSource source, int index) throws CommandSyntaxException {
        if (!Configs.getFishingManipulation().isEnabled()) {
            throw NEED_FISHING_MANIPULATION_EXCEPTION.create();
        }
        if (index > FishingCracker.goals.size()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().create((Object)index, (Object)FishingCracker.goals.size());
        }
        ClientItemPredicateArgumentType.ClientItemPredicate goal = FishingCracker.goals.remove(index - 1);
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfish.removeGoal.success", (Object[])new Object[]{goal.getPrettyString()}));
        return FishingCracker.goals.size();
    }
}

