/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.arguments.ItemAndEnchantmentsPredicateArgumentType;
import net.earthcomputer.clientcommands.features.EnchantmentCracker;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2164;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CEnchantCommand {
    private static final int FLAG_SIMULATE = 1;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode cenchant = dispatcher.register(ClientCommandManager.literal((String)"cenchant"));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cenchant").then(ClientCommandManager.literal((String)"--simulate").redirect((CommandNode)cenchant, ctx -> ClientCommandHelper.withFlags((FabricClientCommandSource)ctx.getSource(), 1, true)))).then(ClientCommandManager.argument((String)"itemAndEnchantmentsPredicate", (ArgumentType)ItemAndEnchantmentsPredicateArgumentType.itemAndEnchantmentsPredicate().withEnchantmentPredicate(CEnchantCommand::enchantmentPredicate).constrainMaxLevel()).executes(ctx -> CEnchantCommand.cenchant((FabricClientCommandSource)ctx.getSource(), ItemAndEnchantmentsPredicateArgumentType.getItemAndEnchantmentsPredicate(ctx, "itemAndEnchantmentsPredicate")))));
    }

    private static boolean enchantmentPredicate(class_1792 item, class_1887 ench) {
        return !ench.method_8193() && ench.method_25950() && (item == class_1802.field_8529 || ench.field_9083.method_8177(item));
    }

    private static int cenchant(FabricClientCommandSource source, ItemAndEnchantmentsPredicateArgumentType.ItemAndEnchantmentsPredicate itemAndEnchantmentsPredicate) throws class_2164 {
        if (!Configs.getEnchantingPrediction()) {
            class_5250 text = class_2561.method_43471((String)"commands.cenchant.needEnchantingPrediction").method_27692(class_124.field_1061).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.enable", "/cconfig clientcommands enchantingPrediction set true"));
            source.sendFeedback((class_2561)text);
            return 1;
        }
        if (!Configs.playerCrackState.knowsSeed() && Configs.enchCrackState != EnchantmentCracker.CrackState.CRACKED) {
            class_5250 text = class_2561.method_43471((String)"commands.cenchant.uncracked").method_27692(class_124.field_1061).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.crack", "/ccrackrng"));
            source.sendFeedback((class_2561)text);
            return 1;
        }
        boolean simulate = ClientCommandHelper.getFlag(source, 1);
        EnchantmentCracker.ManipulateResult result = EnchantmentCracker.manipulateEnchantments(itemAndEnchantmentsPredicate.item(), itemAndEnchantmentsPredicate.predicate(), simulate);
        if (result == null) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cenchant.failed"));
            if (Configs.playerCrackState != PlayerRandCracker.CrackState.CRACKED) {
                class_5250 help = class_2561.method_43471((String)"commands.cenchant.help.uncrackedPlayerSeed").method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.crack", "/ccrackrng"));
                ClientCommandHelper.sendHelp((class_2561)help);
            }
        } else {
            if (result.itemThrows() < 0) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"enchCrack.insn.itemThrows.noDummy"));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.itemThrows", (Object[])new Object[]{result.itemThrows(), Float.valueOf((float)result.itemThrows() / 20.0f)}));
            }
            source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.bookshelves", (Object[])new Object[]{result.bookshelves()}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.slot", (Object[])new Object[]{result.slot() + 1}));
            source.sendFeedback((class_2561)class_2561.method_43471((String)"enchCrack.insn.enchantments"));
            for (class_1889 ench : result.enchantments()) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)"- ").method_10852(ench.field_9093.method_8179(ench.field_9094)));
            }
            if (!simulate) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cenchant.success"));
            }
        }
        return 1;
    }
}

