/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.regex.Pattern;
import net.earthcomputer.clientcommands.features.BrigadierRemover;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.slf4j.Logger;

public class AliasCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path ALIAS_PATH = FabricLoader.getInstance().getConfigDir().resolve("clientcommands").resolve("alias_list.json");
    private static final SimpleCommandExceptionType ILLEGAL_FORMAT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.calias.illegalFormatException"));
    private static final DynamicCommandExceptionType ALIAS_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.calias.addAlias.aliasAlreadyExists", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType COMMAND_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.calias.addAlias.commandAlreadyExists", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.calias.notFound", (Object[])new Object[]{arg}));
    private static final HashMap<String, String> aliasMap = AliasCommand.loadAliases();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"calias").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> AliasCommand.addAlias((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"key"), StringArgumentType.getString((CommandContext)ctx, (String)"command"))))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> AliasCommand.listAliases((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> AliasCommand.removeAlias((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"key"))))));
        for (String key : aliasMap.keySet()) {
            if (dispatcher.getRoot().getChildren().stream().map(CommandNode::getName).noneMatch(literal -> literal.equals(key))) {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)key).executes(ctx -> AliasCommand.executeAliasCommand((FabricClientCommandSource)ctx.getSource(), key, null))).then(ClientCommandManager.argument((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> AliasCommand.executeAliasCommand((FabricClientCommandSource)ctx.getSource(), key, StringArgumentType.getString((CommandContext)ctx, (String)"arguments")))));
                continue;
            }
            LOGGER.error("Attempted to register alias /{}, but that command already exists", (Object)key);
        }
    }

    private static int executeAliasCommand(FabricClientCommandSource source, String aliasKey, String arguments) throws CommandSyntaxException {
        class_634 networkHandler;
        Object cmd = aliasMap.get(aliasKey);
        if (cmd == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)aliasKey);
        }
        int inlineArgumentCount = (int)Pattern.compile("(?<!%)%(?:%%)*(?!%)").matcher((CharSequence)cmd).results().count();
        if (inlineArgumentCount > 0) {
            String[] argumentArray = arguments.split(" ", inlineArgumentCount + 1);
            Object trailingArguments = "";
            if (argumentArray.length > inlineArgumentCount) {
                trailingArguments = " " + argumentArray[inlineArgumentCount];
            }
            try {
                cmd = String.format((String)cmd, argumentArray) + (String)trailingArguments;
            }
            catch (IllegalFormatException e) {
                throw ILLEGAL_FORMAT_EXCEPTION.create();
            }
        } else if (arguments != null) {
            cmd = (String)cmd + " " + arguments;
        }
        if ((networkHandler = class_310.method_1551().method_1562()) == null) {
            return 1;
        }
        if (((String)cmd).startsWith("/")) {
            cmd = ((String)cmd).substring(1);
            networkHandler.method_45730((String)cmd);
        } else {
            networkHandler.method_45729((String)cmd);
        }
        return 1;
    }

    private static int addAlias(FabricClientCommandSource source, String key, String command) throws CommandSyntaxException {
        if (aliasMap.containsKey(key)) {
            throw ALIAS_EXISTS_EXCEPTION.create((Object)key);
        }
        if (ClientCommandManager.getActiveDispatcher().getRoot().getChildren().stream().map(CommandNode::getName).anyMatch(literal -> literal.equals(key))) {
            throw COMMAND_EXISTS_EXCEPTION.create((Object)key);
        }
        if (!((String)command).startsWith("/")) {
            command = "/" + (String)command;
        }
        for (CommandDispatcher dispatcher : new CommandDispatcher[]{ClientCommandManager.getActiveDispatcher(), class_310.method_1551().method_1562().method_2886()}) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)key).executes(ctx -> AliasCommand.executeAliasCommand(source, key, null))).then(ClientCommandManager.argument((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> AliasCommand.executeAliasCommand(source, key, StringArgumentType.getString((CommandContext)ctx, (String)"arguments")))));
        }
        aliasMap.put(key, (String)command);
        AliasCommand.saveAliases();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.calias.addAlias.success", (Object[])new Object[]{key}));
        return 1;
    }

    private static int listAliases(FabricClientCommandSource source) {
        if (aliasMap.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.calias.listAliases.noAliasesRegistered"));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.calias.listAliases.success", (Object[])new Object[]{aliasMap.size()}));
            for (String key : aliasMap.keySet()) {
                source.sendFeedback(class_2561.method_30163((String)(class_124.field_1067 + key + class_124.field_1070 + ": " + aliasMap.get(key).replace("%", "%%"))));
            }
        }
        return 1;
    }

    private static int removeAlias(FabricClientCommandSource source, String key) throws CommandSyntaxException {
        if (!aliasMap.containsKey(key)) {
            throw NOT_FOUND_EXCEPTION.create((Object)key);
        }
        BrigadierRemover.of(ClientCommandManager.getActiveDispatcher()).get(key).remove();
        BrigadierRemover.of(class_310.method_1551().method_1562().method_2886()).get(key).remove();
        aliasMap.remove(key);
        AliasCommand.saveAliases();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.calias.removeAlias.success", (Object[])new Object[]{key}));
        return 1;
    }

    private static HashMap<String, String> loadAliases() {
        HashMap hashMap;
        block9: {
            if (!Files.exists(ALIAS_PATH, new LinkOption[0])) {
                return new HashMap<String, String>();
            }
            Gson gson = new Gson();
            BufferedReader fileReader = Files.newBufferedReader(ALIAS_PATH);
            try {
                hashMap = (HashMap)gson.fromJson(new JsonReader((Reader)fileReader), new TypeToken<HashMap<String, String>>(){}.getType());
                if (fileReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileReader != null) {
                        try {
                            ((Reader)fileReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException e) {
                    LOGGER.error("Error reading aliases file", e);
                    return new HashMap<String, String>();
                }
            }
            ((Reader)fileReader).close();
        }
        return hashMap;
    }

    private static void saveAliases() {
        try (BufferedWriter writer = Files.newBufferedWriter(ALIAS_PATH, new OpenOption[0]);){
            Gson gson = new Gson();
            gson.toJson(aliasMap, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save aliases", (Throwable)e);
        }
    }
}

