/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.c2c;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.security.PublicKey;
import net.earthcomputer.clientcommands.c2c.C2CPacket;
import net.earthcomputer.clientcommands.c2c.CCPacketHandler;
import net.earthcomputer.clientcommands.c2c.CCPacketListener;
import net.earthcomputer.clientcommands.c2c.ConversionHelper;
import net.earthcomputer.clientcommands.c2c.OutgoingPacketFilter;
import net.earthcomputer.clientcommands.c2c.packets.MessageC2CPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7428;
import net.minecraft.class_7822;
import org.slf4j.Logger;

public class CCNetworkHandler
implements CCPacketListener {
    private static final DynamicCommandExceptionType MESSAGE_TOO_LONG_EXCEPTION = new DynamicCommandExceptionType(d -> class_2561.method_43469((String)"ccpacket.messageTooLong", (Object[])new Object[]{d}));
    private static final SimpleCommandExceptionType PUBLIC_KEY_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ccpacket.publicKeyNotFound"));
    private static final SimpleCommandExceptionType ENCRYPTION_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ccpacket.encryptionFailed"));
    private static final CCNetworkHandler instance = new CCNetworkHandler();
    private static final Logger LOGGER = LogUtils.getLogger();

    private CCNetworkHandler() {
    }

    public static CCNetworkHandler getInstance() {
        return instance;
    }

    public void sendPacket(C2CPacket packet, class_640 recipient) throws CommandSyntaxException {
        Integer id = CCPacketHandler.getId(packet.getClass());
        if (id == null) {
            LOGGER.warn("Could not send the packet because the id was not recognised");
            return;
        }
        class_7822 session = recipient.method_45741();
        if (session == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        class_7428 ppk = session.comp_1086();
        if (ppk == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        PublicKey key = ppk.comp_767().comp_770();
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id.intValue());
        packet.write(buf);
        byte[] compressed = ConversionHelper.Gzip.compress(buf.method_36132());
        int chunks = (compressed.length + 244) / 245;
        byte[][] chunked = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            int start = i * 245;
            int end = Math.min(start + 245, compressed.length);
            chunked[i] = new byte[end - start];
            System.arraycopy(compressed, start, chunked[i], 0, end - start);
        }
        byte[][] encrypted = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            encrypted[i] = ConversionHelper.RsaEcb.encrypt(chunked[i], key);
            if (encrypted[i] != null && encrypted[i].length != 0) continue;
            throw ENCRYPTION_FAILED_EXCEPTION.create();
        }
        byte[] joined = new byte[encrypted.length * 256];
        for (int i = 0; i < encrypted.length; ++i) {
            System.arraycopy(encrypted[i], 0, joined, i * 256, 256);
        }
        String packetString = ConversionHelper.BaseUTF8.toUnicode(joined);
        String commandString = "w " + recipient.method_2966().getName() + " CCENC:" + packetString;
        if (commandString.length() >= 256) {
            throw MESSAGE_TOO_LONG_EXCEPTION.create((Object)commandString.length());
        }
        class_310.method_1551().method_1562().method_45730(commandString);
        OutgoingPacketFilter.addPacket(packetString);
    }

    @Override
    public void onMessageC2CPacket(MessageC2CPacket packet) {
        String sender = packet.getSender();
        String message = packet.getMessage();
        class_5250 prefix = class_2561.method_43473();
        prefix.method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"/cwe").method_27692(class_124.field_1075));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)" "));
        class_5250 text = prefix.method_10852((class_2561)class_2561.method_43469((String)"ccpacket.messageC2CPacket.incoming", (Object[])new Object[]{sender, message}).method_27692(class_124.field_1080));
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)text);
    }
}

