/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import com.google.common.collect.Iterables;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.slf4j.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MultiVersionCompat {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int V1_13_2 = 404;
    public static final int V1_14 = 477;
    public static final int V1_14_2 = 485;
    public static final int V1_15 = 573;
    public static final int V1_15_2 = 578;
    public static final int V1_17 = 755;
    public static final int V1_18 = 757;
    public static final int V1_20 = 763;
    public static final MultiVersionCompat INSTANCE = (MultiVersionCompat)class_156.method_656(() -> {
        try {
            FabricLoader loader = FabricLoader.getInstance();
            ModContainer modContainer = loader.getModContainer("viafabric").orElse(null);
            if (modContainer != null) {
                return new ViaFabric();
            }
            modContainer = loader.getModContainer("viafabricplus").orElse(null);
            if (modContainer != null) {
                return new ViaFabricPlus();
            }
            return new None();
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Could not load proper MultiVersionCompat", (Throwable)e);
            return new None();
        }
    });

    public abstract int getProtocolVersion();

    public abstract String getProtocolName();

    public boolean doesItemExist(class_1792 item) {
        return true;
    }

    private static final class ViaFabric
    extends AbstractViaVersion {
        private final Class<?> fabricDecodeHandler = Class.forName("com.viaversion.fabric.common.handler.FabricDecodeHandler");
        private final Field channel;
        private final Method getInfo = this.fabricDecodeHandler.getMethod("getInfo", new Class[0]);
        private final Method getProtocolInfo = this.getInfo.getReturnType().getMethod("getProtocolInfo", new Class[0]);
        private final Method getServerProtocolVersion = this.getProtocolInfo.getReturnType().getMethod("getServerProtocolVersion", new Class[0]);
        private final Method isRegistered = this.protocolVersion.getMethod("isRegistered", Integer.TYPE);
        private final Method getProtocol = this.protocolVersion.getMethod("getProtocol", Integer.TYPE);

        private ViaFabric() throws ReflectiveOperationException {
            Field channelField = null;
            for (Field field : class_2535.class.getDeclaredFields()) {
                if (field.getType() != Channel.class) continue;
                channelField = field;
                channelField.setAccessible(true);
                break;
            }
            if (channelField == null) {
                throw new NoSuchFieldException("Could not find channel field in ClientConnection");
            }
            this.channel = channelField;
        }

        @Override
        public int getProtocolVersion() {
            try {
                return this.doGetProtocolVersion();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Object getCurrentVersion() throws ReflectiveOperationException {
            int protocolVersion = this.doGetProtocolVersion();
            if (!((Boolean)this.isRegistered.invoke(null, protocolVersion)).booleanValue()) {
                protocolVersion = class_155.method_31372();
            }
            return this.getProtocol.invoke(null, protocolVersion);
        }

        private int doGetProtocolVersion() throws ReflectiveOperationException {
            Object user;
            Object protocol;
            Channel channel;
            ChannelHandler viaDecoder;
            int protocolVersion = class_155.method_31372();
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (networkHandler != null && this.fabricDecodeHandler.isInstance(viaDecoder = (channel = (Channel)this.channel.get(networkHandler.method_48296())).pipeline().get("via-decoder")) && (protocol = this.getProtocolInfo.invoke(user = this.getInfo.invoke((Object)viaDecoder, new Object[0]), new Object[0])) != null) {
                protocolVersion = (Integer)this.getServerProtocolVersion.invoke(protocol, new Object[0]);
            }
            return protocolVersion;
        }
    }

    private static final class ViaFabricPlus
    extends AbstractViaVersion {
        private final Field itemReleaseVersionMappingsInstance;
        private final Method getTargetVersion;
        private final Method versionEnumGetProtocol;
        private final Method itemReleaseVersionMappingsContains;

        private ViaFabricPlus() throws ReflectiveOperationException {
            Class<?> protocolHack = Class.forName("de.florianmichael.viafabricplus.protocolhack.ProtocolHack");
            Class<?> itemReleaseVersionMappings = Class.forName("de.florianmichael.viafabricplus.mappings.ItemReleaseVersionMappings");
            this.itemReleaseVersionMappingsInstance = itemReleaseVersionMappings.getField("INSTANCE");
            this.getTargetVersion = protocolHack.getMethod("getTargetVersion", new Class[0]);
            this.versionEnumGetProtocol = this.getTargetVersion.getReturnType().getMethod("getProtocol", new Class[0]);
            this.itemReleaseVersionMappingsContains = itemReleaseVersionMappings.getMethod("contains", class_1792.class, this.getTargetVersion.getReturnType());
        }

        @Override
        protected Object getCurrentVersion() throws ReflectiveOperationException {
            return this.versionEnumGetProtocol.invoke(this.getVersionEnum(), new Object[0]);
        }

        private Object getVersionEnum() throws ReflectiveOperationException {
            return this.getTargetVersion.invoke(null, new Object[0]);
        }

        @Override
        public boolean doesItemExist(class_1792 item) {
            try {
                Object instance = this.itemReleaseVersionMappingsInstance.get(null);
                return (Boolean)this.itemReleaseVersionMappingsContains.invoke(instance, item, this.getVersionEnum());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class None
    extends MultiVersionCompat {
        private None() {
        }

        @Override
        public int getProtocolVersion() {
            return class_155.method_31372();
        }

        @Override
        public String getProtocolName() {
            return class_155.method_16673().method_48019();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractViaVersion
    extends MultiVersionCompat {
        protected final Class<?> protocolVersion = Class.forName("com.viaversion.viaversion.api.protocol.version.ProtocolVersion");
        private final Method getVersion = this.protocolVersion.getMethod("getVersion", new Class[0]);
        private final Method getIncludedVersions = this.protocolVersion.getMethod("getIncludedVersions", new Class[0]);

        private AbstractViaVersion() throws ReflectiveOperationException {
        }

        protected abstract Object getCurrentVersion() throws ReflectiveOperationException;

        @Override
        public int getProtocolVersion() {
            try {
                return (Integer)this.getVersion.invoke(this.getCurrentVersion(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getProtocolName() {
            Set includedVersions;
            try {
                includedVersions = (Set)this.getIncludedVersions.invoke(this.getCurrentVersion(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            return (String)Iterables.getLast((Iterable)includedVersions);
        }
    }
}

