/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.misc;

import com.seedfinding.mcbiome.biome.Biome;
import com.seedfinding.mcbiome.biome.Biomes;
import com.seedfinding.mcbiome.source.BiomeSource;
import com.seedfinding.mcbiome.source.OverworldBiomeSource;
import com.seedfinding.mccore.block.Block;
import com.seedfinding.mccore.block.Blocks;
import com.seedfinding.mccore.rand.ChunkRand;
import com.seedfinding.mccore.state.Dimension;
import com.seedfinding.mccore.util.pos.BPos;
import com.seedfinding.mccore.util.pos.CPos;
import com.seedfinding.mccore.version.MCVersion;
import com.seedfinding.mcfeature.Feature;
import com.seedfinding.mcfeature.GenerationContext;
import com.seedfinding.mcseed.rand.JRand;
import com.seedfinding.mcterrain.TerrainGenerator;
import com.seedfinding.mcterrain.terrain.OverworldTerrainGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SpawnPoint
extends Feature<Feature.Config, Data> {
    public static final List<Biome> SPAWN_BIOMES = Arrays.asList(Biomes.PLAINS, Biomes.TAIGA, Biomes.TAIGA_HILLS, Biomes.FOREST, Biomes.WOODED_HILLS, Biomes.JUNGLE, Biomes.JUNGLE_HILLS);
    public static final List<Block> SPAWN_BLOCKS = Arrays.asList(Blocks.GRASS_BLOCK, Blocks.PODZOL);

    public SpawnPoint() {
        super(new Feature.Config(), null);
    }

    public static String name() {
        return "spawn";
    }

    public static BPos getSpawn(OverworldTerrainGenerator generator) {
        return new SpawnPoint().getSpawnPoint(generator);
    }

    public static BPos getApproximateSpawn(OverworldBiomeSource source) {
        return new SpawnPoint().getApproximateSpawnPoint(source);
    }

    public BPos getSpawnPoint(OverworldTerrainGenerator generator) {
        return this.getSpawnPoint((OverworldBiomeSource)generator.getBiomeSource(), generator, SPAWN_BIOMES, true);
    }

    public BPos getApproximateSpawnPoint(OverworldBiomeSource source) {
        return this.getSpawnPoint(source, null, SPAWN_BIOMES, false);
    }

    private BPos getSpawnPoint(OverworldBiomeSource source, OverworldTerrainGenerator generator, Collection<Biome> spawnBiomes, boolean trueSpawn) {
        if (source.getVersion().isOlderThan(MCVersion.v1_13)) {
            return SpawnPoint.getSpawnPoint12(source, generator, spawnBiomes, trueSpawn);
        }
        JRand rand = new JRand(source.getWorldSeed());
        BPos spawnPos = source.locateBiome(0, 0, 0, 256, spawnBiomes, rand);
        CPos spawnCPos = spawnPos == null ? new CPos(0, 0) : spawnPos.toChunkPos();
        BPos bPos = spawnPos = spawnPos == null ? new BPos(8, 64, 8) : spawnPos.add(8, 64, 8);
        if (trueSpawn) {
            int cx = 0;
            int cz = 0;
            int incX = 0;
            int incZ = -1;
            for (int l = 0; l < 1024; ++l) {
                BPos newSpawnPos;
                if (cx > -16 && cx <= 16 && cz > -16 && cz <= 16 && (newSpawnPos = SpawnPoint.getSpawnPosInChunk(generator, spawnCPos.add(cx, cz))) != null) {
                    spawnPos = newSpawnPos;
                    break;
                }
                if (cx == cz || cx < 0 && cx == -cz || cx > 0 && cx == 1 - cz) {
                    int swap = incX;
                    incX = -incZ;
                    incZ = swap;
                }
                cx += incX;
                cz += incZ;
            }
        }
        return spawnPos;
    }

    private static BPos getSpawnPosInChunk(OverworldTerrainGenerator terrainGenerator, CPos cPos) {
        BPos chunkStartPos = cPos.toBlockPos();
        for (int x = chunkStartPos.getX(); x <= chunkStartPos.getX() + 15; ++x) {
            for (int z = chunkStartPos.getZ(); z <= chunkStartPos.getZ() + 15; ++z) {
                BPos pos = SpawnPoint.getOverworldRespawnPos(terrainGenerator, x, z);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private static BPos getOverworldRespawnPos(OverworldTerrainGenerator terrainGenerator, int x, int z) {
        Biome biome = terrainGenerator.getBiomeSource().getBiome(x, 0, z);
        if (!SPAWN_BLOCKS.contains(biome.getSurfaceConfig().getTopBlock())) {
            return null;
        }
        int y = terrainGenerator.getFirstHeightInColumn(x, z, TerrainGenerator.OCEAN_FLOOR_WG) - 1;
        if (y < 0) {
            return null;
        }
        Block[] column = terrainGenerator.getColumnAt(x, z);
        for (int posY = y + 1; posY >= 0; --posY) {
            if (column[posY] != Blocks.STONE) continue;
            return new BPos(x, posY + 1, z);
        }
        return null;
    }

    private static boolean isValidPos(OverworldBiomeSource source, OverworldTerrainGenerator generator, int x, int z, boolean trueSpawn) {
        if (!trueSpawn) {
            return SpawnPoint.getGrassStats(source.getBiome(x, 0, z)) >= 0.5;
        }
        return SpawnPoint.getBlockAboveSeaLevel(generator, x, z) == Blocks.GRASS_BLOCK;
    }

    public static Block getBlockAboveSeaLevel(OverworldTerrainGenerator generator, int x, int z) {
        int y;
        Block[] column = generator.getColumnAt(x, z);
        for (y = generator.getSeaLevel() + 1; y < column.length && column[y] != Blocks.AIR; ++y) {
        }
        return column[y - 1];
    }

    private static long getWorldSeed(OverworldBiomeSource source) {
        return source.getWorldSeed();
    }

    private static MCVersion getVersion(OverworldBiomeSource source) {
        return source.getVersion();
    }

    private static BPos getSpawnPoint12(OverworldBiomeSource source, OverworldTerrainGenerator generator, Collection<Biome> spawnBiomes, boolean trueSpawn) {
        JRand rand = new JRand(SpawnPoint.getWorldSeed(source));
        BPos spawnPos = source.locateBiome12(0, 0, 256, spawnBiomes, rand);
        int x = 8;
        int z = 8;
        if (spawnPos != null) {
            x = spawnPos.getX();
            z = spawnPos.getZ();
        }
        int counter = 0;
        while (!SpawnPoint.isValidPos(source, generator, x, z, trueSpawn)) {
            x += rand.nextInt(64) - rand.nextInt(64);
            z += rand.nextInt(64) - rand.nextInt(64);
            if (++counter != 1000) continue;
        }
        return new BPos(x, 64, z);
    }

    private static double getGrassStats(Biome biome) {
        if (Biomes.PLAINS.equals(biome)) {
            return 1.0;
        }
        if (Biomes.MOUNTAINS.equals(biome)) {
            return 0.8;
        }
        if (Biomes.FOREST.equals(biome)) {
            return 1.0;
        }
        if (Biomes.TAIGA.equals(biome)) {
            return 1.0;
        }
        if (Biomes.SWAMP.equals(biome)) {
            return 0.6;
        }
        if (Biomes.RIVER.equals(biome)) {
            return 0.2;
        }
        if (Biomes.BEACH.equals(biome)) {
            return 0.1;
        }
        if (Biomes.WOODED_HILLS.equals(biome)) {
            return 1.0;
        }
        if (Biomes.TAIGA_HILLS.equals(biome)) {
            return 1.0;
        }
        if (Biomes.MOUNTAIN_EDGE.equals(biome)) {
            return 1.0;
        }
        if (Biomes.JUNGLE.equals(biome)) {
            return 1.0;
        }
        if (Biomes.JUNGLE_HILLS.equals(biome)) {
            return 1.0;
        }
        if (Biomes.JUNGLE_EDGE.equals(biome)) {
            return 1.0;
        }
        if (Biomes.BIRCH_FOREST.equals(biome)) {
            return 1.0;
        }
        if (Biomes.BIRCH_FOREST_HILLS.equals(biome)) {
            return 1.0;
        }
        if (Biomes.DARK_FOREST.equals(biome)) {
            return 0.9;
        }
        if (Biomes.SNOWY_TAIGA.equals(biome)) {
            return 0.1;
        }
        if (Biomes.SNOWY_TAIGA_HILLS.equals(biome)) {
            return 0.1;
        }
        if (Biomes.GIANT_TREE_TAIGA.equals(biome)) {
            return 0.6;
        }
        if (Biomes.GIANT_TREE_TAIGA_HILLS.equals(biome)) {
            return 0.6;
        }
        if (Biomes.MODIFIED_GRAVELLY_MOUNTAINS.equals(biome)) {
            return 0.2;
        }
        if (Biomes.SAVANNA.equals(biome)) {
            return 1.0;
        }
        if (Biomes.SAVANNA_PLATEAU.equals(biome)) {
            return 1.0;
        }
        if (Biomes.BADLANDS.equals(biome)) {
            return 0.1;
        }
        if (Biomes.BADLANDS_PLATEAU.equals(biome)) {
            return 0.1;
        }
        return 0.0;
    }

    @Override
    public String getName() {
        return SpawnPoint.name();
    }

    @Override
    public boolean canStart(Data data, long structureSeed, ChunkRand rand) {
        throw new UnsupportedOperationException("Spawn depends on biomes!");
    }

    @Override
    public boolean canSpawn(Data data, BiomeSource source) {
        GenerationContext.Context context;
        if (source instanceof OverworldBiomeSource && (context = this.getContext(source.getWorldSeed())).getGenerator() != null) {
            BPos spawn = this.getSpawnPoint((OverworldTerrainGenerator)context.getGenerator());
            return data.blockX == spawn.getX() && data.blockZ == spawn.getZ();
        }
        return false;
    }

    @Override
    public boolean canGenerate(Data data, TerrainGenerator generator) {
        return true;
    }

    @Override
    public Dimension getValidDimension() {
        return Dimension.OVERWORLD;
    }

    public static class Data
    extends Feature.Data<SpawnPoint> {
        public final int blockX;
        public final int blockZ;

        public Data(SpawnPoint feature, int blockX, int blockZ) {
            super(feature, blockX >> 4, blockZ >> 4);
            this.blockX = blockX;
            this.blockZ = blockZ;
        }
    }
}

