/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class ModCodecs {
    public static final Codec<class_2338> BLOCK_POS_STRING = Codec.STRING.comapFlatMap(s -> {
        String[] split = s.split(",");
        if (split.length == 3) {
            try {
                int x = Integer.parseInt(split[0]);
                int y = Integer.parseInt(split[1]);
                int z = Integer.parseInt(split[2]);
                return DataResult.success((Object)new class_2338(x, y, z));
            }
            catch (NumberFormatException ex) {
                return DataResult.error(() -> "Invalid integer in key");
            }
        }
        return DataResult.error(() -> "Invalid number of coordinates: " + split.length);
    }, pos -> "%d,%d,%d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    public static final Codec<class_1799> ITEM_STACK_IGNORE_COUNT = class_5699.method_33817((Codec)Codec.pair((Codec)class_7923.field_41178.method_39673().fieldOf("id").codec(), (Codec)class_2487.field_25128.fieldOf("tag").codec()), (Codec)class_7923.field_41178.method_39673()).xmap(ModCodecs::decodeEitherItemStack, stack -> stack.method_7985() ? Either.left((Object)Pair.of((Object)stack.method_7909(), (Object)stack.method_7969())) : Either.right((Object)stack.method_7909()));
    public static final Codec<class_1799> OPTIONAL_ITEM_STACK = ModCodecs.optionalEmptyMap(class_1799.field_24671).xmap(optional -> optional.orElse(class_1799.field_8037), itemStack -> itemStack.method_7960() ? Optional.empty() : Optional.of(itemStack));

    private static class_1799 decodeEitherItemStack(Either<Pair<class_1792, class_2487>, class_1792> either) {
        if (either.left().isPresent()) {
            Pair pair = (Pair)either.left().get();
            class_1799 stack = new class_1799((class_1935)pair.getFirst());
            stack.method_7980((class_2487)pair.getSecond());
            return stack;
        }
        return new class_1799((class_1935)either.right().orElseThrow());
    }

    public static <T> Codec<T> singular(Codec<T> typeCodec, T value) {
        return JFLCodecs.oneOf(typeCodec, Collections.singleton(value));
    }

    public static <T> Codec<Set<T>> set(Codec<T> base) {
        return base.listOf().xmap(Set::copyOf, List::copyOf);
    }

    public static <A> Codec<Optional<A>> optionalEmptyMap(final Codec<A> codec) {
        return new Codec<Optional<A>>(){

            public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> dynamicOps, T object) {
                return 1.isEmptyMap(dynamicOps, object) ? DataResult.success((Object)Pair.of(Optional.empty(), object)) : codec.decode(dynamicOps, object).map(pair -> pair.mapFirst(Optional::of));
            }

            private static <T> boolean isEmptyMap(DynamicOps<T> ops, T value) {
                Optional optional = ops.getMap(value).result();
                return optional.isPresent() && ((MapLike)optional.get()).entries().findAny().isEmpty();
            }

            public <T> DataResult<T> encode(Optional<A> input, DynamicOps<T> ops, T value) {
                return input.isEmpty() ? DataResult.success((Object)ops.emptyMap()) : codec.encode(input.get(), ops, value);
            }
        };
    }
}

