/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.FileBasedBackend;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class NbtBackend
extends FileBasedBackend {
    private static final Logger LOGGER = LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/NBT"));

    @Override
    @Nullable
    public MemoryBankImpl load(String id) {
        Optional<Metadata> meta = this.loadMetadata(id);
        if (meta.isEmpty()) {
            return null;
        }
        Path path = Constants.STORAGE_DIR.resolve(id + this.extension());
        Pair<Optional, Long> result = Misc.time(() -> FileUtil.loadFromNbt(MemoryBankImpl.DATA_CODEC, path));
        if (((Optional)result.getFirst()).isPresent()) {
            LOGGER.debug("Loaded {} in {}ns", (Object)path, result.getSecond());
            return new MemoryBankImpl(meta.get(), (Map)((Optional)result.getFirst()).get());
        }
        return new MemoryBankImpl(meta.get(), new HashMap<class_2960, MemoryKeyImpl>());
    }

    @Override
    public boolean save(MemoryBankImpl memoryBank) {
        LOGGER.debug("Saving {}", (Object)memoryBank.getId());
        memoryBank.getMetadata().updateModified();
        if (!this.saveMetadata(memoryBank.getId(), memoryBank.getMetadata())) {
            return false;
        }
        return FileUtil.saveToNbt(memoryBank.getMemories(), MemoryBankImpl.DATA_CODEC, Constants.STORAGE_DIR.resolve(memoryBank.getId() + this.extension()));
    }

    @Override
    public String extension() {
        return ".nbt";
    }
}

