/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory;

import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.memory.MemoryBank;
import red.jackf.chesttracker.api.memory.MemoryBankAccess;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.ConnectionSettings;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.jackfredlib.client.api.gps.Coordinate;

@Environment(value=EnvType.CLIENT)
public class MemoryBankAccessImpl
implements MemoryBankAccess {
    public static final MemoryBankAccessImpl INSTANCE = new MemoryBankAccessImpl();
    @Nullable
    private static MemoryBankImpl loaded = null;

    private MemoryBankAccessImpl() {
    }

    @Override
    public boolean loadOrCreate(String memoryBankId, String creationName) {
        INSTANCE.unload();
        loaded = Storage.load(memoryBankId).orElseGet(() -> {
            MemoryBankImpl bank = new MemoryBankImpl(Metadata.blankWithName(creationName), new HashMap<class_2960, MemoryKeyImpl>());
            bank.setId(memoryBankId);
            return bank;
        });
        INSTANCE.save();
        return true;
    }

    @Override
    public boolean unload() {
        if (loaded == null) {
            return false;
        }
        this.save();
        loaded = null;
        return true;
    }

    @Override
    public Optional<MemoryBank> getLoaded() {
        return Optional.ofNullable(loaded);
    }

    public Optional<MemoryBankImpl> getLoadedInternal() {
        return Optional.ofNullable(loaded);
    }

    public void save() {
        if (loaded == null) {
            return;
        }
        Storage.save(loaded);
    }

    @Override
    public boolean loadWithDefaults(Coordinate coordinate) {
        ConnectionSettings settings = ConnectionSettings.getOrCreate(coordinate.id());
        String id = settings.memoryBankIdOverride().orElse(coordinate.id());
        return this.loadOrCreate(id, coordinate.userFriendlyName());
    }
}

