/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton.ui;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_465;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.gui.ScreenBlacklist;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.invbutton.ButtonPositionMap;
import red.jackf.chesttracker.impl.gui.invbutton.PositionExporter;
import red.jackf.chesttracker.impl.gui.invbutton.position.ButtonPosition;
import red.jackf.chesttracker.impl.gui.invbutton.position.PositionUtils;
import red.jackf.chesttracker.impl.gui.invbutton.position.RectangleUtils;
import red.jackf.chesttracker.impl.gui.invbutton.ui.RememberContainerButton;
import red.jackf.chesttracker.impl.gui.invbutton.ui.RenameButton;
import red.jackf.chesttracker.impl.gui.invbutton.ui.SecondaryButton;
import red.jackf.chesttracker.impl.gui.util.SpriteSet;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.util.GuiUtil;

@Environment(value=EnvType.CLIENT)
public class InventoryButton
extends class_339 {
    private static final SpriteSet TEXTURE = GuiUtil.twoSprite("inventory_button/button");
    static final int Z_OFFSET = 400;
    private static final int MS_BEFORE_DRAG_START = 200;
    private static final int EXPANDED_HOVER_INFLATE = 5;
    private static final int EXTRA_BUTTON_SPACING = 3;
    public static final int SIZE = 9;
    protected static final int IMAGE_SIZE = 11;
    @Nullable
    private static Pair<class_465<?>, MemoryLocation> locationToRestore = null;
    private final class_465<?> parent;
    private ButtonPosition lastPosition;
    private ButtonPosition position;
    private boolean lastRecipeBookVisible;
    private boolean canDrag = false;
    private long mouseDownStart = -1L;
    private boolean isDragging = false;
    private final List<SecondaryButton> secondaryButtons = new ArrayList<SecondaryButton>();
    private class_8030 expandedHoverArea = class_8030.method_48248();

    public InventoryButton(class_465<?> parent, ButtonPosition position, Optional<MemoryLocation> target) {
        super(position.getX(parent), position.getY(parent), 9, 9, (class_2561)class_2561.method_43471((String)"chesttracker.title"));
        this.parent = parent;
        this.position = position;
        this.lastPosition = position;
        this.lastRecipeBookVisible = PositionUtils.isRecipeBookVisible(parent);
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.title")));
        if (locationToRestore != null) {
            if (locationToRestore.getFirst() == parent) {
                target = Optional.of((MemoryLocation)locationToRestore.getSecond());
            }
            locationToRestore = null;
        }
        if (!ScreenBlacklist.isBlacklisted(parent.getClass()) && MemoryBankAccessImpl.INSTANCE.getLoadedInternal().isPresent()) {
            MemoryBankImpl bank = MemoryBankAccessImpl.INSTANCE.getLoadedInternal().get();
            if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.showExtra && target.isPresent()) {
                MemoryLocation location = target.get();
                this.secondaryButtons.add(new RememberContainerButton(bank, location));
                this.secondaryButtons.add(new RenameButton(parent, bank, location));
            }
        }
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.showExport) {
            this.secondaryButtons.add(new SecondaryButton(GuiUtil.twoSprite("inventory_button/export"), (class_2561)class_2561.method_43471((String)"chesttracker.inventoryButton.export"), () -> PositionExporter.export(this.parent, this.position)));
        }
        for (int i = 0; i < this.secondaryButtons.size(); ++i) {
            this.secondaryButtons.get(i).setButtonIndex(i + 1);
        }
        this.applyPosition(true);
    }

    protected static void setRestoreLocation(class_465<?> screen, MemoryLocation location) {
        locationToRestore = Pair.of(screen, (Object)location);
    }

    private static boolean alwaysShowExtra() {
        return ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.inventoryButton.alwaysShowExtra;
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isDragging) {
            this.applyPosition(false);
            this.showExtraButtons(InventoryButton.alwaysShowExtra() || this.method_49606() || this.isExpandedHover(mouseX, mouseY));
        } else {
            this.showExtraButtons(false);
        }
        class_2960 texture = TEXTURE.get(this.method_37303(), this.method_25367());
        GuiUtil.blit(graphics, texture, this.method_46426() - 1, this.method_46427() - 1, 400, 11, 11);
        for (class_339 class_3392 : this.secondaryButtons) {
            class_3392.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    private boolean isExpandedHover(int mouseX, int mouseY) {
        return this.expandedHoverArea.method_48252(new class_8030(mouseX, mouseY, 1, 1));
    }

    private void applyPosition(boolean force) {
        boolean isRecipeBookVisible = PositionUtils.isRecipeBookVisible(this.parent);
        if (!force && this.position.equals(this.lastPosition) && isRecipeBookVisible == this.lastRecipeBookVisible) {
            return;
        }
        this.lastPosition = this.position;
        this.lastRecipeBookVisible = isRecipeBookVisible;
        this.method_48229(this.position.getX(this.parent), this.position.getY(this.parent));
        Set<class_8030> colliders = RectangleUtils.getCollidersFor(this.parent);
        class_8028 freeDir = class_8028.field_41829;
        for (class_8028 dir : List.of(class_8028.field_41829, class_8028.field_41828, class_8028.field_41827, class_8028.field_41826)) {
            class_8030 rect = this.rectangleFor(dir);
            if (!RectangleUtils.isFree(rect, colliders, this.parent.method_48202())) continue;
            freeDir = dir;
            break;
        }
        for (int i = 1; i <= this.secondaryButtons.size(); ++i) {
            class_8030 pos = RectangleUtils.step(this.method_48202(), freeDir, 12 * i);
            this.secondaryButtons.get(i - 1).method_48229(pos.method_49620(), pos.method_49618());
        }
    }

    private class_8030 rectangleFor(class_8028 dir) {
        ArrayList<class_8030> boxes = new ArrayList<class_8030>();
        boxes.add(this.method_48202());
        for (int i = 1; i <= this.secondaryButtons.size(); ++i) {
            boxes.add(RectangleUtils.step(this.method_48202(), dir, 12 * i));
        }
        return RectangleUtils.encompassing(boxes);
    }

    private void showExtraButtons(boolean shouldShow) {
        for (SecondaryButton secondary : this.secondaryButtons) {
            secondary.setVisible(shouldShow, this.method_46426(), this.method_46427());
        }
        if (shouldShow) {
            class_8030 encompassing = RectangleUtils.encompassing(Stream.concat(Stream.of(this.method_48202()), this.secondaryButtons.stream().map(class_339::method_48202)).toList());
            this.expandedHoverArea = RectangleUtils.inflate(encompassing, 5);
        } else {
            this.expandedHoverArea = class_8030.method_48248();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.canDrag = true;
            this.mouseDownStart = class_156.method_658();
        }
        for (class_339 class_3392 : this.secondaryButtons) {
            if (!class_3392.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.canDrag && class_156.method_658() - this.mouseDownStart >= 200L) {
            this.isDragging = true;
            Optional<ButtonPosition> newPos = PositionUtils.calculate(this.parent, (int)mouseX, (int)mouseY);
            if (newPos.isPresent()) {
                this.position = newPos.get();
                this.applyPosition(false);
                this.method_47400(null);
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.canDrag = false;
        this.mouseDownStart = -1L;
        if (this.isDragging) {
            this.isDragging = false;
            ButtonPositionMap.saveUserPosition(this.parent, this.position);
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.title")));
            return true;
        }
        if (this.method_25405(mouseX, mouseY)) {
            ChestTracker.openInGame(class_310.method_1551(), this.parent);
            return true;
        }
        return false;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }
}

