/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton.position;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_8028;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import red.jackf.chesttracker.impl.gui.invbutton.CTButtonScreenDuck;
import red.jackf.chesttracker.impl.gui.invbutton.position.PositionUtils;

@Environment(value=EnvType.CLIENT)
public interface RectangleUtils {
    public static final int LIMIT = 100;
    public static final int GUI_BORDER_EXTENSION = 8;
    public static final int GUI_PADDING = 4;
    public static final int GUI_MARGIN = 2;
    public static final int SLOT_MARGIN = 2;
    public static final int SCREEN_MARGIN = 2;

    public static class_8030 encompassing(List<class_8030> rectangles) {
        if (rectangles.isEmpty()) {
            return class_8030.method_48248();
        }
        if (rectangles.size() == 1) {
            return rectangles.get(0);
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (class_8030 rect : rectangles) {
            minX = Math.min(minX, rect.method_49620());
            maxX = Math.max(maxX, rect.method_49621());
            minY = Math.min(minY, rect.method_49618());
            maxY = Math.max(maxY, rect.method_49619());
        }
        return new class_8030(minX, minY, maxX - minX, maxY - minY);
    }

    public static class_8030 inflate(class_8030 rectangle, int amount) {
        return new class_8030(rectangle.method_49620() - amount, rectangle.method_49618() - amount, rectangle.comp_1196() + 2 * amount, rectangle.comp_1197() + 2 * amount);
    }

    public static Set<class_8030> getCollidersFor(class_465<?> screen) {
        int width = ((CTButtonScreenDuck)screen).chesttracker$getWidth();
        int recipeWidth = PositionUtils.getRecipeComponentWidth(screen);
        int height = ((CTButtonScreenDuck)screen).chesttracker$getHeight();
        int left = ((CTButtonScreenDuck)screen).chesttracker$getLeft();
        int top = ((CTButtonScreenDuck)screen).chesttracker$getTop();
        int twiceMargin = 4;
        int twiceBorderExt = 16;
        HashSet<class_8030> colliders = new HashSet<class_8030>();
        colliders.add(new class_8030(left - 2 - 8, top - 2, width + 4 + 16, 6));
        colliders.add(new class_8030(left - 2 - 8, top + height - 4, width + 4 + 16, 6));
        colliders.add(new class_8030(left - 2, top - 2 - 8, 6, height + 4 + 16));
        colliders.add(new class_8030(left + width - 4, top - 2 - 8, 6, height + 4 + 16));
        class_507 recipe = PositionUtils.getVisibleRecipe(screen);
        if (recipe != null) {
            colliders.add(new class_8030(left - recipeWidth - 2, top - 2, recipeWidth + 4, height + 4));
        }
        for (class_1735 slot : screen.method_17577().field_7761) {
            colliders.add(RectangleUtils.inflate(new class_8030(left + slot.field_7873, top + slot.field_7872, 16, 16), 2));
        }
        return colliders;
    }

    public static class_8030 tryPlaceWithin(class_8030 toMove, class_8030 border) {
        if (toMove.comp_1196() <= border.comp_1196()) {
            if (toMove.method_49621() > border.method_49621()) {
                toMove = new class_8030(border.method_49621() - toMove.comp_1196(), toMove.method_49618(), toMove.comp_1196(), toMove.comp_1197());
            } else if (toMove.method_49620() < border.method_49620()) {
                toMove = new class_8030(border.method_49620(), toMove.method_49618(), toMove.comp_1196(), toMove.comp_1197());
            }
        }
        if (toMove.comp_1197() <= border.comp_1197()) {
            if (toMove.method_49619() > border.method_49619()) {
                toMove = new class_8030(toMove.method_49620(), border.method_49619() - toMove.comp_1197(), toMove.comp_1196(), toMove.comp_1197());
            } else if (toMove.method_49618() < border.method_49618()) {
                toMove = new class_8030(toMove.method_49620(), border.method_49618(), toMove.comp_1196(), toMove.comp_1197());
            }
        }
        return toMove;
    }

    public static Optional<class_8030> adjust(class_8030 start, Set<class_8030> colliders, class_8030 border) {
        if (RectangleUtils.isFree(start = RectangleUtils.tryPlaceWithin(start, border), colliders, border)) {
            return Optional.of(start);
        }
        for (int i = 0; i < 100; ++i) {
            for (class_8029 pos : RectangleUtils.getPositionsAtRadius(start.comp_1195(), i)) {
                class_8030 rect = new class_8030(pos, start.comp_1196(), start.comp_1197());
                if (!RectangleUtils.isFree(rect, colliders, border)) continue;
                return Optional.of(rect);
            }
        }
        return Optional.empty();
    }

    public static boolean isFree(class_8030 start, Set<class_8030> colliders, class_8030 border) {
        if (start.method_49620() < border.method_49620() || start.method_49621() > border.method_49621() || start.method_49618() < border.method_49618() || start.method_49619() > border.method_49619()) {
            return false;
        }
        for (class_8030 collider : colliders) {
            if (!start.method_48252(collider)) continue;
            return false;
        }
        return true;
    }

    public static class_8030 step(class_8030 start, class_8028 dir, int amount) {
        class_8029 pos = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_8028.field_41826 -> new class_8029(start.comp_1195().comp_1193(), start.comp_1195().comp_1194() - amount);
            case class_8028.field_41827 -> new class_8029(start.comp_1195().comp_1193(), start.comp_1195().comp_1194() + amount);
            case class_8028.field_41828 -> new class_8029(start.comp_1195().comp_1193() - amount, start.comp_1195().comp_1194());
            case class_8028.field_41829 -> new class_8029(start.comp_1195().comp_1193() + amount, start.comp_1195().comp_1194());
        };
        return new class_8030(pos, start.comp_1196(), start.comp_1197());
    }

    private static class_8029 stepOrthogonal(class_8029 start, class_8028 dir, int amount, int orthAmount) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_8028.field_41826 -> new class_8029(start.comp_1193() + orthAmount, start.comp_1194() - amount);
            case class_8028.field_41827 -> new class_8029(start.comp_1193() - orthAmount, start.comp_1194() + amount);
            case class_8028.field_41828 -> new class_8029(start.comp_1193() - amount, start.comp_1194() - orthAmount);
            case class_8028.field_41829 -> new class_8029(start.comp_1193() + amount, start.comp_1194() + orthAmount);
        };
    }

    private static Iterable<class_8029> getPositionsAtRadius(class_8029 origin, int radius) {
        ArrayList<class_8029> list = new ArrayList<class_8029>(8 * radius);
        for (int i = 0; i < radius; ++i) {
            for (class_8028 dir : class_8028.values()) {
                list.add(RectangleUtils.stepOrthogonal(origin, dir, radius, i));
                list.add(RectangleUtils.stepOrthogonal(origin, dir, radius, -1 - i));
            }
        }
        return list;
    }
}

