/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.config.custom;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ActionController;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import red.jackf.chesttracker.impl.config.custom.HoldToConfirmButtonOption;

@Environment(value=EnvType.CLIENT)
public class HoldToConfirmActionController
implements Controller<BiConsumer<YACLScreen, HoldToConfirmButtonOption>> {
    private final HoldToConfirmButtonOption option;
    private final class_2561 text;

    public HoldToConfirmActionController(HoldToConfirmButtonOption option) {
        this(option, ActionController.DEFAULT_TEXT);
    }

    public HoldToConfirmActionController(HoldToConfirmButtonOption option, class_2561 text) {
        this.option = option;
        this.text = text;
    }

    public HoldToConfirmButtonOption option() {
        return this.option;
    }

    public class_2561 formatValue() {
        return this.text;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new Widget(this, screen, widgetDimension, this.option.holdTime());
    }

    @Environment(value=EnvType.CLIENT)
    public static class Widget
    extends ControllerWidget<HoldToConfirmActionController> {
        public static final float REGRESSION_MULTIPLIER = 2.0f;
        public static final int PROGRESS_COLOUR = 0x40FF0000;
        private final String buttonString;
        private final long holdTime;
        private final Set<Integer> held = new HashSet<Integer>(4);
        private float progress = 0.0f;

        public Widget(HoldToConfirmActionController control, YACLScreen screen, Dimension<Integer> dim, long holdTime) {
            super((Controller)control, screen, dim);
            this.buttonString = control.formatValue().getString().toLowerCase();
            this.holdTime = holdTime;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            if (this.progress > 0.0f) {
                graphics.method_25294((Integer)this.getDimension().x() + 1, (Integer)this.getDimension().y() + 1, (int)((float)((Integer)this.getDimension().x()).intValue() + this.progress / (float)this.holdTime * (float)((Integer)this.getDimension().width() - 2)), (Integer)this.getDimension().yLimit() - 1, 0x40FF0000);
            }
            if (!this.held.isEmpty()) {
                this.progress = Math.min((float)this.holdTime, this.progress + delta);
                if (this.progress == (float)this.holdTime) {
                    this.executeAction();
                    this.progress = 0.0f;
                }
            } else {
                this.progress = Math.max(0.0f, this.progress - 2.0f * delta);
            }
            if (!this.isAvailable()) {
                this.held.clear();
            }
            if (this.held.contains(-1) && !this.method_25405(mouseX, mouseY)) {
                this.held.remove(-1);
            }
        }

        public void executeAction() {
            this.playDownSound();
            ((HoldToConfirmActionController)this.control).option().action().accept(this.screen, ((HoldToConfirmActionController)this.control).option());
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY) && this.isAvailable()) {
                this.playDownSound();
                this.held.add(-1);
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            this.held.remove(-1);
            return super.method_25406(mouseX, mouseY, button);
        }

        public void method_16014(double mouseX, double mouseY) {
            if (this.isAvailable() && !this.method_25405(mouseX, mouseY)) {
                this.held.remove(-1);
            }
            super.method_16014(mouseX, mouseY);
        }

        private static boolean isActivationKeybind(int keyCode) {
            return keyCode == 257 || keyCode == 32 || keyCode == 335;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.focused) {
                return false;
            }
            if (Widget.isActivationKeybind(keyCode)) {
                if (this.held.isEmpty()) {
                    this.playDownSound();
                }
                this.held.add(keyCode);
                return true;
            }
            return false;
        }

        public boolean method_16803(int keyCode, int scanCode, int modifiers) {
            if (Widget.isActivationKeybind(keyCode)) {
                this.held.remove(keyCode);
            }
            return super.method_16803(keyCode, scanCode, modifiers);
        }

        public void unfocus() {
            super.unfocus();
            this.held.clear();
        }

        protected int getHoveredControlWidth() {
            return this.getUnhoveredControlWidth();
        }

        public boolean canReset() {
            return false;
        }

        public boolean matchesSearch(String query) {
            return super.matchesSearch(query) || this.buttonString.contains(query);
        }
    }
}

