/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.api.memory;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.util.Misc;
import red.jackf.chesttracker.impl.util.ModCodecs;

@Environment(value=EnvType.CLIENT)
public final class Memory {
    public static final Instant UNKNOWN_REAL_TIMESTAMP = Instant.EPOCH;
    public static final long UNKNOWN_WORLD_TIMESTAMP = -437821L;
    public static final long UNKNOWN_LOADED_TIMESTAMP = -437822L;
    public static final Codec<Memory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.OPTIONAL_ITEM_STACK.listOf().fieldOf("items").forGetter(Memory::fullItems), (App)class_5699.field_40722.optionalFieldOf("name").forGetter(m -> Optional.ofNullable(m.name)), (App)ModCodecs.BLOCK_POS_STRING.listOf().optionalFieldOf("otherPositions", Collections.emptyList()).forGetter(Memory::otherPositions), (App)class_7923.field_41175.method_39673().optionalFieldOf("container").forGetter(Memory::container), (App)Codec.LONG.optionalFieldOf("loadedTimestamp", (Object)-437822L).forGetter(Memory::loadedTimestamp), (App)Codec.LONG.optionalFieldOf("worldTimestamp", (Object)-437821L).forGetter(Memory::inGameTimestamp), (App)class_5699.field_39042.optionalFieldOf("realTimestamp", (Object)UNKNOWN_REAL_TIMESTAMP).forGetter(Memory::realTimestamp)).apply((Applicative)instance, (items, name, otherPositions, container, loadedTimestamp, worldTimestamp, realTimestamp) -> new Memory((List<class_1799>)items, name.orElse(null), (List<class_2338>)otherPositions, (Optional<class_2248>)container, (long)loadedTimestamp, (long)worldTimestamp, (Instant)realTimestamp)));
    private final List<class_1799> fullItems;
    private final List<class_1799> items;
    @Nullable
    private final class_2561 name;
    private final List<class_2338> otherPositions;
    private final Optional<class_2248> container;
    private Long loadedTimestamp;
    private Long inGameTimestamp;
    private Instant realTimestamp;
    @ApiStatus.Internal
    private MemoryKeyImpl memoryKey = null;
    @ApiStatus.Internal
    private class_2338 position = null;

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public List<class_1799> items() {
        return this.items;
    }

    public List<class_1799> fullItems() {
        return this.fullItems;
    }

    @Nullable
    public class_2561 renderName() {
        class_2561 filtered;
        if (this.memoryKey == null) {
            return null;
        }
        OverrideInfo overrideInfo = this.memoryKey.overrides().get(this.position);
        if (overrideInfo != null && overrideInfo.getCustomName() != null) {
            return class_2561.method_43470((String)overrideInfo.getCustomName());
        }
        if (this.name != null && !(filtered = (class_2561)this.memoryKey.getMemoryBank().getMetadata().getCompatibilitySettings().nameFilterMode.filter.apply(this.name)).getString().isBlank()) {
            return filtered;
        }
        return null;
    }

    @Nullable
    public class_2561 savedName() {
        return this.name;
    }

    public boolean hasCustomName() {
        if (this.name != null) {
            return true;
        }
        OverrideInfo override = this.memoryKey.overrides().get(this.position);
        return override != null && override.getCustomName() != null;
    }

    public List<class_2338> otherPositions() {
        return this.otherPositions;
    }

    public class_243 getCenterPosition() {
        return Misc.getAverageOffsetFrom(this.position, this.otherPositions()).method_1019(this.position.method_46558());
    }

    public Optional<class_2248> container() {
        return this.container;
    }

    public void touch(long memoryBankLoadedTime, long inGameTime) {
        this.loadedTimestamp = memoryBankLoadedTime;
        this.inGameTimestamp = inGameTime;
        this.realTimestamp = Instant.now();
    }

    public Long loadedTimestamp() {
        return this.loadedTimestamp;
    }

    public Long inGameTimestamp() {
        return this.inGameTimestamp;
    }

    public Instant realTimestamp() {
        return this.realTimestamp;
    }

    @ApiStatus.Internal
    public Memory(List<class_1799> items, @Nullable class_2561 name, List<class_2338> otherPositions, Optional<class_2248> container, long loadedTimestamp, long inGameTimestamp, Instant realTimestamp) {
        this.fullItems = ImmutableList.copyOf(items);
        this.items = this.fullItems.stream().filter(stack -> !stack.method_7960()).toList();
        this.name = name;
        this.otherPositions = ImmutableList.copyOf(otherPositions);
        this.loadedTimestamp = loadedTimestamp;
        this.inGameTimestamp = inGameTimestamp;
        this.realTimestamp = realTimestamp;
        this.container = container;
    }

    public void populate(MemoryKeyImpl key, class_2338 pos) {
        this.memoryKey = key;
        this.position = pos;
    }
}

