/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.ported.inventory;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientScreenHandler;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InputOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.StringInput;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import tsp.headdb.ported.Category;
import tsp.headdb.ported.Head;
import tsp.headdb.ported.HeadAPI;
import tsp.headdb.ported.LocalHead;
import tsp.headdb.ported.Utils;
import tsp.headdb.ported.inventory.Button;
import tsp.headdb.ported.inventory.ClickTypeMod;
import tsp.headdb.ported.inventory.PagedPane;

public class InventoryUtils {
    private static final Map<String, Integer> uiLocation = new HashMap<String, Integer>();
    private static final Map<String, class_1799> uiItem = new HashMap<String, class_1799>();

    public static int getUILocation(String category, int slot) {
        if (uiLocation.containsKey(category)) {
            return uiLocation.get(category);
        }
        uiLocation.put(category, slot);
        return slot;
    }

    public static class_1799 getUIItem(String category, class_1799 item) {
        if (uiItem.containsKey(category)) {
            return uiItem.get(category);
        }
        uiItem.put(category, item);
        return item;
    }

    public static void openLocalMenu() {
        PagedPane pane = new PagedPane(4, 6, Utils.colorize("&c&lHeadDB &8- &aLocal Heads"));
        List<LocalHead> heads = HeadAPI.getLocalHeads();
        for (LocalHead localHead : heads) {
            pane.addButton(new Button(localHead.getItemStack(), e -> {
                if (e.getClickType() == ClickTypeMod.LEFT_SHIFT) {
                    InventoryUtils.purchaseHead(localHead, 64, "local", localHead.getName());
                    return;
                }
                if (e.getClickType() == ClickTypeMod.LEFT) {
                    InventoryUtils.purchaseHead(localHead, 1, "local", localHead.getName());
                    return;
                }
                if (e.getClickType() == ClickTypeMod.RIGHT) {
                    Utils.sendMessage("&cLocal heads can not be added to favorites!");
                }
            }));
        }
        pane.open();
    }

    public static void openFavoritesMenu() {
        PagedPane pane = new PagedPane(4, 6, Utils.colorize("&c&lHeadDB &8- &eFavorites"));
        List<Head> heads = HeadAPI.getFavoriteHeads();
        for (Head head : heads) {
            pane.addButton(new Button(head.getItemStack(), e -> {
                if (e.getClickType() == ClickTypeMod.LEFT_SHIFT) {
                    InventoryUtils.purchaseHead(head, 64, head.getCategory().getName(), head.getName());
                    return;
                }
                if (e.getClickType() == ClickTypeMod.LEFT) {
                    InventoryUtils.purchaseHead(head, 1, head.getCategory().getName(), head.getName());
                }
                if (e.getClickType() == ClickTypeMod.RIGHT) {
                    HeadAPI.removeFavoriteHead(head.getValue());
                    InventoryUtils.openFavoritesMenu();
                    Utils.sendMessage("Removed &e" + head.getName() + " &7from favorites.");
                }
            }));
        }
        pane.open();
    }

    public static PagedPane openSearchDatabase(String search) {
        PagedPane pane = new PagedPane(4, 6, Utils.colorize("&c&lHeadDB &8- &eSearch: " + search));
        List<Head> heads = HeadAPI.getHeadsByName(search);
        for (Head head : heads) {
            pane.addButton(InventoryUtils.genButton(head));
        }
        pane.open();
        return pane;
    }

    public static void openTagSearchDatabase(String tag) {
        PagedPane pane = new PagedPane(4, 6, Utils.colorize("&c&lHeadDB &8- &eTag Search: " + tag));
        List<Head> heads = HeadAPI.getHeadsByTag(tag);
        for (Head head : heads) {
            pane.addButton(InventoryUtils.genButton(head));
        }
        pane.open();
    }

    public static void openCategoryDatabase(Category category) {
        PagedPane pane = new PagedPane(4, 6, Utils.colorize("&c&lHeadDB &8- &e" + category.getTranslatedName()));
        List<Head> heads = HeadAPI.getHeads(category);
        for (Head head : heads) {
            pane.addButton(InventoryUtils.genButton(head));
        }
        pane.open();
    }

    private static Button genButton(Head head) {
        return new Button(head.getItemStack(), e -> {
            if (e.getClickType() == ClickTypeMod.LEFT_SHIFT) {
                InventoryUtils.purchaseHead(head, 64, head.getCategory().getName(), head.getName());
            } else if (e.getClickType() == ClickTypeMod.LEFT) {
                InventoryUtils.purchaseHead(head, 1, head.getCategory().getName(), head.getName());
            } else if (e.getClickType() == ClickTypeMod.RIGHT) {
                HeadAPI.toggleFavoriteHead(head);
            }
        });
    }

    public static void openDatabase() {
        ClientHandledScreen screen = new ClientHandledScreen(new ClientScreenHandler(6), TextInst.of(Utils.colorize("&c&lHeadDB &8(" + HeadAPI.getHeads().size() + ")"))){

            @Override
            protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
                class_1799 item;
                if (slot == null) {
                    return;
                }
                slotId = slot.field_7874;
                class_1263 inventory = ((class_1707)this.field_2797).method_7629();
                if (inventory != null && (item = slot.method_7677()) != null && !item.method_7960()) {
                    String name = MainUtil.stripColor(item.method_7964().getString().toLowerCase());
                    if (name.equalsIgnoreCase("favorites")) {
                        InventoryUtils.openFavoritesMenu();
                        return;
                    }
                    if (name.equalsIgnoreCase("local")) {
                        InventoryUtils.openLocalMenu();
                        return;
                    }
                    if (name.equalsIgnoreCase("search")) {
                        InputOverlay.show(TextInst.of("Search"), StringInput.builder().withPlaceholder(TextInst.of("Query")).build(), InventoryUtils::openSearchDatabase);
                        return;
                    }
                    Category category = Category.getByName(name);
                    if (category != null) {
                        HeadAPI.openCategoryDatabase(category);
                    }
                }
            }

            @Override
            public void method_25419() {
                MainUtil.client.field_1724.method_7346();
            }
        };
        class_1263 inventory = ((class_1707)screen.method_17577()).method_7629();
        for (Category category : Category.getValues()) {
            class_1799 item = InventoryUtils.getUIItem(category.getName(), category.getItem());
            item.manager$setCustomName(TextInst.of(Utils.colorize(String.valueOf(category.getColor()) + "&l" + category.getTranslatedName().toUpperCase())));
            ItemTagReferences.LORE.set(item, List.of(TextInst.of(Utils.colorize("&e" + TextInst.translatable("nbteditor.hdb.head_count", HeadAPI.getHeads(category).size()).getString()))));
            inventory.method_5447(InventoryUtils.getUILocation(category.getName(), category.getLocation()), item);
        }
        inventory.method_5447(InventoryUtils.getUILocation("favorites", 39), InventoryUtils.buildButton(InventoryUtils.getUIItem("favorites", new class_1799((class_1935)class_1802.field_8529)), "&eFavorites", "", "&8Click to view your favorites"));
        inventory.method_5447(InventoryUtils.getUILocation("search", 40), InventoryUtils.buildButton(InventoryUtils.getUIItem("search", new class_1799((class_1935)class_1802.field_8496)), "&9Search", "", "&8Click to open search menu"));
        inventory.method_5447(InventoryUtils.getUILocation("local", 41), InventoryUtils.buildButton(InventoryUtils.getUIItem("local", new class_1799((class_1935)class_1802.field_8251)), "&aLocal", "", "&8Online Players"));
        InventoryUtils.fill(inventory);
        MainUtil.client.method_1507((class_437)screen);
    }

    public static void fill(class_1263 inv) {
        class_1799 item = InventoryUtils.getUIItem("fill", new class_1799((class_1935)class_1802.field_8157));
        if (item == null || item.method_7960()) {
            return;
        }
        if (NBTManagers.COMPONENTS_EXIST) {
            item.set(MVComponentType.HIDE_TOOLTIP, (Object)class_3902.field_17274);
        }
        int size = inv.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 slotItem = inv.method_5438(i);
            if (slotItem != null && !slotItem.method_7960()) continue;
            inv.method_5447(i, item);
        }
    }

    private static class_1799 buildButton(class_1799 item, String name, String ... lore) {
        item.manager$setCustomName(TextInst.of(Utils.colorize(name)));
        ItemTagReferences.LORE.set(item, Arrays.stream(lore).map(Utils::colorize).map(TextInst::of).toList());
        return item;
    }

    public static void purchaseHead(Head head, int amount, String category, String description) {
        class_1799 item = head.getItemStack();
        item.method_7939(amount);
        MainUtil.getWithMessage(item);
    }
}

