/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.ported;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import tsp.headdb.ported.Category;
import tsp.headdb.ported.Head;
import tsp.headdb.ported.HeadAPI;
import tsp.headdb.ported.Utils;

public class HeadDatabase {
    private final long refresh;
    private int timeout;
    private final Map<Category, List<Head>> HEADS = new HashMap<Category, List<Head>>();
    private long updated;
    private int id;

    public HeadDatabase() {
        this.refresh = 3600L;
        this.timeout = 5000;
    }

    public HeadDatabase(long refresh) {
        this.refresh = refresh;
        this.timeout = 5000;
    }

    public Head getHeadByValue(String value) {
        List<Head> heads = this.getHeads();
        for (Head head : heads) {
            if (!head.getValue().equals(value)) continue;
            return head;
        }
        return null;
    }

    public Head getHeadByID(int id) {
        List<Head> heads = this.getHeads();
        for (Head head : heads) {
            if (head.getId() != id) continue;
            return head;
        }
        return null;
    }

    public Head getHeadByUniqueId(UUID uuid) {
        List<Head> heads = this.getHeads();
        for (Head head : heads) {
            if (!head.getUniqueId().equals(uuid)) continue;
            return head;
        }
        return null;
    }

    public List<Head> getHeadsByTag(String tag) {
        ArrayList<Head> result = new ArrayList<Head>();
        List<Head> heads = this.getHeads();
        tag = tag.toLowerCase(Locale.ROOT);
        for (Head head : heads) {
            for (String t : head.getTags()) {
                if (!t.toLowerCase(Locale.ROOT).contains(tag)) continue;
                result.add(head);
            }
        }
        return result;
    }

    public List<Head> getHeadsByName(Category category, String name) {
        ArrayList<Head> result = new ArrayList<Head>();
        List<Head> heads = this.getHeads(category);
        for (Head head : heads) {
            String hName = MainUtil.stripColor(head.getName().toLowerCase(Locale.ROOT));
            if (!hName.contains(MainUtil.stripColor(name.toLowerCase(Locale.ROOT)))) continue;
            result.add(head);
        }
        return result;
    }

    public List<Head> getHeadsByName(String name) {
        if (name.startsWith("id:")) {
            try {
                Head head = this.getHeadByID(Integer.parseInt(name.substring(3)));
                if (head != null) {
                    ArrayList<Head> output = new ArrayList<Head>();
                    output.add(head);
                    return output;
                }
            }
            catch (NumberFormatException head) {
                // empty catch block
            }
        }
        ArrayList<Head> result = new ArrayList<Head>();
        for (Category category : Category.values()) {
            result.addAll(this.getHeadsByName(category, name));
        }
        return result;
    }

    public List<Head> getHeads(Category category) {
        return this.HEADS.get((Object)category);
    }

    public List<Head> getHeads() {
        if (!this.HEADS.isEmpty() && !this.isLastUpdateOld()) {
            ArrayList<Head> heads = new ArrayList<Head>();
            for (Category category : this.HEADS.keySet()) {
                heads.addAll((Collection<Head>)this.HEADS.get((Object)category));
            }
            return heads;
        }
        this.update();
        return this.getHeads();
    }

    public List<Category> getCategories() {
        return Collections.unmodifiableList(new ArrayList<Category>(this.HEADS.keySet()));
    }

    public Map<Category, List<Head>> getHeadsNoCache() {
        Category[] categories;
        HashMap<Category, List<Head>> result = new HashMap<Category, List<Head>>();
        for (Category category : categories = Category.getValues()) {
            NBTEditor.LOGGER.debug("Caching heads from: " + category.getName());
            List<Object> heads = new ArrayList();
            try {
                heads = this.gather("https://minecraft-heads.com/scripts/api.php?cat=" + category.getName() + "&tags=true", category);
            }
            catch (JsonParseException | IOException e) {
                NBTEditor.LOGGER.error("Failed to fetch heads (no-cache) | Stack Trace:");
                NBTEditor.LOGGER.error((Object)e);
                NBTEditor.LOGGER.info("Attempting fallback provider for: " + category.getName());
                try {
                    heads = this.gather("https://heads.pages.dev/archive/" + category.getName() + ".json", category);
                }
                catch (JsonParseException | IOException ex) {
                    NBTEditor.LOGGER.error("Failed to fetch heads for " + category.getName() + "! (OF)");
                    NBTEditor.LOGGER.error((Object)ex);
                    return null;
                }
            }
            result.put(category, heads);
        }
        this.updated = System.nanoTime();
        return result;
    }

    protected List<Head> gather(String url, Category category) throws IOException, JsonParseException {
        long start = System.currentTimeMillis();
        ArrayList<Head> heads = new ArrayList<Head>();
        Gson parser = new Gson();
        JsonArray array = (JsonArray)parser.fromJson(this.fetch(url), JsonArray.class);
        for (JsonElement o : array) {
            UUID uuid;
            JsonObject obj = o.getAsJsonObject();
            String rawUUID = obj.get("uuid").getAsString();
            if (Utils.validateUniqueId(rawUUID)) {
                uuid = UUID.fromString(rawUUID);
            } else {
                NBTEditor.LOGGER.debug("UUID " + rawUUID + " is invalid. Using random one for head id: " + this.id);
                uuid = UUID.randomUUID();
            }
            Head head = new Head(this.id).withName(obj.get("name").getAsString()).withUniqueId(uuid).withValue(obj.get("value").getAsString()).withTags(obj.get("tags").isJsonNull() ? "None" : obj.get("tags").getAsString()).withCategory(category);
            ++this.id;
            heads.add(head);
        }
        long elapsed = System.currentTimeMillis() - start;
        NBTEditor.LOGGER.debug(category.getName() + " -> Done! Time: " + elapsed + "ms (" + TimeUnit.MILLISECONDS.toSeconds(elapsed) + "s)");
        return heads;
    }

    protected String fetch(String url) throws IOException {
        StringBuilder response = new StringBuilder();
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setRequestProperty("User-Agent", "NBTEditor-DatabaseUpdater");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }

    public boolean update() {
        Map<Category, List<Head>> heads = this.getHeadsNoCache();
        if (heads == null) {
            NBTEditor.LOGGER.error("Failed to update database! Check above for any errors.");
            return false;
        }
        this.HEADS.clear();
        this.HEADS.putAll(heads);
        HeadAPI.resolveFavorites();
        return true;
    }

    public long getLastUpdate() {
        long now = System.nanoTime();
        long elapsed = now - this.updated;
        return TimeUnit.NANOSECONDS.toSeconds(elapsed);
    }

    public boolean isLastUpdateOld() {
        return this.getLastUpdate() >= this.refresh;
    }

    public long getTimeUntilLastUpdateOld() {
        return this.refresh - this.getLastUpdate();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getRefresh() {
        return this.refresh;
    }
}

