/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.ported;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import org.apache.commons.lang3.Validate;
import tsp.headdb.ported.Category;
import tsp.headdb.ported.Utils;

public class Head {
    private String name;
    private UUID uuid;
    private String value;
    private Category category;
    private int id;
    private List<String> tags;

    public Head() {
    }

    public Head(int id) {
        this.id = id;
    }

    public class_1799 getItemStack() {
        Validate.notNull((Object)this.name, (String)"name must not be null!", (Object[])new Object[0]);
        Validate.notNull((Object)this.uuid, (String)"uuid must not be null!", (Object[])new Object[0]);
        Validate.notNull((Object)this.value, (String)"value must not be null!", (Object[])new Object[0]);
        class_1799 item = new class_1799((class_1935)class_1802.field_8575);
        item.manager$setCustomName(TextInst.of(Utils.colorize(this.category != null ? String.valueOf(this.category.getColor()) + this.name : "&8" + this.name)));
        GameProfile profile = new GameProfile(this.uuid, NBTManagers.COMPONENTS_EXIST ? "HDB_Head" : this.name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", this.value));
        ItemTagReferences.PROFILE.set(item, Optional.of(profile));
        ItemTagReferences.LORE.set(item, Arrays.asList(Utils.colorize("&cID: " + this.id), Utils.colorize("&e" + this.buildTagLore(this.tags)), "", Utils.colorize("&8Right-Click to add/remove from favorites.")).stream().map(TextInst::of).toList());
        return item;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String getValue() {
        return this.value;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getId() {
        return this.id;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Head withName(String name) {
        this.name = name;
        return this;
    }

    public Head withUniqueId(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public Head withValue(String value) {
        this.value = value;
        return this;
    }

    public Head withCategory(Category category) {
        this.category = category;
        return this;
    }

    public Head withId(int id) {
        this.id = id;
        return this;
    }

    public Head withTags(String tags) {
        this.tags = Arrays.asList(tags.split(","));
        return this;
    }

    private String buildTagLore(List<String> tags) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            builder.append(tags.get(i));
            if (i == tags.size() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }
}

