/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.fancytext.FancyText;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class TextUtil {
    public static List<class_2561> getLongTranslatableTextLines(String key) {
        EditableText line;
        String str;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (int i = 1; i <= 50 && !(str = (line = TextInst.translatable(key + "_" + i, new Object[0])).getString()).equals(key + "_" + i); ++i) {
            if (str.startsWith("[LINK] ")) {
                String url = str.substring("[LINK] ".length());
                line = TextInst.literal(url).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_30938(Boolean.valueOf(true)).method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1065));
            }
            if (str.startsWith("[FORMAT] ")) {
                String toFormat = str.substring("[FORMAT] ".length());
                line = FancyText.parse(toFormat);
            }
            lines.add(line);
        }
        return lines;
    }

    public static class_2561 getLongTranslatableText(String key) {
        List<class_2561> lines = TextUtil.getLongTranslatableTextLines(key);
        if (lines.isEmpty()) {
            return TextInst.of(key);
        }
        EditableText output = TextInst.copy(lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            output.append("\n").append(lines.get(i));
        }
        return output;
    }

    public static class_2561 parseTranslatableFormatted(String key, Object ... args) {
        return FancyText.parse(TextInst.translatable(key, args).getString());
    }

    public static class_2561 substring(class_2561 text, final int start, final int end) {
        final EditableText output = TextInst.literal("");
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Boolean>(){
            private int i;

            public Optional<Boolean> accept(class_2583 style, String str) {
                if (this.i + str.length() <= start) {
                    this.i += str.length();
                    return Optional.empty();
                }
                if (this.i >= start) {
                    if (end >= 0 && this.i + str.length() > end) {
                        return this.accept(style, str.substring(0, end - this.i));
                    }
                    output.append(TextInst.literal(str).fillStyle(style));
                    this.i += str.length();
                    if (end >= 0 && this.i == end) {
                        return Optional.of(true);
                    }
                    return Optional.empty();
                }
                str = str.substring(start - this.i);
                this.i = start;
                this.accept(style, str);
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 substring(class_2561 text, int start) {
        return TextUtil.substring(text, start, -1);
    }

    public static class_2561 deleteCharAt(class_2561 text, int index) {
        EditableText output = TextInst.literal("");
        AtomicInteger pos = new AtomicInteger(0);
        text.method_27658((style, str) -> {
            int strLen = str.length();
            if (pos.getPlain() <= index && index < pos.getPlain() + strLen) {
                str = new StringBuilder(str).deleteCharAt(index - pos.getPlain()).toString();
            }
            if (!str.isEmpty()) {
                output.append(TextInst.literal(str).setStyle(style));
            }
            pos.setPlain(pos.getPlain() + strLen);
            return Optional.empty();
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 joinLines(List<class_2561> lines) {
        EditableText output = TextInst.literal("");
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0) {
                output.append("\n");
            }
            output.append(lines.get(i));
        }
        return output;
    }

    public static List<class_2561> splitText(class_2561 text) {
        int i;
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        while ((i = text.getString().indexOf(10)) != -1) {
            output.add(TextUtil.substring(text, 0, i));
            text = TextUtil.substring(text, i + 1);
        }
        output.add(text);
        return output;
    }

    public static class_2561 stripInvalidChars(class_2561 text, boolean allowLineBreaks) {
        EditableText output = TextInst.literal("");
        text.method_27658((style, str) -> {
            output.append(TextInst.literal(MVMisc.stripInvalidChars(str, allowLineBreaks)).setStyle(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 attachFileTextOptions(EditableText link, File file) {
        return link.append(" ").append(TextInst.translatable("nbteditor.file_options.show", new Object[0]).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsoluteFile().getParentFile().getAbsolutePath())))).append(" ").append(TextInst.translatable("nbteditor.file_options.delete", new Object[0]).styled(style -> MixinLink.withRunClickEvent(style, () -> MainUtil.client.method_1507((class_437)new FancyConfirmScreen(confirmed -> {
            if (confirmed) {
                if (file.exists()) {
                    try {
                        Files.deleteIfExists(file.toPath());
                        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.success", "\u00a76" + file.getName()), false);
                    }
                    catch (IOException e) {
                        NBTEditor.LOGGER.error("Error deleting file", (Throwable)e);
                        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.error", "\u00a76" + file.getName()), false);
                    }
                } else {
                    MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.missing", "\u00a76" + file.getName()), false);
                }
            }
            MainUtil.client.method_1507(null);
        }, TextInst.translatable("nbteditor.file_options.delete.title", file.getName()), TextInst.translatable("nbteditor.file_options.delete.desc", file.getName()))))));
    }

    public static boolean isTextFormatted(class_2561 text, class_2583 base) {
        if (StyleUtil.hasFormatting(text.method_10866(), base)) {
            return true;
        }
        for (class_2561 sibling : text.method_10855()) {
            if (!TextUtil.isTextFormatted(sibling, base)) continue;
            return true;
        }
        return false;
    }

    public static int lastIndexOf(class_2561 text, int ch) {
        AtomicInteger output = new AtomicInteger(-1);
        AtomicInteger pos = new AtomicInteger(0);
        text.method_27657(str -> {
            int i = str.lastIndexOf(ch);
            if (i != -1) {
                output.setPlain(pos.getPlain() + i);
            }
            pos.setPlain(pos.getPlain() + str.length());
            return Optional.empty();
        });
        return output.getPlain();
    }

    public static class_2561 fromJsonSafely(String json) {
        try {
            class_2561 output = TextInst.fromJson(json);
            if (output != null) {
                return output;
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return TextInst.of(json);
    }
}

