/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import net.minecraft.class_1304;

public class SlotUtil {
    public static int invToContainer(int slot) {
        if (slot < 0) {
            throw new IllegalArgumentException("Invalid slot index: " + slot);
        }
        if (slot < 9) {
            return slot + 36;
        }
        if (slot < 36) {
            return slot;
        }
        if (slot < 40) {
            return 8 - (slot - 36);
        }
        if (slot == 40) {
            return 45;
        }
        throw new IllegalArgumentException("Invalid slot index: " + slot);
    }

    public static int invToGeneric(int slot) {
        if (slot < 0) {
            throw new IllegalArgumentException("Invalid slot index: " + slot);
        }
        if (slot < 9) {
            return slot + 27;
        }
        if (slot < 36) {
            return slot - 9;
        }
        if (slot <= 40) {
            return slot;
        }
        throw new IllegalArgumentException("Invalid slot index: " + slot);
    }

    public static int containerToInv(int slot) {
        if (slot < 5) {
            throw new IllegalArgumentException("Invalid slot index: " + slot);
        }
        if (slot < 9) {
            return 8 - slot + 36;
        }
        if (slot < 36) {
            return slot;
        }
        if (slot < 45) {
            return slot - 36;
        }
        if (slot == 45) {
            return 40;
        }
        throw new IllegalArgumentException("Invalid slot index: " + slot);
    }

    public static int containerToGeneric(int slot) {
        return SlotUtil.invToGeneric(SlotUtil.containerToInv(slot));
    }

    public static int genericToInv(int slot) {
        if (slot < 0) {
            throw new IllegalArgumentException("Invalid slot index: " + slot);
        }
        if (slot < 27) {
            return slot + 9;
        }
        if (slot < 36) {
            return slot - 27;
        }
        if (slot <= 40) {
            return slot;
        }
        throw new IllegalArgumentException("Invalid slot index: " + slot);
    }

    public static int genericToContainer(int slot) {
        return SlotUtil.invToContainer(SlotUtil.genericToInv(slot));
    }

    public static boolean isHotbarFromInv(int slot) {
        return 0 <= slot && slot < 9;
    }

    public static int extractHotbarFromInv(int slot) {
        if (SlotUtil.isHotbarFromInv(slot)) {
            return slot;
        }
        throw new IllegalArgumentException("Invalid hotbar index: " + slot);
    }

    public static boolean isInventoryFromInv(int slot) {
        return 9 <= slot && slot < 36;
    }

    public static int extractInventoryFromInv(int slot) {
        if (SlotUtil.isInventoryFromInv(slot)) {
            return slot - 9;
        }
        throw new IllegalArgumentException("Invalid inventory index: " + slot);
    }

    public static boolean isArmorFromInv(int slot) {
        return 36 <= slot && slot < 40;
    }

    public static class_1304 extractArmorFromInv(int slot) {
        if (SlotUtil.isArmorFromInv(slot)) {
            return class_1304.values()[slot - 36 + 2];
        }
        throw new IllegalArgumentException("Invalid armor index: " + slot);
    }

    public static boolean isOffHandFromInv(int slot) {
        return slot == 40;
    }

    public static boolean isHotbarFromContainer(int slot) {
        return SlotUtil.isHotbarFromInv(SlotUtil.containerToInv(slot));
    }

    public static int extractHotbarFromContainer(int slot) {
        return SlotUtil.extractHotbarFromInv(SlotUtil.containerToInv(slot));
    }

    public static boolean isInventoryFromContainer(int slot) {
        return SlotUtil.isInventoryFromInv(SlotUtil.containerToInv(slot));
    }

    public static int extractInventoryFromContainer(int slot) {
        return SlotUtil.extractInventoryFromInv(SlotUtil.containerToInv(slot));
    }

    public static boolean isArmorFromContainer(int slot) {
        return SlotUtil.isArmorFromInv(SlotUtil.containerToInv(slot));
    }

    public static class_1304 extractArmorFromContainer(int slot) {
        return SlotUtil.extractArmorFromInv(SlotUtil.containerToInv(slot));
    }

    public static boolean isOffHandFromContainer(int slot) {
        return SlotUtil.isOffHandFromInv(SlotUtil.containerToInv(slot));
    }

    public static boolean isHotbarFromGeneric(int slot) {
        return SlotUtil.isHotbarFromInv(SlotUtil.genericToInv(slot));
    }

    public static int extractHotbarFromGeneric(int slot) {
        return SlotUtil.extractHotbarFromInv(SlotUtil.genericToInv(slot));
    }

    public static boolean isInventoryFromGeneric(int slot) {
        return SlotUtil.isInventoryFromInv(SlotUtil.genericToInv(slot));
    }

    public static int extractInventoryFromGeneric(int slot) {
        return SlotUtil.extractInventoryFromInv(SlotUtil.genericToInv(slot));
    }

    public static boolean isArmorFromGeneric(int slot) {
        return SlotUtil.isArmorFromInv(SlotUtil.genericToInv(slot));
    }

    public static class_1304 extractArmorFromGeneric(int slot) {
        return SlotUtil.extractArmorFromInv(SlotUtil.genericToInv(slot));
    }

    public static boolean isOffHandFromGeneric(int slot) {
        return SlotUtil.isOffHandFromInv(SlotUtil.genericToInv(slot));
    }

    public static int createHotbarInInv(int slot) {
        if (0 <= slot && slot < 9) {
            return slot;
        }
        throw new IllegalArgumentException("Invalid hotbar index: " + slot);
    }

    public static int createInventoryInInv(int slot) {
        if (0 <= slot && slot < 27) {
            return slot + 9;
        }
        throw new IllegalArgumentException("Invalid inventory index: " + slot);
    }

    public static int createArmorInInv(class_1304 slot) {
        if (slot.method_5925() == class_1304.class_1305.field_6178) {
            return slot.method_5927() + 36;
        }
        throw new IllegalArgumentException("Invalid armor index: " + String.valueOf(slot));
    }

    public static int createOffHandInInv() {
        return 40;
    }

    public static int createHotbarInContainer(int slot) {
        return SlotUtil.invToContainer(SlotUtil.createHotbarInInv(slot));
    }

    public static int createInventoryInContainer(int slot) {
        return SlotUtil.invToContainer(SlotUtil.createInventoryInInv(slot));
    }

    public static int createArmorInContainer(class_1304 slot) {
        return SlotUtil.invToContainer(SlotUtil.createArmorInInv(slot));
    }

    public static int createOffHandInContainer() {
        return SlotUtil.invToContainer(SlotUtil.createOffHandInInv());
    }

    public static int createHotbarInGeneric(int slot) {
        return SlotUtil.invToGeneric(SlotUtil.createHotbarInInv(slot));
    }

    public static int createInventoryInGeneric(int slot) {
        return SlotUtil.invToGeneric(SlotUtil.createInventoryInInv(slot));
    }

    public static int createArmorInGeneric(class_1304 slot) {
        return SlotUtil.invToGeneric(SlotUtil.createArmorInInv(slot));
    }

    public static int createOffHandInGeneric() {
        return SlotUtil.invToGeneric(SlotUtil.createOffHandInInv());
    }
}

