/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class SaveQueue<T> {
    private final String name;
    private final Consumer<T> onSave;
    private volatile boolean saving;
    private volatile boolean queuedSave;
    private volatile Thread saveThread;
    private final Queue<Optional<T>> infos;
    private final Queue<CompletableFuture<Void>> onFinished;
    private final boolean waitToCallFinish;

    public SaveQueue(String name, Consumer<T> onSave, boolean waitToCallFinish) {
        this.name = name;
        this.onSave = onSave;
        this.infos = new ConcurrentLinkedQueue<Optional<T>>();
        this.onFinished = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
        this.waitToCallFinish = waitToCallFinish;
    }

    public SaveQueue(String name, Runnable onSave, boolean waitToCallFinish) {
        this(name, (T info) -> onSave.run(), waitToCallFinish);
    }

    public synchronized CompletableFuture<Void> save(T info) {
        CompletableFuture<Void> output = new CompletableFuture<Void>();
        this.infos.add(Optional.ofNullable(info));
        this.onFinished.add(output);
        if (this.saving) {
            this.queuedSave = true;
            this.saveThread.interrupt();
        } else {
            this.saving = true;
            this.saveThread = new Thread(() -> {
                boolean rerun;
                do {
                    Throwable exception;
                    rerun = false;
                    try {
                        this.onSave.accept(this.infos.remove().orElse(null));
                        exception = null;
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    SaveQueue saveQueue = this;
                    synchronized (saveQueue) {
                        int maxSize;
                        if (!this.queuedSave || !this.waitToCallFinish) {
                            if (exception == null) {
                                this.onFinished.remove().complete(null);
                            } else {
                                this.onFinished.remove().completeExceptionally(exception);
                            }
                        }
                        if (this.onFinished.size() > 1) {
                            ArrayList currentOnFinished = new ArrayList();
                            while (!this.onFinished.isEmpty()) {
                                currentOnFinished.add(this.onFinished.remove());
                            }
                            this.onFinished.add(MainUtil.mergeFutures(currentOnFinished));
                        }
                        int n = maxSize = this.queuedSave ? 1 : 0;
                        while (this.infos.size() > maxSize) {
                            this.infos.remove();
                        }
                        if (this.queuedSave) {
                            this.queuedSave = false;
                            rerun = true;
                        } else {
                            this.saving = false;
                        }
                    }
                } while (rerun);
            }, "NBTEditor/Async/SaveQueue:" + this.name);
            this.saveThread.start();
        }
        return output;
    }

    public CompletableFuture<Void> save() {
        return this.save((T)null);
    }

    public void save(Runnable onFinished, T info) {
        ((CompletableFuture)this.save(info).thenAccept(v -> onFinished.run())).exceptionally(e -> {
            NBTEditor.LOGGER.error("Error saving something", e);
            return null;
        });
    }

    public void save(Runnable onFinished) {
        this.save(onFinished, null);
    }

    public boolean isSaving() {
        return this.saving;
    }
}

