/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PartitionedLock {
    private volatile boolean stopped = false;
    private final Lock globalLock = new ReentrantLock(true);
    private final Map<Integer, Lock> locks = new ConcurrentHashMap<Integer, Lock>();
    private volatile int globallyLocked = 0;
    private final Map<Integer, Integer> lockedPartitions = new ConcurrentHashMap<Integer, Integer>();

    public void stop() {
        this.stopped = true;
        ++this.globallyLocked;
        this.globalLock.lock();
        this.locks.values().forEach(Lock::lock);
    }

    private void checkStop(Integer partition) {
        if (this.stopped) {
            if (partition != null) {
                this.unlock(partition);
            } else {
                this.unlockAll();
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public void lockAll() {
        ++this.globallyLocked;
        this.globalLock.lock();
        this.locks.values().forEach(Lock::lock);
        this.checkStop(null);
    }

    public void unlockAll() {
        this.locks.values().forEach(Lock::unlock);
        this.locks.clear();
        this.globalLock.unlock();
        --this.globallyLocked;
    }

    public void lock(int partition) {
        this.lockedPartitions.compute(partition, (key, value) -> (value == null ? 0 : value) + 1);
        this.globalLock.lock();
        try {
            Lock lock = this.locks.get(partition);
            if (lock == null) {
                lock = new ReentrantLock(true);
            }
            lock.lock();
            this.locks.put(partition, lock);
        }
        finally {
            this.globalLock.unlock();
        }
        this.checkStop(partition);
    }

    public void unlock(int partition) {
        this.locks.remove(partition).unlock();
        this.lockedPartitions.compute(partition, (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
    }

    public boolean isAllLocked() {
        return this.globallyLocked > 0;
    }

    public boolean isLocked(int partition) {
        return this.globallyLocked > 0 || this.lockedPartitions.getOrDefault(partition, 0) > 0;
    }
}

