/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.async.UpdateCheckerThread;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ActionResult;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMatrix4f;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVShaders;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.util.SlotUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class MainUtil {
    public static final class_310 client = class_310.method_1551();
    private static final class_2960 LOGO = IdentifierInst.of("nbteditor", "textures/logo.png");
    private static final class_2960 LOGO_UPDATE_AVAILABLE = IdentifierInst.of("nbteditor", "textures/logo_update_available.png");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);

    public static void clickCreativeStack(class_1799 item, int slot) {
        if (NBTEditorClient.SERVER_CONN.isEditingAllowed()) {
            MVMisc.sendC2SPacket(new class_2873(slot, item.method_7972()));
        }
    }

    public static void dropCreativeStack(class_1799 item) {
        if (NBTEditorClient.SERVER_CONN.isEditingAllowed() && !item.method_7960()) {
            MVMisc.sendC2SPacket(new class_2873(-1, item.method_7972()));
        }
    }

    public static void saveItem(class_1268 hand, class_1799 item) {
        MainUtil.client.field_1724.method_6122(hand, item.method_7972());
        MainUtil.clickCreativeStack(item, hand == class_1268.field_5810 ? SlotUtil.createOffHandInContainer() : SlotUtil.createHotbarInContainer(MainUtil.client.field_1724.method_31548().field_7545));
    }

    public static void saveItem(class_1304 equipment, class_1799 item) {
        if (equipment == class_1304.field_6173) {
            MainUtil.saveItem(class_1268.field_5808, item);
        } else if (equipment == class_1304.field_6171) {
            MainUtil.saveItem(class_1268.field_5810, item);
        } else {
            MainUtil.client.field_1724.method_31548().field_7548.set(equipment.method_5927(), (Object)item.method_7972());
            MainUtil.clickCreativeStack(item, SlotUtil.createArmorInContainer(equipment));
        }
    }

    public static void saveItem(int slot, class_1799 item) {
        MainUtil.client.field_1724.method_31548().method_5447(slot, item.method_7972());
        MainUtil.clickCreativeStack(item, SlotUtil.invToContainer(slot));
    }

    public static void get(class_1799 item, boolean dropIfNoSpace) {
        class_1661 inv = MainUtil.client.field_1724.method_31548();
        int slot = inv.method_7390(item = item.method_7972());
        if (slot == -1) {
            slot = inv.method_7376();
        }
        if (slot == -1) {
            if (dropIfNoSpace) {
                if (item.method_7947() > item.method_7914()) {
                    item.method_7939(item.method_7914());
                }
                MainUtil.dropCreativeStack(item);
            }
        } else {
            item.method_7939(item.method_7947() + inv.method_5438(slot).method_7947());
            int overflow = 0;
            if (item.method_7947() > item.method_7914()) {
                overflow = item.method_7947() - item.method_7914();
                item.method_7939(item.method_7914());
            }
            MainUtil.saveItem(slot, item);
            if (overflow != 0) {
                item = item.method_7972();
                item.method_7939(overflow);
                MainUtil.get(item, false);
            }
        }
    }

    public static void getWithMessage(class_1799 item) {
        MainUtil.get(item, true);
        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.get.item", new Object[0]).append(item.method_7954()), false);
    }

    public static void renderLogo(class_4587 matrices) {
        MVDrawableHelper.drawTexture(matrices, UpdateCheckerThread.UPDATE_AVAILABLE ? LOGO_UPDATE_AVAILABLE : LOGO, 16, 16, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    public static void drawWrappingString(class_4587 matrices, class_327 renderer, String text, int x, int y, int maxWidth, int color, boolean centerHorizontal, boolean centerVertical) {
        maxWidth = Math.max(maxWidth, renderer.method_1727("ww"));
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Integer> spaces = new ArrayList<Integer>();
        StringBuilder currentPart = new StringBuilder();
        boolean wasUpperCase = false;
        for (char c : text.toCharArray()) {
            if (c == ' ') {
                wasUpperCase = false;
                parts.add(currentPart.toString());
                currentPart.setLength(0);
                spaces.add(parts.size());
                continue;
            }
            boolean upperCase = Character.isUpperCase(c);
            if (upperCase != wasUpperCase && !currentPart.isEmpty()) {
                if (wasUpperCase) {
                    parts.add(currentPart.substring(0, currentPart.length() - 1));
                    currentPart.delete(0, currentPart.length() - 1);
                } else {
                    parts.add(currentPart.toString());
                    currentPart.setLength(0);
                }
            }
            wasUpperCase = upperCase;
            currentPart.append(c);
        }
        if (!currentPart.isEmpty()) {
            parts.add(currentPart.toString());
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        Object line = "";
        int i = 0;
        for (String part : parts) {
            String partAddition = (!((String)line).isEmpty() && spaces.contains(i) ? " " : "") + part;
            if (renderer.method_1727((String)line + partAddition) > maxWidth) {
                if (!((String)line).isEmpty()) {
                    lines.add(line);
                    line = "";
                }
                if (renderer.method_1727(part) > maxWidth) {
                    int numChars;
                    do {
                        numChars = 1;
                        while (renderer.method_1727(part.substring(0, numChars)) < maxWidth) {
                            ++numChars;
                        }
                        lines.add(part.substring(0, --numChars));
                    } while (renderer.method_1727(part = part.substring(numChars)) >= maxWidth);
                    line = part;
                } else {
                    line = part;
                }
            } else {
                line = (String)line + partAddition;
            }
            ++i;
        }
        if (!((String)line).isEmpty()) {
            lines.add(line);
        }
        for (i = 0; i < lines.size(); ++i) {
            int n;
            line = (String)lines.get(i);
            Objects.requireNonNull(renderer);
            if (centerVertical) {
                Objects.requireNonNull(renderer);
                n = -9 * lines.size() / 2;
            } else {
                n = 0;
            }
            int offsetY = i * 9 + n;
            if (centerHorizontal) {
                MVDrawableHelper.drawCenteredTextWithShadow(matrices, renderer, TextInst.of((String)line), x, y + offsetY, color);
                continue;
            }
            MVDrawableHelper.drawTextWithShadow(matrices, renderer, TextInst.of((String)line), x, y + offsetY, color);
        }
    }

    public static String colorize(String text) {
        StringBuilder output = new StringBuilder();
        boolean colorCode = false;
        for (char c : text.toCharArray()) {
            if (c == '&') {
                colorCode = true;
                continue;
            }
            if (colorCode) {
                colorCode = false;
                if (("" + c).replaceAll("[0-9a-fA-Fk-oK-OrR]", "").isEmpty()) {
                    output.append('\u00a7');
                } else {
                    output.append('&');
                }
            }
            output.append(c);
        }
        if (colorCode) {
            output.append('&');
        }
        return output.toString();
    }

    public static String stripColor(String text) {
        return text.replaceAll("\\xA7[0-9a-fA-Fk-oK-OrR]", "");
    }

    public static class_2561 getBaseItemNameSafely(class_1799 item) {
        class_2561 name;
        if (NBTManagers.COMPONENTS_EXIST && (name = (class_2561)item.get(MVComponentType.ITEM_NAME)) != null) {
            return name;
        }
        return MVMisc.getName(item.method_7909());
    }

    public static class_2561 getCustomItemNameSafely(class_1799 item) {
        if (NBTManagers.COMPONENTS_EXIST) {
            return item.method_7964();
        }
        class_2487 nbt = item.manager$getNbt();
        if (nbt != null) {
            nbt = nbt.method_10562("display");
        }
        return MainUtil.getNbtNameSafely(nbt, "Name", () -> item.method_7909().method_7864(item));
    }

    public static class_2561 getNbtNameSafely(class_2487 nbt, String key, Supplier<class_2561> defaultName) {
        if (nbt != null && nbt.method_10573(key, 8)) {
            try {
                class_2561 text = TextInst.fromJson(nbt.method_10558(key));
                if (text != null) {
                    return text;
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return defaultName.get();
    }

    public static class_1767 getDyeColor(class_124 color) {
        switch (color) {
            case field_1075: {
                return class_1767.field_7951;
            }
            case field_1074: {
                return class_1767.field_7963;
            }
            case field_1078: {
                return class_1767.field_7966;
            }
            case field_1062: {
                return class_1767.field_7955;
            }
            case field_1058: {
                return class_1767.field_7966;
            }
            case field_1063: {
                return class_1767.field_7944;
            }
            case field_1077: {
                return class_1767.field_7942;
            }
            case field_1064: {
                return class_1767.field_7945;
            }
            case field_1079: {
                return class_1767.field_7964;
            }
            case field_1065: {
                return class_1767.field_7946;
            }
            case field_1080: {
                return class_1767.field_7967;
            }
            case field_1060: {
                return class_1767.field_7961;
            }
            case field_1076: {
                return class_1767.field_7954;
            }
            case field_1061: {
                return class_1767.field_7964;
            }
            case field_1068: {
                return class_1767.field_7952;
            }
            case field_1054: {
                return class_1767.field_7947;
            }
        }
        return class_1767.field_7957;
    }

    public static class_1799 copyAirable(class_1799 item) {
        if (NBTManagers.COMPONENTS_EXIST) {
            class_1799 output = item.method_56701((class_1935)item.method_7909(), item.method_7947());
            output.method_7912(item.method_7965());
            return output;
        }
        class_1799 output = new class_1799((class_1935)item.method_7909(), item.method_7947());
        output.method_7912(item.method_7965());
        if (item.manager$hasNbt()) {
            output.manager$setNbt(item.manager$getNbt());
        }
        return output;
    }

    public static class_1799 setType(class_1792 type, class_1799 item, int count) {
        if (NBTManagers.COMPONENTS_EXIST) {
            return item.method_56701((class_1935)type, count);
        }
        class_2487 fullData = item.manager$serialize(true);
        fullData.method_10582("id", MVRegistry.ITEM.getId(type).toString());
        fullData.method_10569("Count", count);
        return NBTManagers.ITEM.deserialize(fullData, true);
    }

    public static class_1799 setType(class_1792 type, class_1799 item) {
        return MainUtil.setType(type, item, item.method_7947());
    }

    public static <T> Event<T> newEvent(Class<T> clazz) {
        return EventFactory.createArrayBacked(clazz, listeners -> Proxy.newProxyInstance(MainUtil.class.getClassLoader(), new Class[]{clazz}, (obj, method, args) -> {
            for (Object listener : listeners) {
                ActionResult result = (ActionResult)((Object)((Object)((Object)method.invoke(listener, args))));
                if (result == ActionResult.PASS) continue;
                return result;
            }
            return ActionResult.PASS;
        }));
    }

    public static class_2487 readNBT(InputStream in) throws IOException {
        byte[] data = in.readAllBytes();
        try {
            return MVMisc.readCompressedNbt(new ByteArrayInputStream(data));
        }
        catch (ZipException e) {
            return MVMisc.readNbt(new ByteArrayInputStream(data));
        }
    }

    public static String getFormattedCurrentTime() {
        return DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static boolean equals(double a, double b) {
        return MainUtil.equals(a, b, 1.0E-5);
    }

    public static BufferedImage scaleImage(BufferedImage img, int width, int height) {
        Image temp = img.getScaledInstance(width, height, 4);
        BufferedImage output = new BufferedImage(width, height, 2);
        Graphics2D g = output.createGraphics();
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        return output;
    }

    public static int[] getMousePos() {
        double scale = client.method_22683().method_4495();
        int x = (int)(MainUtil.client.field_1729.method_1603() / scale);
        int y = (int)(MainUtil.client.field_1729.method_1604() / scale);
        return new int[]{x, y};
    }

    public static void mapMatrices(class_4587 matrices, int fromX, int fromY, int fromWidth, int fromHeight, int toX, int toY, int toWidth, int toHeight) {
        matrices.method_22904((double)toX, (double)toY, 0.0);
        matrices.method_22905((float)toWidth / (float)fromWidth, (float)toHeight / (float)fromHeight, 1.0f);
        matrices.method_22904((double)(-fromX), (double)(-fromY), 0.0);
    }

    public static Predicate<String> intPredicate(Supplier<Integer> min, Supplier<Integer> max, boolean allowEmpty) {
        return str -> {
            if (str.isEmpty()) {
                return allowEmpty;
            }
            if (str.equals("+")) {
                return allowEmpty && (max == null || (Integer)max.get() >= 0);
            }
            if (str.equals("-")) {
                return allowEmpty && (min == null || (Integer)min.get() <= 0);
            }
            try {
                int value = Integer.parseInt(str);
                return !(min != null && (Integer)min.get() > value || max != null && value > (Integer)max.get());
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    public static Predicate<String> intPredicate(Integer min, Integer max, boolean allowEmpty) {
        return MainUtil.intPredicate(() -> min, () -> max, allowEmpty);
    }

    public static Predicate<String> intPredicate() {
        return MainUtil.intPredicate((Supplier<Integer>)null, null, true);
    }

    public static Integer parseOptionalInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int parseDefaultInt(String str, int defaultValue) {
        Integer output = MainUtil.parseOptionalInt(str);
        if (output == null) {
            return defaultValue;
        }
        return output;
    }

    public static void fillShader(class_4587 matrices, MVShaders.MVShaderAndLayer shader, Consumer<class_4588> data, int x, int y, int width, int height) {
        int x1 = x;
        int y1 = y;
        int x2 = x + width;
        int y2 = y + height;
        MVMatrix4f matrix = MVMatrix4f.getPositionMatrix(matrices.method_23760());
        class_4588 vertexConsumer = MVMisc.beginDrawingShader(matrices, shader);
        matrix.applyToVertex(vertexConsumer, x1, y1, 0.0f).method_22913(0.0f, 0.0f);
        data.accept(vertexConsumer);
        MVMisc.nextVertex(vertexConsumer);
        matrix.applyToVertex(vertexConsumer, x1, y2, 0.0f).method_22913(0.0f, 1.0f);
        data.accept(vertexConsumer);
        MVMisc.nextVertex(vertexConsumer);
        matrix.applyToVertex(vertexConsumer, x2, y2, 0.0f).method_22913(1.0f, 1.0f);
        data.accept(vertexConsumer);
        MVMisc.nextVertex(vertexConsumer);
        matrix.applyToVertex(vertexConsumer, x2, y1, 0.0f).method_22913(1.0f, 0.0f);
        data.accept(vertexConsumer);
        MVMisc.nextVertex(vertexConsumer);
        RenderSystem.disableDepthTest();
        MVMisc.endDrawingShader(matrices, vertexConsumer);
        RenderSystem.enableDepthTest();
    }

    public static <T extends class_2520> T update(DSL.TypeReference typeRef, T nbt, int oldVersion) {
        return (T)((class_2520)client.method_1543().update(typeRef, new Dynamic((DynamicOps)class_2509.field_11560, nbt), oldVersion, Version.getDataVersion()).getValue());
    }

    public static <T extends class_2520> T updateDynamic(DSL.TypeReference typeRef, T nbt, class_2520 dataVersionTag, int defaultOldVersion) {
        int dataVersion = defaultOldVersion;
        if (dataVersionTag != null && dataVersionTag instanceof class_2514) {
            class_2514 num = (class_2514)dataVersionTag;
            dataVersion = num.method_10701();
        } else if (dataVersion == -1) {
            return nbt;
        }
        return MainUtil.update(typeRef, nbt, dataVersion);
    }

    public static class_2487 updateDynamic(DSL.TypeReference typeRef, class_2487 nbt, int defaultOldVersion) {
        return MainUtil.updateDynamic(typeRef, nbt, nbt.method_10580("DataVersion"), defaultOldVersion);
    }

    public static class_2487 updateDynamic(DSL.TypeReference typeRef, class_2487 nbt) {
        return MainUtil.updateDynamic(typeRef, nbt, -1);
    }

    public static class_2487 fillId(class_2487 nbt, String id) {
        if (!NBTManagers.COMPONENTS_EXIST) {
            return nbt;
        }
        if (!nbt.method_10573("id", 8)) {
            nbt.method_10582("id", id);
        }
        return nbt;
    }

    public static String addNamespace(String component) {
        if (component.contains(":")) {
            return component;
        }
        if (component.startsWith("!")) {
            return "!minecraft:" + component.substring(1);
        }
        return "minecraft:" + component;
    }

    public static <T> CompletableFuture<T> mergeFutures(List<CompletableFuture<T>> futures) {
        CompletableFuture output = new CompletableFuture();
        output.thenAccept(value -> futures.forEach(future -> future.complete(value)));
        output.exceptionally(e -> {
            futures.forEach(future -> future.completeExceptionally((Throwable)e));
            return null;
        });
        return output;
    }

    public static void setTextFieldValueSilently(class_342 widget, String text, boolean scrollToEnd) {
        widget.field_2092 = text;
        int cursor = scrollToEnd ? text.length() : 0;
        widget.method_1875(cursor);
        widget.method_1884(cursor);
    }
}

