/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LoadQueue<T> {
    private final String name;
    private final Function<Integer, T> onLoad;
    private volatile boolean loading;
    private volatile boolean queuedLoad;
    private volatile Thread loadThread;
    private final Queue<Integer> levels;
    private final Queue<CompletableFuture<T>> onFinished;
    private final boolean waitToCallFinish;

    public LoadQueue(String name, Function<Integer, T> onLoad, boolean waitToCallFinish) {
        this.name = name;
        this.onLoad = onLoad;
        this.levels = new ConcurrentLinkedQueue<Integer>();
        this.onFinished = new ConcurrentLinkedQueue<CompletableFuture<T>>();
        this.waitToCallFinish = waitToCallFinish;
    }

    public LoadQueue(String name, Supplier<T> onLoad, boolean waitToCallFinish) {
        this(name, (Integer level) -> onLoad.get(), waitToCallFinish);
    }

    public synchronized CompletableFuture<T> load(int level) {
        CompletableFuture output = new CompletableFuture();
        this.levels.add(level);
        this.onFinished.add(output);
        if (this.loading) {
            this.queuedLoad = true;
            this.loadThread.interrupt();
        } else {
            this.loading = true;
            this.loadThread = new Thread(() -> {
                boolean rerun;
                do {
                    RuntimeException exception;
                    Object loadedValue;
                    rerun = false;
                    try {
                        loadedValue = this.onLoad.apply(this.levels.remove());
                        exception = null;
                    }
                    catch (RuntimeException e) {
                        loadedValue = null;
                        exception = e;
                    }
                    LoadQueue loadQueue = this;
                    synchronized (loadQueue) {
                        if (!this.queuedLoad || !this.waitToCallFinish) {
                            if (exception == null) {
                                this.onFinished.remove().complete(loadedValue);
                            } else {
                                this.onFinished.remove().completeExceptionally(exception);
                            }
                        }
                        if (this.onFinished.size() > 1) {
                            ArrayList currentOnFinished = new ArrayList();
                            while (!this.onFinished.isEmpty()) {
                                currentOnFinished.add(this.onFinished.remove());
                            }
                            this.onFinished.add(MainUtil.mergeFutures(currentOnFinished));
                        }
                        if (this.levels.size() > 1) {
                            int maxLevel = Integer.MIN_VALUE;
                            while (!this.levels.isEmpty()) {
                                maxLevel = Math.max(maxLevel, this.levels.remove());
                            }
                            this.levels.add(maxLevel);
                        }
                        if (this.queuedLoad) {
                            this.queuedLoad = false;
                            rerun = true;
                        } else {
                            this.loading = false;
                        }
                    }
                } while (rerun);
            }, "NBTEditor/Async/LoadQueue:" + this.name);
            this.loadThread.start();
        }
        return output;
    }

    public CompletableFuture<T> load() {
        return this.load(0);
    }

    public void load(Consumer<T> onFinished, int level) {
        ((CompletableFuture)this.load(level).thenAccept((Consumer)onFinished)).exceptionally(e -> {
            NBTEditor.LOGGER.error("Error loading something", e);
            return null;
        });
    }

    public void load(Consumer<T> onFinished) {
        this.load(onFinished, 0);
    }

    public boolean isLoading() {
        return this.loading;
    }
}

