/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class CompletableFutureCache<T> {
    private final Supplier<CompletableFuture<T>> loader;
    private final ReadWriteLock lock;
    private volatile Status status;
    private volatile T value;
    private final Queue<CompletableFuture<T>> futures;

    public CompletableFutureCache(Supplier<CompletableFuture<T>> loader) {
        this.loader = loader;
        this.lock = new ReentrantReadWriteLock();
        this.status = Status.UNLOADED;
        this.futures = new ConcurrentLinkedQueue<CompletableFuture<T>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> get() {
        this.lock.readLock().lock();
        try {
            if (this.status == Status.LOADED) {
                CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(this.value);
                return completableFuture;
            }
            if (this.status == Status.LOADING) {
                CompletableFuture future = new CompletableFuture();
                this.futures.add(future);
                CompletableFuture completableFuture = future;
                return completableFuture;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        if (this.status != Status.UNLOADED) {
            this.lock.writeLock().unlock();
            return this.get();
        }
        try {
            CompletableFuture future = new CompletableFuture();
            this.futures.add(future);
            this.status = Status.LOADING;
            this.loader.get().thenAccept(loadedValue -> {
                this.lock.writeLock().lock();
                this.value = loadedValue;
                this.status = Status.LOADED;
                this.lock.writeLock().unlock();
                while (!this.futures.isEmpty()) {
                    this.futures.remove().complete(loadedValue);
                }
            });
            CompletableFuture completableFuture = future;
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        UNLOADED,
        LOADING,
        LOADED;

    }
}

