/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class BlockStateProperties {
    private final LinkedHashMap<String, BlockStateProperty> properties;

    public BlockStateProperties(class_2680 state) {
        this.properties = new LinkedHashMap();
        for (class_2769 property : state.method_28501()) {
            this.properties.put(property.method_11899(), new BlockStateProperty(property, state));
        }
    }

    public BlockStateProperties(class_2540 payload) {
        this.properties = new LinkedHashMap();
        int numProperties = payload.method_10816();
        for (int i = 0; i < numProperties; ++i) {
            String name = payload.method_19772();
            int valueIndex = payload.method_10816();
            ArrayList<String> options = new ArrayList<String>();
            int numOptions = payload.method_10816();
            for (int optionI = 0; optionI < numOptions; ++optionI) {
                options.add(payload.method_19772());
            }
            this.properties.put(name, new BlockStateProperty((String)options.get(valueIndex), options));
        }
    }

    private BlockStateProperties(BlockStateProperties toCopy) {
        this.properties = toCopy.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((BlockStateProperty)entry.getValue()).copy(), (a, b) -> {
            throw new RuntimeException("Impossible merge conflict!");
        }, LinkedHashMap::new));
    }

    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    public String getValue(String property) {
        return this.properties.get((Object)property).value;
    }

    public List<String> getOptions(String property) {
        return this.properties.get((Object)property).options;
    }

    public void setValue(String property, String value) {
        this.properties.get(property).setValue(value);
    }

    public class_2680 applyTo(class_2680 state) {
        Map properties = state.method_28501().stream().collect(Collectors.toMap(class_2769::method_11899, Function.identity()));
        if (!this.properties.keySet().equals(properties.keySet())) {
            throw new IllegalArgumentException("The provided BlockState doesn't have the same properties!");
        }
        for (Map.Entry<String, BlockStateProperty> property : this.properties.entrySet()) {
            state = this.applyPropertyTo(state, (class_2769)properties.get(property.getKey()), property.getValue().value);
        }
        return state;
    }

    private <T extends Comparable<T>> class_2680 applyPropertyTo(class_2680 state, class_2769<T> property, String value) {
        Comparable valueObj = ServerMVMisc.getValues(property).stream().filter(option -> property.method_11901(option).equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("The property value doesn't exist!"));
        return (class_2680)state.method_11657(property, valueObj);
    }

    public BlockStateProperties mapTo(class_2680 state) {
        BlockStateProperties properties = new BlockStateProperties(state);
        properties.properties.forEach((name, property) -> {
            BlockStateProperty prevProperty = this.properties.get(name);
            if (prevProperty != null && property.options.contains(prevProperty.value)) {
                property.value = prevProperty.value;
            }
        });
        return properties;
    }

    public class_2680 applyToSafely(class_2680 state) {
        return this.mapTo(state).applyTo(state);
    }

    public class_2487 getValues() {
        class_2487 output = new class_2487();
        for (Map.Entry<String, BlockStateProperty> property : this.properties.entrySet()) {
            output.method_10582(property.getKey(), property.getValue().value);
        }
        return output;
    }

    public Set<String> setValues(class_2487 blockStateTag) {
        HashSet<String> unset = new HashSet<String>(this.properties.keySet());
        for (String tag : blockStateTag.method_10541()) {
            String value;
            BlockStateProperty property;
            if (!blockStateTag.method_10573(tag, 8) || (property = this.properties.get(tag)) == null || !property.options.contains(value = blockStateTag.method_10558(tag))) continue;
            property.value = value;
            unset.remove(tag);
        }
        return unset;
    }

    public Map<String, String> getValuesMap() {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, BlockStateProperty> property : this.properties.entrySet()) {
            output.put(property.getKey(), property.getValue().value);
        }
        return output;
    }

    public Set<String> setValuesMap(Map<String, String> blockStateTag) {
        HashSet<String> unset = new HashSet<String>(this.properties.keySet());
        for (String tag : blockStateTag.keySet()) {
            String value;
            BlockStateProperty property = this.properties.get(tag);
            if (property == null || !property.options.contains(value = blockStateTag.get(tag))) continue;
            property.value = value;
            unset.remove(tag);
        }
        return unset;
    }

    public void writeToPayload(class_2540 payload) {
        payload.method_10804(this.properties.size());
        this.properties.forEach((name, property) -> {
            payload.method_10814(name);
            payload.method_10804(property.options.indexOf(property.value));
            payload.method_10804(property.options.size());
            property.options.forEach(arg_0 -> ((class_2540)payload).method_10814(arg_0));
        });
    }

    public BlockStateProperties copy() {
        return new BlockStateProperties(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockStateProperties) {
            BlockStateProperties state = (BlockStateProperties)obj;
            return this.properties.equals(state.properties);
        }
        return false;
    }

    public String toString() {
        return "[" + this.properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ((BlockStateProperty)entry.getValue()).value).reduce((a, b) -> a + "," + b).orElse("") + "]";
    }

    private class BlockStateProperty {
        private String value;
        private final List<String> options;

        public BlockStateProperty(String value, List<String> options) {
            if (!options.contains(value)) {
                throw new IllegalArgumentException("The current value must be an option!");
            }
            this.value = value;
            this.options = options;
        }

        public <T extends Comparable<T>> BlockStateProperty(class_2769<T> property, class_2680 state) {
            this(property.method_11901(state.method_11654(property)), ServerMVMisc.getValues(property).stream().map(option -> property.method_11901(option)).toList());
        }

        private void setValue(String value) {
            if (!this.options.contains(value)) {
                throw new IllegalArgumentException("The new value must be an option!");
            }
            this.value = value;
        }

        public BlockStateProperty copy() {
            return new BlockStateProperty(this.value, new ArrayList<String>(this.options));
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockStateProperty) {
                BlockStateProperty property = (BlockStateProperty)obj;
                return this.value.equals(property.value) && this.options.equals(property.options);
            }
            return false;
        }
    }
}

