/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_1887;

public class Enchants {
    private final List<EnchantWithLevel> enchants;

    public Enchants(List<EnchantWithLevel> enchants) {
        this.enchants = enchants;
    }

    public Enchants() {
        this.enchants = new ArrayList<EnchantWithLevel>();
    }

    public int size() {
        return this.enchants.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<EnchantWithLevel> getEnchants() {
        return this.enchants;
    }

    public int getLevel(class_1887 enchant) {
        return this.enchants.stream().filter(test -> test.enchant() == enchant).mapToInt(EnchantWithLevel::level).max().orElse(0);
    }

    public void addEnchant(class_1887 enchant, int level) {
        this.enchants.add(new EnchantWithLevel(enchant, level));
    }

    public void addEnchant(EnchantWithLevel enchant) {
        this.enchants.add(enchant);
    }

    public void addEnchants(Collection<EnchantWithLevel> enchants) {
        this.enchants.addAll(enchants);
    }

    public boolean removeEnchant(class_1887 enchant) {
        return this.enchants.removeIf(enchantWithLevel -> enchantWithLevel.enchant() == enchant);
    }

    public boolean removeEnchants(Collection<class_1887> enchants) {
        boolean output = false;
        for (class_1887 enchant : enchants) {
            output |= this.removeEnchant(enchant);
        }
        return output;
    }

    public boolean removeDuplicates() {
        LinkedHashMap<class_1887, Integer> enchants = new LinkedHashMap<class_1887, Integer>();
        for (EnchantWithLevel enchant : this.enchants) {
            enchants.put(enchant.enchant(), enchant.level());
        }
        if (this.enchants.size() == enchants.size()) {
            return false;
        }
        this.enchants.clear();
        enchants.forEach(this::addEnchant);
        return true;
    }

    public boolean setEnchant(class_1887 enchant, int level, boolean onlyUpgrade) {
        if (onlyUpgrade && level <= this.getLevel(enchant)) {
            return false;
        }
        boolean found = false;
        ListIterator<EnchantWithLevel> iter = this.enchants.listIterator();
        while (iter.hasNext()) {
            EnchantWithLevel enchantWithLevel = iter.next();
            if (enchantWithLevel.enchant() != enchant) continue;
            if (found) {
                iter.remove();
                continue;
            }
            iter.set(new EnchantWithLevel(enchant, level));
            found = true;
        }
        if (!found) {
            this.addEnchant(enchant, level);
        }
        return true;
    }

    public void setEnchant(EnchantWithLevel enchant, boolean onlyUpgrade) {
        this.setEnchant(enchant.enchant(), enchant.level(), onlyUpgrade);
    }

    public void setEnchants(Collection<EnchantWithLevel> enchants, boolean onlyUpgrade) {
        for (EnchantWithLevel enchant : enchants) {
            this.setEnchant(enchant, onlyUpgrade);
        }
    }

    public void replaceEnchants(Collection<EnchantWithLevel> enchants) {
        this.enchants.clear();
        this.enchants.addAll(enchants);
    }

    public void clearEnchants() {
        this.enchants.clear();
    }

    public record EnchantWithLevel(class_1887 enchant, int level) {
    }
}

